/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.ui.DomUIFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class InvocationCache {
    private static final Map<JavaMethodSignature, Invocation> ourCoreInvocations = new HashMap<JavaMethodSignature, Invocation>();
    private final Map<JavaMethodSignature, Invocation> myInvocations = new ConcurrentHashMap();

    private static void addCoreInvocations(Class<?> aClass) {
        for (final Method method : aClass.getDeclaredMethods()) {
            if ("equals".equals(method.getName())) {
                ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)method), new Invocation(){

                    @Override
                    public Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                        Object arg;
                        DomElement proxy = handler.getProxy();
                        if (proxy == (arg = args[0])) {
                            return true;
                        }
                        if (arg == null) {
                            return false;
                        }
                        if (arg instanceof DomElement) {
                            DomInvocationHandler handler1 = DomManagerImpl.getDomInvocationHandler(proxy);
                            return handler1 != null && handler1.equals((Object)DomManagerImpl.getDomInvocationHandler((DomElement)arg));
                        }
                        return false;
                    }
                });
                continue;
            }
            if ("hashCode".equals(method.getName())) {
                ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)method), new Invocation(){

                    @Override
                    public Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                        return handler.hashCode();
                    }
                });
                continue;
            }
            ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)method), new Invocation(){

                @Override
                public Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                    return method.invoke((Object)handler, args);
                }
            });
        }
    }

    public Invocation getInvocation(JavaMethodSignature method) {
        Invocation invocation = ourCoreInvocations.get(method);
        return invocation != null ? invocation : this.myInvocations.get(method);
    }

    public void putInvocation(JavaMethodSignature method, Invocation invocation) {
        this.myInvocations.put(method, invocation);
    }

    static {
        InvocationCache.addCoreInvocations(DomElement.class);
        InvocationCache.addCoreInvocations(Navigatable.class);
        InvocationCache.addCoreInvocations(AnnotatedElement.class);
        InvocationCache.addCoreInvocations(UserDataHolder.class);
        InvocationCache.addCoreInvocations(Object.class);
        try {
            ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)DomElement.class.getMethod("getXmlElement", new Class[0])), new Invocation(){

                @Override
                public Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                    return handler.getXmlElement();
                }
            });
            ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)DomElement.class.getMethod("getXmlTag", new Class[0])), new Invocation(){

                @Override
                public Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                    return handler.getXmlTag();
                }
            });
            ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)DomElement.class.getMethod("getParent", new Class[0])), new Invocation(){

                @Override
                public Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                    return handler.getParent();
                }
            });
            ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)DomElement.class.getMethod("accept", DomElementVisitor.class)), new Invocation(){

                @Override
                public Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                    handler.accept((DomElementVisitor)args[0]);
                    return null;
                }
            });
            ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)AnnotatedElement.class.getMethod("getAnnotation", Class.class)), new Invocation(){

                @Override
                public Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                    return handler.getAnnotation((Class)args[0]);
                }
            });
            ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)GenericAttributeValue.class.getMethod("getXmlAttribute", new Class[0])), new Invocation(){

                @Override
                public final Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                    return handler.getXmlElement();
                }
            });
            ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)GenericAttributeValue.class.getMethod("getXmlAttributeValue", new Class[0])), new Invocation(){

                @Override
                @Nullable
                public final Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                    XmlAttribute attribute = (XmlAttribute)handler.getXmlElement();
                    return attribute != null ? attribute.getValueElement() : null;
                }
            });
            final JavaMethod javaMethod = JavaMethod.getMethod(GenericValue.class, (JavaMethodSignature)JavaMethodSignature.getSignature((Method)DomUIFactory.GET_VALUE_METHOD));
            ourCoreInvocations.put(JavaMethodSignature.getSignature((Method)GenericDomValue.class.getMethod("getConverter", new Class[0])), new Invocation(){

                @Override
                public final Object invoke(DomInvocationHandler<?> handler, Object[] args) throws Throwable {
                    try {
                        return handler.getScalarConverter(javaMethod);
                    }
                    catch (Throwable e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof ProcessCanceledException) {
                            throw (ProcessCanceledException)cause;
                        }
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError();
        }
    }
}

