/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.project.Project;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import org.jetbrains.annotations.NotNull;

public class DomDeclarationSearcher
extends PomDeclarationSearcher {
    public void findDeclarationsAt(@NotNull PsiElement psiElement, int offsetInElement, Consumer<PomTarget> consumer) {
        GenericAttributeValue domElement;
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomDeclarationSearcher.findDeclarationsAt must not be null");
        }
        if (!(psiElement instanceof XmlToken)) {
            return;
        }
        IElementType tokenType = ((XmlToken)psiElement).getTokenType();
        DomManager domManager = DomManager.getDomManager((Project)psiElement.getProject());
        if (tokenType == XmlTokenType.XML_DATA_CHARACTERS && psiElement.getParent() instanceof XmlText && psiElement.getParent().getParent() instanceof XmlTag) {
            XmlTag tag = (XmlTag)psiElement.getParent().getParent();
            for (XmlText text : tag.getValue().getTextElements()) {
                if (!GenericValueReferenceProvider.hasInjections((PsiLanguageInjectionHost)text)) continue;
                return;
            }
            domElement = domManager.getDomElement(tag);
        } else if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && psiElement.getParent() instanceof XmlAttributeValue && psiElement.getParent().getParent() instanceof XmlAttribute) {
            PsiElement attributeValue = psiElement.getParent();
            if (GenericValueReferenceProvider.hasInjections((PsiLanguageInjectionHost)attributeValue)) {
                return;
            }
            domElement = domManager.getDomElement((XmlAttribute)attributeValue.getParent());
        } else {
            return;
        }
        if (!(domElement instanceof GenericDomValue)) {
            return;
        }
        NameValue nameValue = (NameValue)domElement.getAnnotation(NameValue.class);
        if (nameValue != null && nameValue.referencable()) {
            DomElement parent = domElement.getParent();
            assert (parent != null);
            DomTarget target = DomTarget.getTarget((DomElement)parent);
            if (target != null) {
                consumer.consume((Object)target);
            }
        }
    }
}

