/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ByteBufferMap;
import com.intellij.util.io.WriteableMap;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class WriteableMapAdapter<K, V>
implements WriteableMap<V> {
    private final Map<K, V> myMap;
    private final ByteBufferMap.KeyProvider myKeyProvider;
    private final K[] myKeys;

    public WriteableMapAdapter(Map<K, V> map, ByteBufferMap.KeyProvider provider) {
        this.myMap = map;
        this.myKeyProvider = provider;
        this.myKeys = this.myMap.keySet().toArray();
    }

    @Override
    public int[] getHashCodesArray() {
        int[] keyHashCodes = new int[this.myKeys.length];
        for (int i = 0; i < this.myKeys.length; ++i) {
            keyHashCodes[i] = this.myKeyProvider.hashCode(this.myKeys[i]);
        }
        return keyHashCodes;
    }

    @Override
    public V getValue(int n) {
        return this.myMap.get(this.myKeys[n]);
    }

    @Override
    public int getKeyLength(int n) {
        return this.myKeyProvider.length(this.myKeys[n]);
    }

    @Override
    public void writeKey(DataOutput out, int n) throws IOException {
        this.myKeyProvider.write(out, this.myKeys[n]);
    }
}

