/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ByteBufferMap;
import com.intellij.util.io.ByteBufferRADataInput;
import com.intellij.util.io.MappedBufferWrapper;
import com.intellij.util.io.RandomAccessDataInput;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ByteBufferIntObjectMap<V> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.ByteBufferMap");
    private final RandomAccessDataInput myBuffer;
    private final int myStartOffset;
    private final ByteBufferMap.ValueProvider<V> myValueProvider;
    private int myMod;
    private final int myEndOffset;

    public ByteBufferIntObjectMap(@NotNull MappedBufferWrapper buffer, int startOffset, int endOffset, @NotNull ByteBufferMap.ValueProvider<V> valueProvider) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/ByteBufferIntObjectMap.<init> must not be null");
        }
        if (valueProvider == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/io/ByteBufferIntObjectMap.<init> must not be null");
        }
        assert (startOffset < endOffset);
        this.myBuffer = new ByteBufferRADataInput(buffer);
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myValueProvider = valueProvider;
        this.myBuffer.setPosition(startOffset);
        try {
            this.myMod = this.myBuffer.readInt();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public V get(int key) {
        int hash = this.hash(key);
        int keyGroupOffset = this.readKeyGroupOffset(hash);
        if (keyGroupOffset == -1) {
            return null;
        }
        if (this.myStartOffset >= keyGroupOffset || keyGroupOffset >= this.myEndOffset) {
            LOG.error("keyGroupOffset = " + keyGroupOffset + " myStartOffset = " + this.myStartOffset + " myEndOffset = " + this.myEndOffset);
        }
        try {
            this.myBuffer.setPosition(keyGroupOffset);
            int keyGroupSize = this.myBuffer.readInt();
            assert (keyGroupSize > 0);
            for (int i = 0; i < keyGroupSize; ++i) {
                if (key == this.myBuffer.readInt()) {
                    int valueOffset = this.myBuffer.readInt();
                    assert (valueOffset > 0);
                    this.myBuffer.setPosition(this.myStartOffset + valueOffset);
                    return this.myValueProvider.get((DataInput)this.myBuffer);
                }
                this.myBuffer.readInt();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public TIntArrayList getKeys() {
        TIntArrayList result = new TIntArrayList();
        this.getKeys(result);
        return result;
    }

    public void getKeys(TIntArrayList dst) {
        try {
            this.myBuffer.setPosition(this.myStartOffset + 4);
            int firstKeyGroupOffset = -1;
            int lastKeyGroupOffset = -1;
            for (int i = 0; i < this.myMod; ++i) {
                int value = this.myBuffer.readInt();
                if (value == -1) continue;
                int offset = value + this.myStartOffset;
                if (firstKeyGroupOffset == -1) {
                    firstKeyGroupOffset = offset;
                }
                lastKeyGroupOffset = offset;
            }
            if (firstKeyGroupOffset == -1) {
                return;
            }
            assert (firstKeyGroupOffset > this.myStartOffset);
            assert (lastKeyGroupOffset > this.myStartOffset);
            assert (lastKeyGroupOffset >= firstKeyGroupOffset);
            int firstValueOffset = -1;
            this.myBuffer.setPosition(firstKeyGroupOffset);
            while (this.myBuffer.getPosition() <= lastKeyGroupOffset) {
                int groupSize = this.myBuffer.readInt();
                for (int i = 0; i < groupSize; ++i) {
                    dst.add(this.myBuffer.readInt());
                    int valueOffset = this.myBuffer.readInt();
                    if (firstValueOffset != -1) continue;
                    firstValueOffset = valueOffset + this.myStartOffset;
                }
            }
            assert (this.myBuffer.getPosition() == firstValueOffset);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private int readKeyGroupOffset(int hash) {
        this.myBuffer.setPosition(this.myStartOffset + 4 + 4 * hash);
        int offset = -1;
        try {
            offset = this.myBuffer.readInt();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        if (offset == -1) {
            return -1;
        }
        return offset + this.myStartOffset;
    }

    private int hash(int hashCode) {
        return Math.abs(hashCode) % this.myMod;
    }
}

