/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.tabs.FileColorConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileColorsModel
implements Cloneable {
    public static final String FILE_COLOR = "fileColor";
    private final List<FileColorConfiguration> myConfigurations;
    private final List<FileColorConfiguration> mySharedConfigurations;
    private Project myProject;

    FileColorsModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.<init> must not be null");
        }
        this.myProject = project;
        this.myConfigurations = new ArrayList<FileColorConfiguration>();
        this.mySharedConfigurations = new ArrayList<FileColorConfiguration>();
    }

    private FileColorsModel(@NotNull Project project, @NotNull List<FileColorConfiguration> regular, @NotNull List<FileColorConfiguration> shared) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.<init> must not be null");
        }
        if (regular == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.<init> must not be null");
        }
        if (shared == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.<init> must not be null");
        }
        this.myProject = project;
        this.myConfigurations = regular;
        this.mySharedConfigurations = shared;
    }

    public void save(Element e, boolean shared) {
        List<FileColorConfiguration> configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            configuration.save(e);
        }
    }

    public void load(Element e, boolean shared) {
        List<FileColorConfiguration> configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        configurations.clear();
        List list = e.getChildren(FILE_COLOR);
        for (Element child : list) {
            FileColorConfiguration configuration = FileColorConfiguration.load(child);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
    }

    public FileColorsModel clone() throws CloneNotSupportedException {
        ArrayList<FileColorConfiguration> regular = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myConfigurations) {
            regular.add(configuration.clone());
        }
        ArrayList<FileColorConfiguration> shared = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration sharedConfiguration : this.mySharedConfigurations) {
            shared.add(sharedConfiguration.clone());
        }
        return new FileColorsModel(this.myProject, regular, shared);
    }

    public void add(@NotNull FileColorConfiguration configuration, boolean shared) {
        List<FileColorConfiguration> configurations;
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.add must not be null");
        }
        List<FileColorConfiguration> list = configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        if (!configurations.contains(configuration)) {
            configurations.add(configuration);
        }
    }

    public void add(@NotNull String scopeName, @NotNull String colorName, boolean shared) {
        if (scopeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.add must not be null");
        }
        if (colorName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.add must not be null");
        }
        FileColorConfiguration configuration = new FileColorConfiguration();
        configuration.setScopeName(scopeName);
        configuration.setColorName(colorName);
        this.add(configuration, shared);
    }

    public void remove(@NotNull String scopeName, boolean shared) {
        if (scopeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.remove must not be null");
        }
        List<FileColorConfiguration> configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        FileColorConfiguration configuration = this.findConfiguration(scopeName, shared);
        if (configuration != null) {
            configurations.remove(configuration);
        }
    }

    @Nullable
    private FileColorConfiguration findConfiguration(String scopeName, boolean shared) {
        List<FileColorConfiguration> configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            if (!scopeName.equals(configuration.getScopeName())) continue;
            return configuration;
        }
        return null;
    }

    public boolean isShared(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.isShared must not be null");
        }
        return this.findConfiguration(scopeName, true) != null;
    }

    @Nullable
    public String getColor(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.getColor must not be null");
        }
        if (!psiFile.isValid()) {
            return null;
        }
        FileColorConfiguration configuration = this.findConfiguration(psiFile);
        if (configuration != null && configuration.isValid()) {
            return configuration.getColorName();
        }
        return null;
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull PsiFile colored) {
        NamedScopesHolder namedScopesHolder;
        NamedScope scope;
        if (colored == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsModel.findConfiguration must not be null");
        }
        for (FileColorConfiguration configuration : this.myConfigurations) {
            scope = NamedScopeManager.getScope((Project)this.myProject, (String)configuration.getScopeName());
            if (scope == null) continue;
            namedScopesHolder = NamedScopeManager.getHolder((Project)this.myProject, (String)configuration.getScopeName(), null);
            if (scope.getValue() == null || namedScopesHolder == null || !scope.getValue().contains(colored, namedScopesHolder)) continue;
            return configuration;
        }
        for (FileColorConfiguration configuration : this.mySharedConfigurations) {
            scope = NamedScopeManager.getScope((Project)this.myProject, (String)configuration.getScopeName());
            if (scope == null) continue;
            namedScopesHolder = NamedScopeManager.getHolder((Project)this.myProject, (String)configuration.getScopeName(), null);
            if (scope.getValue() == null || namedScopesHolder == null || !scope.getValue().contains(colored, namedScopesHolder)) continue;
            return configuration;
        }
        return null;
    }

    public boolean isShared(FileColorConfiguration configuration) {
        return this.mySharedConfigurations.contains(configuration);
    }

    public void remove(FileColorConfiguration configuration, boolean shared) {
        List<FileColorConfiguration> configurations = shared ? this.mySharedConfigurations : this.myConfigurations;
        configurations.remove(configuration);
    }

    public void setConfigurations(List<FileColorConfiguration> configurations, boolean shared) {
        if (shared) {
            this.mySharedConfigurations.clear();
            this.mySharedConfigurations.addAll(configurations);
        } else {
            this.myConfigurations.clear();
            this.myConfigurations.addAll(configurations);
        }
    }

    public boolean isColored(String scopeName, boolean shared) {
        return this.findConfiguration(scopeName, shared) != null;
    }

    public List<FileColorConfiguration> getLocalConfigurations() {
        return this.myConfigurations;
    }

    public List<FileColorConfiguration> getSharedConfigurations() {
        return this.mySharedConfigurations;
    }
}

