/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.growl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.growl.FoundationLibrary;
import com.intellij.ui.growl.ID;
import com.intellij.ui.growl.Selector;
import com.sun.jna.Native;
import java.io.UnsupportedEncodingException;

public class Foundation {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.growl.Foundation");
    private static final FoundationLibrary myFoundationLibrary;

    private Foundation() {
    }

    public static ID getClass(String className) {
        LOG.debug(String.format("calling objc_getClass(%s)", className));
        return myFoundationLibrary.objc_getClass(className);
    }

    public static Selector createSelector(String s) {
        return myFoundationLibrary.sel_registerName(s).initName(s);
    }

    public static ID invoke(ID id, Selector selector, Object ... args) {
        return myFoundationLibrary.objc_msgSend(id, selector, args);
    }

    public static ID cfString(String s) {
        try {
            byte[] utf16Bytes = s.getBytes("UTF-16LE");
            return myFoundationLibrary.CFStringCreateWithBytes(null, utf16Bytes, utf16Bytes.length, 0x14000100, (byte)0);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(x);
        }
    }

    public static void cfRetain(ID id) {
        myFoundationLibrary.CFRetain(id);
    }

    public static void cfRelease(ID id) {
        myFoundationLibrary.CFRelease(id);
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        myFoundationLibrary = (FoundationLibrary)Native.loadLibrary((String)"Foundation", FoundationLibrary.class);
    }
}

