/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import java.util.ArrayList;
import java.util.List;

public class MessageViewImpl
implements MessageView {
    private ToolWindow myToolWindow;
    private final List<Runnable> myPostponedRunnables = new ArrayList<Runnable>();

    public MessageViewImpl(final Project project, StartupManager startupManager, final ToolWindowManager toolWindowManager) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MessageViewImpl.this.myToolWindow = toolWindowManager.registerToolWindow(ToolWindowId.MESSAGES_WINDOW, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
                MessageViewImpl.this.myToolWindow.setIcon(IconLoader.getIcon((String)"/general/toolWindowMessages.png"));
                new ContentManagerWatcher(MessageViewImpl.this.myToolWindow, MessageViewImpl.this.getContentManager());
                for (Runnable postponedRunnable : MessageViewImpl.this.myPostponedRunnables) {
                    postponedRunnable.run();
                }
                MessageViewImpl.this.myPostponedRunnables.clear();
            }
        };
        if (project.isInitialized()) {
            runnable.run();
        } else {
            startupManager.registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        }
    }

    @Override
    public ContentManager getContentManager() {
        return this.myToolWindow.getContentManager();
    }

    @Override
    public void runWhenInitialized(Runnable runnable) {
        if (this.myToolWindow != null) {
            runnable.run();
        } else {
            this.myPostponedRunnables.add(runnable);
        }
    }
}

