/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.DocumentBasedComponent;
import com.intellij.ui.TextComponent;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTextField
extends JPanel
implements DocumentListener,
TextComponent,
DataProvider,
DocumentBasedComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.EditorTextField");
    public static final Key<Boolean> SUPPLEMENTARY_KEY = Key.create((String)"Supplementary");
    private Document myDocument;
    private final Project myProject;
    private FileType myFileType;
    private EditorEx myEditor;
    private Component myNextFocusable;
    private boolean myWholeTextSelected;
    private final ArrayList<DocumentListener> myDocumentListeners;
    private boolean myIsListenerInstalled;
    private boolean myIsViewer;
    private boolean myIsSupplementary;
    private boolean myInheritSwingFont;
    private Color myEnforcedBgColor;
    private boolean myUseTextFieldPreferredSize;

    public EditorTextField() {
        this("");
    }

    public EditorTextField(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/EditorTextField.<init> must not be null");
        }
        this(EditorFactory.getInstance().createDocument((CharSequence)text), null, (FileType)FileTypes.PLAIN_TEXT);
    }

    public EditorTextField(@NotNull String text, Project project, FileType fileType) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/EditorTextField.<init> must not be null");
        }
        this(EditorFactory.getInstance().createDocument((CharSequence)text), project, fileType, false);
    }

    public EditorTextField(Document document, Project project, FileType fileType) {
        this(document, project, fileType, false);
    }

    public EditorTextField(Document document, Project project, FileType fileType, boolean isViewer) {
        this.myEditor = null;
        this.myNextFocusable = null;
        this.myWholeTextSelected = false;
        this.myDocumentListeners = new ArrayList();
        this.myIsListenerInstalled = false;
        this.myInheritSwingFont = true;
        this.myEnforcedBgColor = null;
        this.myUseTextFieldPreferredSize = true;
        this.myIsViewer = isViewer;
        this.setDocument(document);
        this.myProject = project;
        this.myFileType = fileType;
        this.setLayout(new BorderLayout());
        this.enableEvents(8L);
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorTextField.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.pleaseHandleShiftTab();
    }

    private void pleaseHandleShiftTab() {
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new DelegatingToRootTraversalPolicy());
    }

    public void setSupplementary(boolean supplementary) {
        this.myIsSupplementary = supplementary;
        if (this.myEditor != null) {
            this.myEditor.putUserData(SUPPLEMENTARY_KEY, supplementary);
        }
    }

    public void setFontInheritedFromLAF(boolean b) {
        this.myInheritSwingFont = b;
        this.setDocument(this.myDocument);
    }

    public String getText() {
        return this.myDocument.getText();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.myEnforcedBgColor = bg;
        if (this.myEditor != null) {
            this.myEditor.setBackgroundColor(bg);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.add(listener);
        this.installDocumentListener();
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.remove(listener);
        this.uninstallDocumentListener(false);
    }

    public void beforeDocumentChange(DocumentEvent event) {
        for (DocumentListener documentListener : this.myDocumentListeners) {
            documentListener.beforeDocumentChange(event);
        }
    }

    public void documentChanged(DocumentEvent event) {
        for (DocumentListener documentListener : this.myDocumentListeners) {
            documentListener.documentChanged(event);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public void setDocument(Document document) {
        if (this.myDocument != null) {
            this.uninstallDocumentListener(true);
        }
        this.myDocument = document;
        this.installDocumentListener();
        if (this.myEditor == null) {
            return;
        }
        boolean isFocused = this.isFocusOwner();
        EditorEx editor = this.myEditor;
        this.myEditor = this.createEditor();
        this.releaseEditor(editor);
        this.add((Component)this.myEditor.getComponent(), "Center");
        this.validate();
        if (isFocused) {
            this.myEditor.getContentComponent().requestFocus();
        }
    }

    private void installDocumentListener() {
        if (this.myDocument != null && !this.myDocumentListeners.isEmpty() && !this.myIsListenerInstalled) {
            this.myIsListenerInstalled = true;
            this.myDocument.addDocumentListener((DocumentListener)this);
        }
    }

    private void uninstallDocumentListener(boolean force) {
        if (this.myDocument != null && this.myIsListenerInstalled && (force || this.myDocumentListeners.isEmpty())) {
            this.myIsListenerInstalled = false;
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }

    public void setText(final String text) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(EditorTextField.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        CaretModel caretModel;
                        EditorTextField.this.myDocument.replaceString(0, EditorTextField.this.myDocument.getTextLength(), (CharSequence)text);
                        if (EditorTextField.this.myEditor != null && (caretModel = EditorTextField.this.myEditor.getCaretModel()).getOffset() >= EditorTextField.this.myDocument.getTextLength()) {
                            caretModel.moveToOffset(EditorTextField.this.myDocument.getTextLength());
                        }
                    }
                }, null, null, UndoConfirmationPolicy.DEFAULT, EditorTextField.this.getDocument());
            }
        });
    }

    public void selectAll() {
        if (this.myEditor != null) {
            this.myEditor.getSelectionModel().setSelection(0, this.myDocument.getTextLength());
        } else {
            this.myWholeTextSelected = true;
        }
    }

    public void removeSelection() {
        if (this.myEditor != null) {
            this.myEditor.getSelectionModel().removeSelection();
        } else {
            this.myWholeTextSelected = false;
        }
    }

    public CaretModel getCaretModel() {
        return this.myEditor.getCaretModel();
    }

    @Override
    public boolean isFocusOwner() {
        if (this.myEditor != null) {
            return IJSwingUtilities.hasFocus(this.myEditor.getContentComponent());
        }
        return super.isFocusOwner();
    }

    void releaseEditor(final Editor editor) {
        this.remove(editor.getComponent());
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!editor.isDisposed()) {
                    EditorFactory.getInstance().releaseEditor(editor);
                }
            }
        };
        if (application.isUnitTestMode() || application.isDispatchThread()) {
            runnable.run();
        } else {
            application.invokeLater(runnable);
        }
    }

    @Override
    public void addNotify() {
        this.releaseEditor();
        boolean isFocused = this.isFocusOwner();
        this.myEditor = this.createEditor();
        this.add((Component)this.myEditor.getComponent(), "Center");
        super.addNotify();
        if (this.myNextFocusable != null) {
            this.myEditor.getContentComponent().setNextFocusableComponent(this.myNextFocusable);
            this.myNextFocusable = null;
        }
        this.revalidate();
        if (isFocused) {
            this.requestFocus();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.releaseEditor();
    }

    private void releaseEditor() {
        if (this.myEditor != null) {
            this.releaseEditor(this.myEditor);
            this.myEditor = null;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myEditor != null) {
            this.setupEditorFont(this.myEditor);
        }
    }

    protected EditorEx createEditor() {
        LOG.assertTrue(this.myDocument != null);
        EditorFactory factory = EditorFactory.getInstance();
        EditorEx editor = !this.myIsViewer ? (this.myProject != null ? (EditorEx)factory.createEditor(this.myDocument, this.myProject) : (EditorEx)factory.createEditor(this.myDocument)) : (this.myProject != null ? (EditorEx)factory.createViewer(this.myDocument, this.myProject) : (EditorEx)factory.createViewer(this.myDocument));
        EditorSettings settings = editor.getSettings();
        settings.setAdditionalLinesCount(0);
        settings.setAdditionalColumnsCount(1);
        settings.setRightMarginShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setLineNumbersShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setVirtualSpace(false);
        editor.setHorizontalScrollbarVisible(false);
        editor.setVerticalScrollbarVisible(false);
        settings.setLineCursorWidth(1);
        this.setupEditorFont(editor);
        if (this.myProject != null && this.myFileType != null) {
            editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFileType));
        }
        editor.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, null);
        editor.setOneLineMode(true);
        editor.getCaretModel().moveToOffset(this.myDocument.getTextLength());
        if (!this.shouldHaveBorder()) {
            editor.getScrollPane().setBorder(null);
        }
        if (this.myIsViewer) {
            editor.getSelectionModel().removeSelection();
        } else if (this.myWholeTextSelected) {
            editor.getSelectionModel().setSelection(0, this.myDocument.getTextLength());
        }
        editor.setBackgroundColor(this.getBackgroundColor(!this.myIsViewer));
        if (this.myUseTextFieldPreferredSize && !UIUtil.isUnderQuaquaLookAndFeel()) {
            editor.getComponent().setPreferredSize(new JTextField().getPreferredSize());
        }
        editor.putUserData(SUPPLEMENTARY_KEY, this.myIsSupplementary);
        editor.getContentComponent().setFocusCycleRoot(false);
        return editor;
    }

    private void setupEditorFont(EditorEx editor) {
        if (this.myInheritSwingFont) {
            editor.getColorsScheme().setEditorFontName(this.getFont().getFontName());
            editor.getColorsScheme().setEditorFontSize(this.getFont().getSize());
        }
    }

    protected boolean shouldHaveBorder() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            boolean bl = this.myIsViewer = !enabled;
            if (this.myEditor == null) {
                return;
            }
            EditorEx editor = this.myEditor;
            this.releaseEditor(editor);
            this.myEditor = this.createEditor();
            this.add((Component)this.myEditor.getComponent(), "Center");
            this.revalidate();
        }
    }

    private Color getBackgroundColor(boolean enabled) {
        if (this.myEnforcedBgColor != null) {
            return this.myEnforcedBgColor;
        }
        return enabled ? EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground() : UIUtil.getInactiveTextFieldBackgroundColor();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myEditor != null) {
            Insets defaultInsets;
            Dimension preferredSize = new Dimension(this.myEditor.getComponent().getPreferredSize());
            Insets insets = this.getInsets();
            if (insets != null) {
                preferredSize.width += insets.left;
                preferredSize.width += insets.right;
                preferredSize.height += insets.top;
                preferredSize.height += insets.bottom;
            }
            if ((defaultInsets = new JTextField().getInsets()) != null) {
                preferredSize.height -= defaultInsets.top;
                preferredSize.width -= defaultInsets.left;
            }
            return preferredSize;
        }
        return new Dimension(100, 20);
    }

    public void setUseTextFieldPreferredSize(boolean b) {
        this.myUseTextFieldPreferredSize = b;
    }

    @Override
    public Component getNextFocusableComponent() {
        if (this.myEditor == null && this.myNextFocusable == null) {
            return super.getNextFocusableComponent();
        }
        if (this.myEditor == null) {
            return this.myNextFocusable;
        }
        return this.myEditor.getContentComponent().getNextFocusableComponent();
    }

    @Override
    public void setNextFocusableComponent(Component aComponent) {
        if (this.myEditor != null) {
            this.myEditor.getContentComponent().setNextFocusableComponent(aComponent);
            return;
        }
        this.myNextFocusable = aComponent;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.isConsumed() || !this.myEditor.processKeyTyped(e)) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return true;
    }

    @Override
    public void requestFocus() {
        if (this.myEditor != null) {
            this.myEditor.getContentComponent().requestFocus();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.myEditor != null) {
            boolean b = this.myEditor.getContentComponent().requestFocusInWindow();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return b;
        }
        return super.requestFocusInWindow();
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    public Object getData(String dataId) {
        if (this.myEditor != null && this.myEditor.isRendererMode()) {
            return null;
        }
        if (PlatformDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    public void setNewDocumentAndFileType(FileType fileType, Document document) {
        this.myFileType = fileType;
        this.setDocument(document);
    }

    private static class DelegatingToRootTraversalPolicy
    extends FocusTraversalPolicy {
        private DelegatingToRootTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Container cycleRootAncestor = aContainer.getFocusCycleRootAncestor();
            return cycleRootAncestor.getFocusTraversalPolicy().getComponentAfter(cycleRootAncestor, aContainer);
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Container cycleRootAncestor = aContainer.getFocusCycleRootAncestor();
            return cycleRootAncestor.getFocusTraversalPolicy().getComponentBefore(cycleRootAncestor, aContainer);
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            Container cycleRootAncestor = aContainer.getFocusCycleRootAncestor();
            return cycleRootAncestor.getFocusTraversalPolicy().getFirstComponent(cycleRootAncestor);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            Container cycleRootAncestor = aContainer.getFocusCycleRootAncestor();
            return cycleRootAncestor.getFocusTraversalPolicy().getLastComponent(cycleRootAncestor);
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            Editor editor;
            Editor editor2 = editor = aContainer instanceof EditorTextField ? ((EditorTextField)aContainer).getEditor() : null;
            if (editor != null) {
                return editor.getContentComponent();
            }
            return aContainer;
        }
    }
}

