/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testIntegration.GotoTestOrCodeHandler;
import com.intellij.testIntegration.TestFinderHelper;

public class GotoTestOrCodeAction
extends BaseCodeInsightAction {
    protected CodeInsightActionHandler getHandler() {
        return new GotoTestOrCodeHandler();
    }

    protected boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        return true;
    }

    @Override
    public void update(AnActionEvent event) {
        Presentation p = event.getPresentation();
        p.setEnabled(false);
        Project project = (Project)event.getData(PlatformDataKeys.PROJECT);
        Editor editor = (Editor)event.getData(PlatformDataKeys.EDITOR);
        if (editor == null || project == null) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null) {
            return;
        }
        PsiElement element = GotoTestOrCodeHandler.getSelectedElement(editor, psiFile);
        if (element == null) {
            return;
        }
        p.setEnabled(true);
        if (TestFinderHelper.isTest(element)) {
            p.setText(ActionsBundle.message((String)"action.GotoTestSubject.text", (Object[])new Object[0]));
            p.setDescription(ActionsBundle.message((String)"action.GotoTestSubject.description", (Object[])new Object[0]));
        } else {
            p.setText(ActionsBundle.message((String)"action.GotoTest.text", (Object[])new Object[0]));
            p.setDescription(ActionsBundle.message((String)"action.GotoTest.description", (Object[])new Object[0]));
        }
    }
}

