/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReturnWrappedValue
extends FixableUsageInfo {
    private final PsiReturnStatement statement;

    public ReturnWrappedValue(PsiReturnStatement statement) {
        super((PsiElement)statement);
        this.statement = statement;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiMethodCallExpression returnValue = (PsiMethodCallExpression)this.statement.getReturnValue();
        assert (returnValue != null);
        PsiExpression qualifier = returnValue.getMethodExpression().getQualifierExpression();
        assert (qualifier != null);
        String newExpression = qualifier.getText();
        MutationUtils.replaceExpression(newExpression, (PsiExpression)returnValue);
    }
}

