/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageViewUtil;

public class RefactoringMessageUtil {
    public static String getIncorrectIdentifierMessage(String identifierName) {
        return RefactoringBundle.message((String)"0.is.not.a.legal.java.identifier", (Object[])new Object[]{identifierName});
    }

    public static String checkCanCreateClass(PsiDirectory destinationDirectory, String className) {
        PsiClass[] classes = JavaDirectoryService.getInstance().getClasses(destinationDirectory);
        VirtualFile file = destinationDirectory.getVirtualFile();
        for (PsiClass aClass : classes) {
            if (!className.equals(aClass.getName())) continue;
            return RefactoringBundle.message((String)"directory.0.already.contains.1.named.2", (Object[])new Object[]{file.getPresentableUrl(), UsageViewUtil.getType((PsiElement)aClass), className});
        }
        String fileName = className + ".java";
        return RefactoringMessageUtil.checkCanCreateFile(destinationDirectory, fileName);
    }

    public static String checkCanCreateFile(PsiDirectory destinationDirectory, String fileName) {
        VirtualFile file = destinationDirectory.getVirtualFile();
        VirtualFile child = file.findChild(fileName);
        if (child != null) {
            return RefactoringBundle.message((String)"directory.0.already.contains.a.file.named.1", (Object[])new Object[]{file.getPresentableUrl(), fileName});
        }
        return null;
    }

    public static String getGetterSetterMessage(String newName, String action, PsiMethod getter, PsiMethod setter) {
        String text = getter != null && setter != null ? RefactoringBundle.message((String)"getter.and.setter.methods.found.for.the.field.0", (Object[])new Object[]{newName, action}) : (getter != null ? RefactoringBundle.message((String)"getter.method.found.for.the.field.0", (Object[])new Object[]{newName, action}) : RefactoringBundle.message((String)"setter.method.found.for.the.field.0", (Object[])new Object[]{newName, action}));
        return text;
    }

    public static void showNotSupportedForJspClassesError(Project project, Editor editor, String refactoringName, String helpId) {
        String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"refactoring.is.not.supported.for.jsp.classes"));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)refactoringName, (String)helpId);
    }
}

