/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.util.containers.HashMap;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;

public class NameSuggestionsManager {
    private final TypeSelector myTypeSelector;
    private final NameSuggestionsField myNameField;
    private final NameSuggestionsGenerator myGenerator;
    private final HashMap<PsiType, SuggestedNameInfo> myTypesToSuggestions = new HashMap();

    public NameSuggestionsManager(TypeSelector typeSelector, NameSuggestionsField nameField, NameSuggestionsGenerator generator) {
        this.myTypeSelector = typeSelector;
        this.myNameField = nameField;
        this.myGenerator = generator;
        this.myTypeSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    NameSuggestionsManager.this.updateSuggestions(NameSuggestionsManager.this.myTypeSelector.getSelectedType());
                }
            }
        });
        this.updateSuggestions(this.myTypeSelector.getSelectedType());
    }

    public void nameSelected() {
        SuggestedNameInfo nameInfo = (SuggestedNameInfo)this.myTypesToSuggestions.get((Object)this.myTypeSelector.getSelectedType());
        if (nameInfo != null) {
            nameInfo.nameChoosen(this.myNameField.getEnteredName());
        }
    }

    private void updateSuggestions(PsiType selectedType) {
        SuggestedNameInfo nameInfo = (SuggestedNameInfo)this.myTypesToSuggestions.get((Object)selectedType);
        if (nameInfo == null) {
            nameInfo = this.myGenerator.getSuggestedNameInfo(selectedType);
            this.myTypesToSuggestions.put((Object)selectedType, (Object)nameInfo);
        }
        this.myNameField.setSuggestions(nameInfo.names);
    }

    public void setLabelsFor(JLabel typeSelectorLabel, JLabel nameLabel) {
        if (this.myTypeSelector.getFocusableComponent() != null) {
            typeSelectorLabel.setLabelFor(this.myTypeSelector.getFocusableComponent());
        }
        if (this.myNameField.getFocusableComponent() != null) {
            nameLabel.setLabelFor(this.myNameField.getFocusableComponent());
        }
    }
}

