/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;

class UsageHolder {
    private final SmartPsiElementPointer myElementPointer;
    private final SafeDeleteReferenceUsageInfo[] myUsages;
    private int myUnsafeUsages = -1;
    private int myNonCodeUsages = -1;

    public UsageHolder(PsiElement element, UsageInfo[] usageInfos) {
        this.myElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        ArrayList<SafeDeleteReferenceUsageInfo> elementUsages = new ArrayList<SafeDeleteReferenceUsageInfo>();
        for (UsageInfo usageInfo : usageInfos) {
            SafeDeleteReferenceUsageInfo referenceUsageInfo;
            if (!(usageInfo instanceof SafeDeleteReferenceUsageInfo) || (referenceUsageInfo = (SafeDeleteReferenceUsageInfo)usageInfo).getReferencedElement() != element) continue;
            elementUsages.add(referenceUsageInfo);
        }
        this.myUsages = elementUsages.toArray(new SafeDeleteReferenceUsageInfo[elementUsages.size()]);
    }

    public int getNonCodeUsagesNumber() {
        if (this.myNonCodeUsages < 0) {
            int nonCodeUsages = 0;
            for (SafeDeleteReferenceUsageInfo usage : this.myUsages) {
                if (!usage.isNonCodeUsage) continue;
                ++nonCodeUsages;
            }
            this.myNonCodeUsages = nonCodeUsages;
        }
        return this.myNonCodeUsages;
    }

    public int getUnsafeUsagesNumber() {
        if (this.myUnsafeUsages < 0) {
            int nonSafeUsages = 0;
            for (SafeDeleteReferenceUsageInfo usage : this.myUsages) {
                if (usage.isSafeDelete()) continue;
                ++nonSafeUsages;
            }
            this.myUnsafeUsages = nonSafeUsages;
        }
        return this.myUnsafeUsages;
    }

    public String getDescription() {
        int nonCodeUsages = this.getNonCodeUsagesNumber();
        int unsafeUsages = this.getUnsafeUsagesNumber();
        if (unsafeUsages == 0) {
            return null;
        }
        PsiElement element = this.myElementPointer.getElement();
        if (unsafeUsages == nonCodeUsages) {
            return RefactoringBundle.message((String)"0.has.1.usages.in.comments.and.strings", (Object[])new Object[]{RefactoringUIUtil.getDescription(element, true), unsafeUsages});
        }
        return RefactoringBundle.message((String)"0.has.1.usages.that.are.not.safe.to.delete.of.those.2", (Object[])new Object[]{RefactoringUIUtil.getDescription(element, true), unsafeUsages, nonCodeUsages});
    }
}

