/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.TitledHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DirectoryAsPackageRenameHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.DirectoryAsPackageRenameHandler");

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement element = PsiElementRenameHandler.getElement(dataContext);
        return element instanceof PsiDirectory && ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInContent(((PsiDirectory)element).getVirtualFile());
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/DirectoryAsPackageRenameHandler.invoke must not be null");
        }
        PsiElement element = PsiElementRenameHandler.getElement(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = file.findElementAt(editor.getCaretModel().getOffset());
        DirectoryAsPackageRenameHandler.doRename(element, project, nameSuggestionContext, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/DirectoryAsPackageRenameHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/rename/DirectoryAsPackageRenameHandler.invoke must not be null");
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element != null);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        DirectoryAsPackageRenameHandler.doRename(element, project, element, editor);
    }

    public static void doRename(PsiElement element, Project project, PsiElement nameSuggestionContext, Editor editor) {
        String qualifiedName;
        PsiDirectory psiDirectory = (PsiDirectory)element;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
        String string = qualifiedName = aPackage != null ? aPackage.getQualifiedName() : "";
        if (aPackage == null || qualifiedName.length() == 0 || !JavaPsiFacade.getInstance((Project)project).getNameHelper().isIdentifier(psiDirectory.getName())) {
            PsiElementRenameHandler.rename(element, project, nameSuggestionContext, editor);
        } else {
            PsiDirectory[] directories = aPackage.getDirectories();
            VirtualFile[] virtualFiles = aPackage.occursInPackagePrefixes();
            if (virtualFiles.length == 0 && directories.length == 1) {
                PsiElementRenameHandler.rename((PsiElement)aPackage, project, nameSuggestionContext, editor);
            } else {
                int ret;
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                boolean inLib = false;
                for (PsiDirectory directory : directories) {
                    inLib |= !projectFileIndex.isInContent(directory.getVirtualFile());
                }
                PsiDirectory[] projectDirectories = aPackage.getDirectories(GlobalSearchScope.projectScope((Project)project));
                if (inLib) {
                    String promptMessage = "Package '" + aPackage.getName() + "' contains directories in libraries which cannot be renamed. Do you want to rename current directory";
                    if (projectDirectories.length > 0) {
                        PsiDirectory[] psiDirectoryArray;
                        ret = Messages.showDialog((Project)project, (String)(promptMessage + " or all directories in project?"), (String)RefactoringBundle.message((String)"warning.title"), (String[])new String[]{RefactoringBundle.message((String)"rename.current.directory"), RefactoringBundle.message((String)"rename.directories"), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getWarningIcon());
                        if (ret == 0) {
                            PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                            psiDirectoryArray = psiDirectoryArray2;
                            psiDirectoryArray2[0] = psiDirectory;
                        } else {
                            psiDirectoryArray = projectDirectories;
                        }
                        DirectoryAsPackageRenameHandler.renameDirs(project, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectoryArray);
                    } else if (Messages.showDialog((Project)project, (String)(promptMessage + "?"), (String)RefactoringBundle.message((String)"warning.title"), (String[])new String[]{CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getWarningIcon()) == 0) {
                        DirectoryAsPackageRenameHandler.renameDirs(project, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectory);
                    }
                } else {
                    StringBuffer message = new StringBuffer();
                    RenameUtil.buildPackagePrefixChangedMessage(virtualFiles, message, qualifiedName);
                    DirectoryAsPackageRenameHandler.buildMultipleDirectoriesInPackageMessage(message, aPackage, directories);
                    message.append(RefactoringBundle.message((String)"directories.and.all.references.to.package.will.be.renamed", (Object[])new Object[]{psiDirectory.getVirtualFile().getPresentableUrl()}));
                    ret = Messages.showDialog((Project)project, (String)message.toString(), (String)RefactoringBundle.message((String)"warning.title"), (String[])new String[]{RefactoringBundle.message((String)"rename.package.button.text"), RefactoringBundle.message((String)"rename.directory.button.text"), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getWarningIcon());
                    if (ret == 0) {
                        PsiElementRenameHandler.rename((PsiElement)aPackage, project, nameSuggestionContext, editor);
                    } else if (ret == 1) {
                        DirectoryAsPackageRenameHandler.renameDirs(project, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectory);
                    }
                }
            }
        }
    }

    private static void renameDirs(final Project project, PsiElement nameSuggestionContext, Editor editor, PsiDirectory contextDirectory, final PsiPackage aPackage, final PsiDirectory ... dirsToRename) {
        RenameDialog dialog = new RenameDialog(project, (PsiElement)contextDirectory, nameSuggestionContext, editor){

            @Override
            protected void doAction() {
                final String newName = StringUtil.getQualifiedName((String)StringUtil.getPackageName((String)aPackage.getQualifiedName()), (String)this.getNewName());
                MoveDirectoryWithClassesProcessor moveProcessor = new MoveDirectoryWithClassesProcessor(project, dirsToRename, null, this.isSearchInComments(), this.isSearchInNonJavaFiles(), false, null){

                    @Override
                    public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                        return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(dir.getParentDirectory(), this.getNewName());
                    }

                    @Override
                    protected String getTargetName() {
                        return newName;
                    }

                    @Override
                    protected String getCommandName() {
                        return dirsToRename.length == 1 ? "Rename directory" : "Rename directories";
                    }
                };
                this.invokeRefactoring(moveProcessor);
            }
        };
        dialog.show();
    }

    public static void buildMultipleDirectoriesInPackageMessage(StringBuffer message, PsiPackage aPackage, PsiDirectory[] directories) {
        message.append(RefactoringBundle.message((String)"multiple.directories.correspond.to.package"));
        message.append(aPackage.getQualifiedName());
        message.append(" :\n\n");
        for (int i = 0; i < directories.length; ++i) {
            PsiDirectory directory = directories[i];
            if (i > 0) {
                message.append("\n");
            }
            message.append(directory.getVirtualFile().getPresentableUrl());
        }
    }

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.directory.title");
    }
}

