/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorComboWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RecentsManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class MoveFilesOrDirectoriesDialog
extends DialogWrapper {
    @NonNls
    private static final String RECENT_KEYS = "MoveFile.RECENT_KEYS";
    private JLabel myNameLabel;
    private EditorComboWithBrowseButton myTargetDirectoryField;
    private String myHelpID;
    private final Project myProject;
    private final Callback myCallback;
    private PsiDirectory myTargetDirectory;

    public MoveFilesOrDirectoriesDialog(Project project, Callback callback) {
        super(project, true);
        this.myProject = project;
        this.myCallback = callback;
        this.setTitle(RefactoringBundle.message((String)"move.title"));
        this.init();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetDirectoryField.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(IdeBorderFactory.createBorder());
        this.myNameLabel = new JLabel();
        panel.add((Component)this.myNameLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 8, 4, 8), 0, 0));
        panel.add((Component)new JLabel(RefactoringBundle.message((String)"move.files.to.directory.label")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 8, 4, 8), 0, 0));
        this.myTargetDirectoryField = new EditorComboWithBrowseButton(null, "", this.myProject, RECENT_KEYS);
        this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message((String)"select.target.directory"), RefactoringBundle.message((String)"the.file.will.be.moved.to.this.directory"), this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor(), EditorComboBox.COMPONENT_ACCESSOR);
        this.myTargetDirectoryField.setTextFieldPreferredWidth(60);
        panel.add((Component)((Object)this.myTargetDirectoryField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 4, 8), 0, 0));
        ((EditorComboBox)this.myTargetDirectoryField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                MoveFilesOrDirectoriesDialog.this.validateOKButton();
            }
        });
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myTargetDirectoryField);
        return panel;
    }

    public void setData(PsiElement[] psiElements, PsiDirectory initialTargetDirectory, @NonNls String helpID) {
        if (psiElements.length == 1) {
            String text = psiElements[0] instanceof PsiFile ? RefactoringBundle.message((String)"move.file.0", (Object[])new Object[]{((PsiFile)psiElements[0]).getVirtualFile().getPresentableUrl()}) : RefactoringBundle.message((String)"move.directory.0", (Object[])new Object[]{((PsiDirectory)psiElements[0]).getVirtualFile().getPresentableUrl()});
            this.myNameLabel.setText(text);
        } else {
            boolean isFile = true;
            boolean isDirectory = true;
            for (PsiElement psiElement : psiElements) {
                isFile &= psiElement instanceof PsiFile;
                isDirectory &= psiElement instanceof PsiDirectory;
            }
            this.myNameLabel.setText(isFile ? RefactoringBundle.message((String)"move.specified.files") : (isDirectory ? RefactoringBundle.message((String)"move.specified.directories") : RefactoringBundle.message((String)"move.specified.elements")));
        }
        this.myTargetDirectoryField.prependItem(initialTargetDirectory == null ? "" : initialTargetDirectory.getVirtualFile().getPresentableUrl());
        this.validateOKButton();
        this.myHelpID = helpID;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpID);
    }

    private void validateOKButton() {
        this.setOKActionEnabled(this.myTargetDirectoryField.getText().length() > 0);
    }

    protected void doOKAction() {
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENT_KEYS, this.myTargetDirectoryField.getText());
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        String directoryName = MoveFilesOrDirectoriesDialog.this.myTargetDirectoryField.getText().replace(File.separatorChar, '/');
                        try {
                            MoveFilesOrDirectoriesDialog.this.myTargetDirectory = DirectoryUtil.mkdirs(PsiManager.getInstance((Project)MoveFilesOrDirectoriesDialog.this.myProject), directoryName);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            // empty catch block
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        }, RefactoringBundle.message((String)"create.directory"), null);
        if (this.myTargetDirectory == null) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)RefactoringBundle.message((String)"cannot.create.directory"), (String)this.myHelpID, (Project)this.myProject);
            return;
        }
        this.myCallback.run(this);
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public static interface Callback {
        public void run(MoveFilesOrDirectoriesDialog var1);
    }
}

