/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.lang.java.JavaFindUsagesProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MoveClassesOrPackagesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil");

    private MoveClassesOrPackagesUtil() {
    }

    public static UsageInfo[] findUsages(PsiElement element, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName) {
        PsiManager manager = element.getManager();
        if (Comparing.equal((String)MoveClassesOrPackagesUtil.getQualfiedName(element), (String)newQName)) {
            return new UsageInfo[0];
        }
        ArrayList<UsageInfo> results = new ArrayList<UsageInfo>();
        HashSet<PsiReference> foundReferences = new HashSet<PsiReference>();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
        for (PsiReference reference : ReferencesSearch.search((PsiElement)element, (SearchScope)projectScope, (boolean)false)) {
            TextRange range = reference.getRangeInElement();
            if (foundReferences.contains(reference)) continue;
            results.add((UsageInfo)new MoveRenameUsageInfo(reference.getElement(), reference, range.getStartOffset(), range.getEndOffset(), element, false));
            foundReferences.add(reference);
        }
        MoveClassesOrPackagesUtil.findNonCodeUsages(searchInStringsAndComments, searchInNonJavaFiles, element, newQName, results);
        return results.toArray(new UsageInfo[results.size()]);
    }

    private static String getQualfiedName(PsiElement element) {
        PsiPackage aPackage;
        String oldQName = element instanceof PsiClass ? ((PsiClass)element).getQualifiedName() : (element instanceof PsiPackage ? ((PsiPackage)element).getQualifiedName() : (element instanceof PsiDirectory ? ((aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) != null ? aPackage.getQualifiedName() : null) : null));
        return oldQName;
    }

    public static void findNonCodeUsages(boolean searchInStringsAndComments, boolean searchInNonJavaFiles, PsiElement element, String newQName, ArrayList<UsageInfo> results) {
        if (searchInStringsAndComments || searchInNonJavaFiles) {
            String stringToSearch = MoveClassesOrPackagesUtil.getStringToSearch(element);
            if (stringToSearch == null) {
                return;
            }
            TextOccurrencesUtil.UsageInfoFactory factory = MoveClassesOrPackagesUtil.createUsageInfoFactory(element, newQName);
            if (searchInStringsAndComments) {
                TextOccurrencesUtil.addUsagesInStringsAndComments(element, stringToSearch, results, factory);
            }
            if (searchInNonJavaFiles) {
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
                TextOccurrencesUtil.addTextOccurences(element, stringToSearch, projectScope, results, factory);
            }
        }
    }

    private static TextOccurrencesUtil.UsageInfoFactory createUsageInfoFactory(final PsiElement element, final String newQName) {
        return new TextOccurrencesUtil.UsageInfoFactory(){

            @Override
            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                if (usage == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesUtil$1.createUsageInfo must not be null");
                }
                int start = usage.getTextRange().getStartOffset();
                return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start + startOffset), (int)(start + endOffset), (PsiElement)element, (String)newQName);
            }
        };
    }

    private static String getStringToSearch(PsiElement element) {
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        LOG.error("Unknown element type");
        return null;
    }

    public static PsiPackage doMovePackage(PsiPackage aPackage, MoveDestination moveDestination) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        PsiManager manager = aPackage.getManager();
        PackageWrapper targetPackage = moveDestination.getTargetPackage();
        String newPrefix = "".equals(targetPackage.getQualifiedName()) ? "" : targetPackage.getQualifiedName() + ".";
        String newPackageQualifiedName = newPrefix + aPackage.getName();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)aPackage.getProject());
        for (PsiDirectory dir : dirs = aPackage.getDirectories(projectScope)) {
            PsiDirectory targetDirectory = moveDestination.getTargetDirectory(dir);
            if (targetDirectory == null) continue;
            MoveClassesOrPackagesUtil.moveDirectoryRecursively(dir, targetDirectory);
        }
        aPackage.handleQualifiedNameChange(newPackageQualifiedName);
        return JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(newPackageQualifiedName);
    }

    public static void moveDirectoryRecursively(PsiDirectory dir, PsiDirectory destination) throws IncorrectOperationException {
        if (dir.getParentDirectory() == destination) {
            return;
        }
        MoveClassesOrPackagesUtil.moveDirectoryRecursively(dir, destination, new HashSet<VirtualFile>());
    }

    private static void moveDirectoryRecursively(PsiDirectory dir, PsiDirectory destination, HashSet<VirtualFile> movedPaths) throws IncorrectOperationException {
        PsiDirectory subdirectoryInDest;
        String sourcePackageName;
        PsiManager manager = dir.getManager();
        VirtualFile destVFile = destination.getVirtualFile();
        VirtualFile sourceVFile = dir.getVirtualFile();
        if (movedPaths.contains(sourceVFile)) {
            return;
        }
        String targetName = dir.getName();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        if (aPackage != null && !(sourcePackageName = aPackage.getName()).equals(targetName)) {
            targetName = sourcePackageName;
        }
        boolean isSourceRoot = RefactoringUtil.isSourceRoot(dir);
        if (VfsUtil.isAncestor((VirtualFile)sourceVFile, (VirtualFile)destVFile, (boolean)false) || isSourceRoot) {
            PsiDirectory exitsingSubdir = destination.findSubdirectory(targetName);
            if (exitsingSubdir == null) {
                subdirectoryInDest = destination.createSubdirectory(targetName);
                movedPaths.add(subdirectoryInDest.getVirtualFile());
            } else {
                subdirectoryInDest = exitsingSubdir;
            }
        } else {
            subdirectoryInDest = destination.findSubdirectory(targetName);
        }
        if (subdirectoryInDest == null) {
            VirtualFile virtualFile = dir.getVirtualFile();
            manager.moveDirectory(dir, destination);
            movedPaths.add(virtualFile);
        } else {
            PsiDirectory[] subdirectories;
            PsiFile[] files;
            for (PsiFile file : files = dir.getFiles()) {
                try {
                    subdirectoryInDest.checkAdd((PsiElement)file);
                }
                catch (IncorrectOperationException e) {
                    continue;
                }
                manager.moveFile(file, subdirectoryInDest);
            }
            for (PsiDirectory subdirectory : subdirectories = dir.getSubdirectories()) {
                if (subdirectory.equals(subdirectoryInDest)) continue;
                MoveClassesOrPackagesUtil.moveDirectoryRecursively(subdirectory, subdirectoryInDest, movedPaths);
            }
            if (!isSourceRoot && dir.getFiles().length == 0 && dir.getSubdirectories().length == 0) {
                dir.delete();
            }
        }
    }

    public static PsiClass doMoveClass(PsiClass aClass, PsiDirectory moveDestination) throws IncorrectOperationException {
        PsiClass newClass;
        for (MoveClassHandler handler : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            newClass = handler.doMoveClass(aClass, moveDestination);
            if (newClass == null) continue;
            return newClass;
        }
        PsiFile file = aClass.getContainingFile();
        PsiPackage newPackage = JavaDirectoryService.getInstance().getPackage(moveDestination);
        newClass = aClass;
        if (!moveDestination.equals(file.getContainingDirectory())) {
            aClass.getManager().moveFile(file, moveDestination);
            if (file instanceof PsiClassOwner && newPackage != null) {
                ((PsiClassOwner)file).setPackageName(newPackage.getQualifiedName());
            }
        }
        return newClass;
    }

    public static String getPackageName(PackageWrapper aPackage) {
        if (aPackage == null) {
            return null;
        }
        String name = aPackage.getQualifiedName();
        if (name.length() > 0) {
            return name;
        }
        return JavaFindUsagesProvider.DEFAULT_PACKAGE_NAME;
    }

    public static VirtualFile chooseSourceRoot(PackageWrapper targetPackage, VirtualFile[] contentSourceRoots, PsiDirectory initialDirectory) {
        Project project = targetPackage.getManager().getProject();
        ArrayList<PsiDirectory> targetDirectories = new ArrayList<PsiDirectory>();
        HashMap relativePathsToCreate = new HashMap();
        MoveClassesOrPackagesUtil.buildDirectoryList(targetPackage, contentSourceRoots, targetDirectories, (Map<PsiDirectory, String>)relativePathsToCreate);
        PsiDirectory selectedDirectory = DirectoryChooserUtil.chooseDirectory(targetDirectories.toArray(new PsiDirectory[targetDirectories.size()]), initialDirectory, project, (Map<PsiDirectory, String>)relativePathsToCreate);
        if (selectedDirectory == null) {
            return null;
        }
        VirtualFile virt = selectedDirectory.getVirtualFile();
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virt);
        LOG.assertTrue(sourceRootForFile != null);
        return sourceRootForFile;
    }

    private static void buildDirectoryList(PackageWrapper aPackage, VirtualFile[] contentSourceRoots, List<PsiDirectory> targetDirectories, Map<PsiDirectory, String> relativePathsToCreate) {
        block2: for (VirtualFile root : contentSourceRoots) {
            String qNameToCreate;
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = aPackage.getDirectories()) {
                if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
                targetDirectories.add(directory);
                continue block2;
            }
            try {
                qNameToCreate = RefactoringUtil.qNameToCreateInSourceRoot(aPackage, root);
            }
            catch (IncorrectOperationException e) {
                continue;
            }
            PsiDirectory currentDirectory = aPackage.getManager().findDirectory(root);
            if (currentDirectory == null) continue;
            String[] shortNames = qNameToCreate.split("\\.");
            for (int j = 0; j < shortNames.length; ++j) {
                String shortName = shortNames[j];
                PsiDirectory subdirectory = currentDirectory.findSubdirectory(shortName);
                if (subdirectory == null) {
                    targetDirectories.add(currentDirectory);
                    StringBuffer postfix = new StringBuffer();
                    for (int k = j; k < shortNames.length; ++k) {
                        String name = shortNames[k];
                        postfix.append(File.separatorChar);
                        postfix.append(name);
                    }
                    relativePathsToCreate.put(currentDirectory, postfix.toString());
                    continue block2;
                }
                currentDirectory = subdirectory;
            }
        }
    }
}

