/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.PackageLocalsUsageCollector;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classRefs.ClassInstanceScanner;
import com.intellij.refactoring.util.classRefs.ClassReferenceScanner;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MoveClassesOrPackagesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor");
    private final PsiElement[] myElementsToMove;
    private boolean mySearchInComments;
    private boolean mySearchInNonJavaFiles;
    private final PackageWrapper myTargetPackage;
    private final MoveCallback myMoveCallback;
    protected final MoveDestination myMoveDestination;
    protected NonCodeUsageInfo[] myNonCodeUsages;

    public MoveClassesOrPackagesProcessor(Project project, PsiElement[] elements, MoveDestination moveDestination, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback) {
        super(project);
        ArrayList<PsiElement> toMove = new ArrayList<PsiElement>();
        for (PsiElement element : elements) {
            if (element instanceof PsiJavaFile) {
                Collections.addAll(toMove, ((PsiJavaFile)element).getClasses());
                continue;
            }
            toMove.add(element);
        }
        this.myElementsToMove = toMove.toArray(new PsiElement[toMove.size()]);
        this.myMoveDestination = moveDestination;
        this.myTargetPackage = this.myMoveDestination.getTargetPackage();
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        PsiElement[] elements = new PsiElement[this.myElementsToMove.length];
        System.arraycopy(this.myElementsToMove, 0, elements, 0, this.myElementsToMove.length);
        return new MoveClassesOrPackagesViewDescriptor(elements, this.mySearchInComments, this.mySearchInNonJavaFiles, MoveClassesOrPackagesUtil.getPackageName(this.myTargetPackage));
    }

    public boolean verifyValidPackageName() {
        String qName = this.myTargetPackage.getQualifiedName();
        if (StringUtil.isEmpty((String)qName)) {
            if (this.hasClasses()) {
                Messages.showMessageDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"invalid.target.package.name.default.package"), (String)"Cannot Move", (Icon)Messages.getErrorIcon());
                return false;
            }
        } else {
            PsiNameHelper helper = JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper();
            if (!helper.isQualifiedName(qName)) {
                Messages.showMessageDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"invalid.target.package.name.specified"), (String)"Invalid Package Name", (Icon)Messages.getErrorIcon());
                return false;
            }
        }
        return true;
    }

    private boolean hasClasses() {
        for (PsiElement element : this.getElements()) {
            if (!(element instanceof PsiClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this.mySearchInNonJavaFiles;
    }

    public void setSearchInComments(boolean searchInComments) {
        this.mySearchInComments = searchInComments;
    }

    public void setSearchInNonJavaFiles(boolean searchInNonJavaFiles) {
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> allUsages = new ArrayList<UsageInfo>();
        MultiMap conflicts = new MultiMap();
        for (PsiElement element : this.myElementsToMove) {
            String newName = this.getNewQName(element);
            UsageInfo[] usages = MoveClassesOrPackagesUtil.findUsages(element, this.mySearchInComments, this.mySearchInNonJavaFiles, newName);
            allUsages.addAll(new ArrayList<UsageInfo>(Arrays.asList(usages)));
        }
        this.myMoveDestination.analyzeModuleConflicts(Arrays.asList(this.myElementsToMove), conflicts, allUsages.toArray(new UsageInfo[allUsages.size()]));
        UsageInfo[] usageInfos = allUsages.toArray(new UsageInfo[allUsages.size()]);
        this.detectPackageLocalsMoved(usageInfos, (MultiMap<PsiElement, String>)conflicts);
        this.detectPackageLocalsUsed((MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty()) {
            allUsages.add(new ConflictsUsageInfo(this.myElementsToMove[0], (MultiMap<PsiElement, String>)conflicts));
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(allUsages.toArray(new UsageInfo[allUsages.size()]));
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    public List<PsiElement> getElements() {
        return Collections.unmodifiableList(Arrays.asList(this.myElementsToMove));
    }

    public PackageWrapper getTargetPackage() {
        return this.myMoveDestination.getTargetPackage();
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        ArrayList<UsageInfo> filteredUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof ConflictsUsageInfo) {
                ConflictsUsageInfo info = (ConflictsUsageInfo)usage;
                PsiElement element = info.getElement();
                for (String conflict : info.getConflicts().values()) {
                    conflicts.putValue((Object)element, (Object)conflict);
                }
                continue;
            }
            filteredUsages.add(usage);
        }
        refUsages.set((Object)filteredUsages.toArray(new UsageInfo[filteredUsages.size()]));
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    private boolean isInsideMoved(PsiElement place) {
        for (PsiElement element : this.myElementsToMove) {
            if (!(element instanceof PsiClass) || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)place, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void detectPackageLocalsUsed(MultiMap<PsiElement, String> conflicts) {
        PackageLocalsUsageCollector visitor = new PackageLocalsUsageCollector(this.myElementsToMove, this.myTargetPackage, conflicts);
        for (PsiElement element : this.myElementsToMove) {
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)element;
            aClass.accept((PsiElementVisitor)visitor);
        }
    }

    private void detectPackageLocalsMoved(UsageInfo[] usages, MultiMap<PsiElement, String> conflicts) {
        HashSet<PsiClass> movedClasses = new HashSet<PsiClass>();
        HashMap reportedClassToContainers = new HashMap();
        PackageWrapper aPackage = this.myTargetPackage;
        for (UsageInfo usage : usages) {
            PsiDirectory directory;
            String visibility;
            PsiElement element = usage.getElement();
            if (element == null || !(usage instanceof MoveRenameUsageInfo) || usage instanceof NonCodeUsageInfo || !(((MoveRenameUsageInfo)usage).getReferencedElement() instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)((MoveRenameUsageInfo)usage).getReferencedElement();
            if (!movedClasses.contains(aClass)) {
                movedClasses.add(aClass);
            }
            if (!"packageLocal".equals(visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList())) || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null) continue;
            PsiElement container = ConflictsUtil.getContainer(element);
            HashSet<PsiElement> reported = (HashSet<PsiElement>)reportedClassToContainers.get((Object)aClass);
            if (reported == null) {
                reported = new HashSet<PsiElement>();
                reportedClassToContainers.put((Object)aClass, reported);
            }
            if (reported.contains(container)) continue;
            reported.add(container);
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null || this.isInsideMoved(element) || (directory = containingFile.getContainingDirectory()) == null) continue;
            PsiPackage usagePackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null || usagePackage == null || aPackage.equalToPackage(usagePackage)) continue;
            String message = RefactoringBundle.message((String)"a.package.local.class.0.will.no.longer.be.accessible.from.1", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)aClass.getName()), RefactoringUIUtil.getDescription(container, true)});
            conflicts.putValue((Object)aClass, (Object)message);
        }
        MyClassInstanceReferenceVisitor instanceReferenceVisitor = new MyClassInstanceReferenceVisitor(conflicts);
        for (PsiClass aClass : movedClasses) {
            String visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList());
            if ("packageLocal".equals(visibility)) {
                MoveClassesOrPackagesProcessor.findInstancesOfPackageLocal(aClass, usages, instanceReferenceVisitor);
                continue;
            }
            MoveClassesOrPackagesProcessor.findPublicClassConflicts(aClass, instanceReferenceVisitor);
        }
    }

    private static void findPublicClassConflicts(PsiClass aClass, final MyClassInstanceReferenceVisitor instanceReferenceVisitor) {
        NonPublicClassMemberWrappersSet members = new NonPublicClassMemberWrappersSet();
        members.addElements((PsiMember[])aClass.getFields());
        members.addElements((PsiMember[])aClass.getMethods());
        members.addElements((PsiMember[])aClass.getInnerClasses());
        final RefactoringUtil.IsDescendantOf isDescendantOf = new RefactoringUtil.IsDescendantOf(aClass);
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(aClass.getContainingFile().getContainingDirectory());
        GlobalSearchScope packageScope = aPackage == null ? aClass.getResolveScope() : PackageScope.packageScopeWithoutLibraries((PsiPackage)aPackage, (boolean)false);
        for (final ClassMemberWrapper memberWrapper : members) {
            ReferencesSearch.search((PsiElement)memberWrapper.getMember(), (SearchScope)packageScope, (boolean)false).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiElement element = reference.getElement();
                    if (element instanceof PsiReferenceExpression) {
                        PsiReferenceExpression expression = (PsiReferenceExpression)element;
                        PsiExpression qualifierExpression = expression.getQualifierExpression();
                        if (qualifierExpression != null) {
                            PsiClass resolvedTypeClass;
                            PsiType type = qualifierExpression.getType();
                            if (type != null && isDescendantOf.value(resolvedTypeClass = PsiUtil.resolveClassInType((PsiType)type))) {
                                instanceReferenceVisitor.visitMemberReference(memberWrapper.getMember(), expression, isDescendantOf);
                            }
                        } else {
                            instanceReferenceVisitor.visitMemberReference(memberWrapper.getMember(), expression, isDescendantOf);
                        }
                    }
                    return true;
                }
            });
        }
    }

    private static void findInstancesOfPackageLocal(final PsiClass aClass, final UsageInfo[] usages, MyClassInstanceReferenceVisitor instanceReferenceVisitor) {
        ClassReferenceScanner referenceScanner = new ClassReferenceScanner(aClass){

            @Override
            public PsiReference[] findReferences() {
                ArrayList<PsiReference> result = new ArrayList<PsiReference>();
                for (UsageInfo usage : usages) {
                    PsiReference reference;
                    if (!(usage instanceof MoveRenameUsageInfo) || ((MoveRenameUsageInfo)usage).getReferencedElement() != aClass || (reference = usage.getReference()) == null) continue;
                    result.add(reference);
                }
                return result.toArray(new PsiReference[result.size()]);
            }
        };
        referenceScanner.processReferences(new ClassInstanceScanner(aClass, instanceReferenceVisitor));
    }

    private String getNewQName(PsiElement element) {
        String qualifiedName = this.myTargetPackage.getQualifiedName();
        if (element instanceof PsiClass) {
            return qualifiedName + (qualifiedName.length() == 0 ? "" : ".") + ((PsiClass)element).getName();
        }
        if (element instanceof PsiPackage) {
            return qualifiedName + (qualifiedName.length() == 0 ? "" : ".") + ((PsiPackage)element).getName();
        }
        LOG.assertTrue(false);
        return null;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(elements.length == this.myElementsToMove.length);
        System.arraycopy(elements, 0, this.myElementsToMove, 0, elements.length);
    }

    @Override
    protected boolean isPreviewUsages(UsageInfo[] usages) {
        if (UsageViewUtil.hasNonCodeUsages(usages)) {
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"occurrences.found.in.comments.strings.and.non.java.files"));
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        try {
            HashMap oldToNewElementsMapping = new HashMap();
            for (int idx = 0; idx < this.myElementsToMove.length; ++idx) {
                PsiPackage newElement;
                PsiElement element = this.myElementsToMove[idx];
                RefactoringElementListener elementListener = this.getTransaction().getElementListener(element);
                if (element instanceof PsiPackage) {
                    newElement = MoveClassesOrPackagesUtil.doMovePackage((PsiPackage)element, this.myMoveDestination);
                    oldToNewElementsMapping.put(element, newElement);
                    element = newElement;
                } else if (element instanceof PsiClass) {
                    ChangeContextUtil.encodeContextInfo(element, true);
                    newElement = MoveClassesOrPackagesUtil.doMoveClass((PsiClass)element, this.myMoveDestination.getTargetDirectory(element.getContainingFile()));
                    oldToNewElementsMapping.put(element, newElement);
                    element = newElement;
                } else {
                    LOG.error("Unexpected element to move: " + element);
                }
                elementListener.elementMoved(element);
                this.myElementsToMove[idx] = element;
            }
            for (PsiElement element : this.myElementsToMove) {
                if (!(element instanceof PsiClass)) continue;
                ChangeContextUtil.decodeContextInfo(element, null, null);
            }
            this.myNonCodeUsages = MoveClassesOrPackagesProcessor.retargetUsages(usages, (Map<PsiElement, PsiElement>)oldToNewElementsMapping);
        }
        catch (IncorrectOperationException e) {
            this.myNonCodeUsages = new NonCodeUsageInfo[0];
            RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
        }
    }

    public static NonCodeUsageInfo[] retargetUsages(UsageInfo[] usages, Map<PsiElement, PsiElement> oldToNewElementsMapping) throws IncorrectOperationException {
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof NonCodeUsageInfo) {
                nonCodeUsages.add((NonCodeUsageInfo)usage);
                continue;
            }
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsage = (MoveRenameUsageInfo)usage;
            PsiElement oldElement = moveRenameUsage.getReferencedElement();
            PsiElement newElement = oldToNewElementsMapping.get(oldElement);
            LOG.assertTrue(newElement != null);
            PsiReference reference = moveRenameUsage.getReference();
            if (reference == null) continue;
            reference.bindToElement(newElement);
        }
        return nonCodeUsages.toArray(new NonCodeUsageInfo[nonCodeUsages.size()]);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        if (this.myMoveCallback != null) {
            if (this.myMoveCallback instanceof MoveClassesOrPackagesCallback) {
                ((MoveClassesOrPackagesCallback)this.myMoveCallback).classesOrPackagesMoved(this.myMoveDestination);
            }
            this.myMoveCallback.refactoringCompleted();
        }
    }

    @Override
    protected String getCommandName() {
        String elements = RefactoringUIUtil.calculatePsiElementDescriptionList(this.myElementsToMove);
        String target = this.myTargetPackage.getQualifiedName();
        return RefactoringBundle.message((String)"move.classes.command", (Object[])new Object[]{elements, target});
    }

    private static class NonPublicClassMemberWrappersSet
    extends HashSet<ClassMemberWrapper> {
        private NonPublicClassMemberWrappersSet() {
        }

        public void addElement(PsiMember member) {
            PsiNamedElement namedElement = (PsiNamedElement)member;
            if (member.hasModifierProperty("public")) {
                return;
            }
            if (member.hasModifierProperty("private")) {
                return;
            }
            this.add(new ClassMemberWrapper(namedElement));
        }

        public void addElements(PsiMember[] members) {
            for (PsiMember member : members) {
                this.addElement(member);
            }
        }
    }

    private class MyClassInstanceReferenceVisitor
    implements ClassInstanceScanner.ClassInstanceReferenceVisitor {
        private final MultiMap<PsiElement, String> myConflicts;
        private final HashMap<PsiModifierListOwner, HashSet<PsiElement>> myReportedElementToContainer = new HashMap();
        private final HashMap<PsiClass, RefactoringUtil.IsDescendantOf> myIsDescendantOfCache = new HashMap();

        public MyClassInstanceReferenceVisitor(MultiMap<PsiElement, String> conflicts) {
            this.myConflicts = conflicts;
        }

        @Override
        public void visitQualifier(PsiReferenceExpression qualified, PsiExpression instanceRef, PsiElement referencedInstance) {
            PsiElement resolved = qualified.resolve();
            if (resolved instanceof PsiMember) {
                PsiMember member = (PsiMember)resolved;
                PsiClass containingClass = member.getContainingClass();
                RefactoringUtil.IsDescendantOf isDescendantOf = (RefactoringUtil.IsDescendantOf)this.myIsDescendantOfCache.get((Object)containingClass);
                if (isDescendantOf == null) {
                    isDescendantOf = new RefactoringUtil.IsDescendantOf(containingClass);
                    this.myIsDescendantOfCache.put((Object)containingClass, (Object)isDescendantOf);
                }
                this.visitMemberReference((PsiModifierListOwner)member, qualified, isDescendantOf);
            }
        }

        private void visitMemberReference(PsiModifierListOwner member, PsiReferenceExpression qualified, RefactoringUtil.IsDescendantOf descendantOf) {
            if (member.hasModifierProperty("packageLocal")) {
                this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member);
            } else if (member.hasModifierProperty("protected")) {
                PsiExpression qualifier = qualified.getQualifierExpression();
                if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                    this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member);
                } else if (!this.isInInheritor(qualified, descendantOf)) {
                    this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member);
                }
            }
        }

        private boolean isInInheritor(PsiReferenceExpression qualified, RefactoringUtil.IsDescendantOf descendantOf) {
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)qualified, PsiClass.class);
            while (aClass != null) {
                if (descendantOf.value(aClass)) {
                    return true;
                }
                aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
            }
            return false;
        }

        private void visitPackageLocalMemberReference(PsiJavaCodeReferenceElement qualified, PsiModifierListOwner member) {
            PsiElement container = ConflictsUtil.getContainer((PsiElement)qualified);
            HashSet<PsiElement> reportedContainers = (HashSet<PsiElement>)this.myReportedElementToContainer.get((Object)member);
            if (reportedContainers == null) {
                reportedContainers = new HashSet<PsiElement>();
                this.myReportedElementToContainer.put((Object)member, reportedContainers);
            }
            if (!reportedContainers.contains(container)) {
                PsiDirectory directory;
                PsiFile containingFile;
                reportedContainers.add(container);
                if (!MoveClassesOrPackagesProcessor.this.isInsideMoved(container) && (containingFile = container.getContainingFile()) != null && (directory = containingFile.getContainingDirectory()) != null) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                    if (!MoveClassesOrPackagesProcessor.this.myTargetPackage.equalToPackage(aPackage)) {
                        String message = RefactoringBundle.message((String)"0.will.be.inaccessible.from.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, true), RefactoringUIUtil.getDescription(container, true)});
                        this.myConflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message));
                    }
                }
            }
        }

        @Override
        public void visitTypeCast(PsiTypeCastExpression typeCastExpression, PsiExpression instanceRef, PsiElement referencedInstance) {
        }

        @Override
        public void visitReadUsage(PsiExpression instanceRef, PsiType expectedType, PsiElement referencedInstance) {
        }

        @Override
        public void visitWriteUsage(PsiExpression instanceRef, PsiType assignedType, PsiElement referencedInstance) {
        }
    }

    static class ClassMemberWrapper {
        final PsiNamedElement myElement;
        final PsiModifierListOwner myMember;

        public ClassMemberWrapper(PsiNamedElement element) {
            this.myElement = element;
            this.myMember = (PsiModifierListOwner)element;
        }

        PsiModifierListOwner getMember() {
            return this.myMember;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassMemberWrapper)) {
                return false;
            }
            ClassMemberWrapper wrapper = (ClassMemberWrapper)o;
            if (this.myElement instanceof PsiMethod) {
                return wrapper.myElement instanceof PsiMethod && MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)this.myElement), (PsiMethod)((PsiMethod)wrapper.myElement));
            }
            return Comparing.equal((String)this.myElement.getName(), (String)wrapper.myElement.getName());
        }

        public int hashCode() {
            String name = this.myElement.getName();
            if (name != null) {
                return name.hashCode();
            }
            return 0;
        }
    }

    protected static class ConflictsUsageInfo
    extends UsageInfo {
        private final MultiMap<PsiElement, String> myConflicts;

        public ConflictsUsageInfo(PsiElement pseudoElement, MultiMap<PsiElement, String> conflicts) {
            super(pseudoElement);
            this.myConflicts = conflicts;
        }

        public MultiMap<PsiElement, String> getConflicts() {
            return this.myConflicts;
        }
    }
}

