/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesHandlerBase;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveClassesOrPackages.MovePackagesHandler;
import org.jetbrains.annotations.Nullable;

public class MoveClassesHandler
extends MoveClassesOrPackagesHandlerBase {
    @Override
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        for (PsiElement element : elements) {
            PsiFile parentFile;
            if (element instanceof PsiJavaFile) {
                PsiClass[] classes = ((PsiJavaFile)element).getClasses();
                if (classes.length == 0) {
                    return false;
                }
                for (PsiClass aClass : classes) {
                    if (!(aClass instanceof JspClass)) continue;
                    return false;
                }
                parentFile = (PsiFile)element;
            } else {
                if (element instanceof JspClass) {
                    return false;
                }
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                if (!(element.getParent() instanceof PsiFile)) {
                    return false;
                }
                parentFile = (PsiFile)element.getParent();
            }
            if (!CollectHighlightsUtil.isOutsideSourceRootJavaFile(parentFile)) continue;
            return false;
        }
        return super.canMove(elements, targetContainer);
    }

    @Override
    public boolean isValidTarget(PsiElement psiElement) {
        return psiElement instanceof PsiClass || MovePackagesHandler.isPackageOrDirectory(psiElement);
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (CollectHighlightsUtil.isOutsideSourceRootJavaFile(element.getContainingFile())) {
            return false;
        }
        if (MoveClassesHandler.isReferenceInAnonymousClass(reference)) {
            return false;
        }
        if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass) && element.getParent() instanceof PsiFile) {
            MoveClassesOrPackagesImpl.doMove(project, new PsiElement[]{element}, (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext), null);
            return true;
        }
        return false;
    }

    public static boolean isReferenceInAnonymousClass(@Nullable PsiReference reference) {
        return reference instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiAnonymousClass;
    }
}

