/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMigration;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.refactoring.migration.MigrationUsagesViewDescriptor;
import com.intellij.refactoring.migration.MigrationUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class MigrationProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.migration.MigrationProcessor");
    private final MigrationMap myMigrationMap;
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"migration.title");
    private PsiMigration myPsiMigration;

    public MigrationProcessor(Project project, MigrationMap migrationMap) {
        super(project);
        this.myMigrationMap = migrationMap;
        this.myPsiMigration = this.startMigration(PsiManager.getInstance((Project)project));
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new MigrationUsagesViewDescriptor(this.myMigrationMap, false);
    }

    private PsiMigration startMigration(PsiManager psiManager) {
        PsiMigration migration = JavaPsiFacade.getInstance((Project)psiManager.getProject()).startMigration();
        this.findOrCreateEntries(psiManager, migration);
        return migration;
    }

    private void findOrCreateEntries(PsiManager psiManager, PsiMigration migration) {
        for (int i = 0; i < this.myMigrationMap.getEntryCount(); ++i) {
            MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i);
            if (entry.getType() == 0) {
                MigrationUtil.findOrCreatePackage(psiManager, migration, entry.getOldName());
                continue;
            }
            MigrationUtil.findOrCreateClass(psiManager, migration, entry.getOldName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray;
        ArrayList<MigrationUsageInfo> usagesVector = new ArrayList<MigrationUsageInfo>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        try {
            if (this.myMigrationMap == null) {
                UsageInfo[] usageInfoArray2 = UsageInfo.EMPTY_ARRAY;
                usageInfoArray = usageInfoArray2;
                if (usageInfoArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/migration/MigrationProcessor.findUsages must not return null");
                return usageInfoArray;
            }
            for (int i = 0; i < this.myMigrationMap.getEntryCount(); ++i) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i);
                UsageInfo[] usages = entry.getType() == 0 ? MigrationUtil.findPackageUsages(psiManager, this.myPsiMigration, entry.getOldName()) : MigrationUtil.findClassUsages(psiManager, this.myPsiMigration, entry.getOldName());
                for (UsageInfo usage : usages) {
                    usagesVector.add(new MigrationUsageInfo(usage, entry));
                }
            }
        }
        finally {
            this.myPsiMigration.finish();
            this.myPsiMigration = null;
        }
        usageInfoArray = usagesVector.toArray(new MigrationUsageInfo[usagesVector.size()]);
        if (usageInfoArray != null) return usageInfoArray;
        throw new IllegalStateException("@NotNull method com/intellij/refactoring/migration/MigrationProcessor.findUsages must not return null");
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        if (((UsageInfo[])refUsages.get()).length == 0) {
            Messages.showInfoMessage((Project)this.myProject, (String)RefactoringBundle.message((String)"migration.no.usages.found.in.the.project"), (String)REFACTORING_NAME);
            return false;
        }
        this.setPreviewUsages(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        PsiMigration psiMigration = JavaPsiFacade.getInstance((Project)psiManager.getProject()).startMigration();
        LocalHistoryAction a = LocalHistory.startAction((Project)this.myProject, (String)this.getCommandName());
        try {
            for (int i = 0; i < this.myMigrationMap.getEntryCount(); ++i) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i);
                if (entry.getType() == 0) {
                    MigrationUtil.doPackageMigration(psiManager, psiMigration, entry.getNewName(), usages);
                }
                if (entry.getType() != 1) continue;
                MigrationUtil.doClassMigration(psiManager, psiMigration, entry.getNewName(), usages);
            }
            for (RefactoringHelper helper : (RefactoringHelper[])Extensions.getExtensions(RefactoringHelper.EP_NAME)) {
                Object preparedData = helper.prepareOperation(usages);
                helper.performOperation(this.myProject, preparedData);
            }
        }
        finally {
            a.finish();
            psiMigration.finish();
        }
    }

    @Override
    protected String getCommandName() {
        return REFACTORING_NAME;
    }

    public static class MigrationUsageInfo
    extends UsageInfo {
        public MigrationMapEntry mapEntry;

        public MigrationUsageInfo(UsageInfo info, MigrationMapEntry mapEntry) {
            super(info.getElement(), info.startOffset, info.endOffset);
            this.mapEntry = mapEntry;
        }
    }
}

