/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPullUp.PullUpConflictsUtil;
import com.intellij.refactoring.memberPullUp.PullUpDialog;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaPullUpHandler
implements RefactoringActionHandler,
PullUpDialog.Callback,
ElementsHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.memberPullUp.JavaPullUpHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"pull.members.up.title");
    private PsiClass mySubclass;
    private Project myProject;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/memberPullUp/JavaPullUpHandler.invoke must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pullMembersUp");
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element)) {
                return;
            }
            if (element instanceof PsiClass || element instanceof PsiField || element instanceof PsiMethod) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiClass aClass;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/memberPullUp/JavaPullUpHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/memberPullUp/JavaPullUpHandler.invoke must not be null");
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        PsiElement element = elements[0];
        PsiElement aMember = null;
        if (element instanceof PsiClass) {
            aClass = (PsiClass)element;
        } else if (element instanceof PsiMethod) {
            aClass = ((PsiMethod)element).getContainingClass();
            aMember = element;
        } else if (element instanceof PsiField) {
            aClass = ((PsiField)element).getContainingClass();
            aMember = element;
        } else {
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pullMembersUp");
            return;
        }
        ArrayList<PsiClass> bases = RefactoringHierarchyUtil.createBasesList(aClass, false, true);
        if (bases.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pullMembersUp");
            return;
        }
        this.mySubclass = aClass;
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(this.mySubclass, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                return true;
            }
        });
        List members = memberInfoStorage.getClassMemberInfos(this.mySubclass);
        PsiManager manager = this.mySubclass.getManager();
        for (MemberInfo member : members) {
            if (!manager.areElementsEquivalent(member.getMember(), aMember)) continue;
            member.setChecked(true);
            break;
        }
        PullUpDialog dialog = new PullUpDialog(project, aClass, bases, memberInfoStorage, this);
        dialog.show();
    }

    @Override
    public boolean checkConflicts(PullUpDialog dialog) {
        MemberInfo[] infos = dialog.getSelectedMemberInfos();
        PsiClass superClass = dialog.getSuperClass();
        if (!this.checkWritable(superClass, infos)) {
            return false;
        }
        MultiMap<PsiElement, String> conflicts = PullUpConflictsUtil.checkConflicts(infos, this.mySubclass, superClass, null, null, dialog.getContainmentVerifier());
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts);
            conflictsDialog.show();
            boolean ok = conflictsDialog.isOK();
            if (!ok && conflictsDialog.isShowConflicts()) {
                dialog.close(1);
            }
            return ok;
        }
        return true;
    }

    private boolean checkWritable(PsiClass superClass, MemberInfo[] infos) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)superClass)) {
            return false;
        }
        for (MemberInfo info : infos) {
            if (info.getMember() instanceof PsiClass && info.getOverrides() != null || CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)info.getMember())) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }
}

