/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.InputValidator;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.introduceVariable.PsiExpressionTrimRenderer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurences.ExpressionOccurenceManager;
import com.intellij.refactoring.util.occurences.NotInSuperCallOccurenceFilter;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceVariableBase
extends IntroduceHandlerBase
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceVariable.IntroduceVariableBase");
    @NonNls
    private static final String PREFER_STATEMENTS_OPTION = "introduce.variable.prefer.statements";
    protected static String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.variable.title");

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceVariable/IntroduceVariableBase.invoke must not be null");
        }
        if (!editor.getSelectionModel().hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement[] statementsInRange = IntroduceVariableBase.findStatementsAtOffset(editor, file, offset);
            if (statementsInRange.length == 1 && (PsiUtil.hasErrorElementChild((PsiElement)statementsInRange[0]) || IntroduceVariableBase.isPreferStatements())) {
                editor.getSelectionModel().selectLineAtCaret();
            } else {
                List<PsiExpression> expressions = IntroduceVariableBase.collectExpressions(file, editor, offset, statementsInRange);
                if (expressions.isEmpty()) {
                    editor.getSelectionModel().selectLineAtCaret();
                } else if (expressions.size() == 1) {
                    TextRange textRange = expressions.get(0).getTextRange();
                    editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                } else {
                    IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiExpression>(){

                        public void pass(PsiExpression selectedValue) {
                            IntroduceVariableBase.this.invoke(project, editor, file, selectedValue.getTextRange().getStartOffset(), selectedValue.getTextRange().getEndOffset());
                        }
                    }, new PsiExpressionTrimRenderer.RenderFunction());
                    return;
                }
            }
        }
        if (this.invoke(project, editor, file, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd())) {
            editor.getSelectionModel().removeSelection();
        }
    }

    public static boolean isPreferStatements() {
        return Boolean.valueOf(PropertiesComponent.getInstance().getOrInit(PREFER_STATEMENTS_OPTION, "false"));
    }

    public static List<PsiExpression> collectExpressions(PsiFile file, Editor editor, int offset, PsiElement ... statementsInRange) {
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else if (!Character.isJavaIdentifierPart(text.charAt(correctedOffset)) && text.charAt(correctedOffset) != ')') {
            correctedOffset = offset;
        }
        PsiElement elementAtCaret = file.findElementAt(correctedOffset);
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PsiExpression.class);
        while (expression != null) {
            if (!(expressions.contains(expression) || expression instanceof PsiParenthesizedExpression || expression instanceof PsiSuperExpression || expression.getType() == PsiType.VOID || expression instanceof PsiReferenceExpression && (expression.getParent() instanceof PsiMethodCallExpression || ((PsiReferenceExpression)expression).resolve() instanceof PsiClass) || expression instanceof PsiAssignmentExpression)) {
                expressions.add(expression);
            }
            expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpression.class);
        }
        return expressions;
    }

    public static PsiElement[] findStatementsAtOffset(Editor editor, PsiFile file, int offset) {
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(offset);
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        return CodeInsightUtil.findStatementsInRange(file, lineStart, lineEnd);
    }

    private boolean invoke(Project project, Editor editor, PsiFile file, int startOffset, int endOffset) {
        PsiElement[] statements;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiExpression tempExpr = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset);
        if (tempExpr == null && (statements = CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset)).length == 1) {
            if (statements[0] instanceof PsiExpressionStatement) {
                tempExpr = ((PsiExpressionStatement)statements[0]).getExpression();
            } else if (statements[0] instanceof PsiReturnStatement) {
                tempExpr = ((PsiReturnStatement)statements[0]).getReturnValue();
            }
        }
        if (tempExpr == null) {
            tempExpr = IntroduceVariableBase.getSelectedExpression(project, file, startOffset, endOffset);
        }
        return this.invokeImpl(project, tempExpr, editor);
    }

    public static PsiExpression getSelectedExpression(Project project, PsiFile file, int startOffset, int endOffset) {
        PsiExpression tempExpr;
        PsiElement elementAtStart = file.findElementAt(startOffset);
        if (elementAtStart == null) {
            return null;
        }
        PsiElement elementAtEnd = file.findElementAt(endOffset - 1);
        if (elementAtEnd == null) {
            return null;
        }
        PsiElement elementAt = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
        if (PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiExpression.class, (boolean)false) == null) {
            return null;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiLiteralExpression.class);
        PsiLiteralExpression startLiteralExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, PsiLiteralExpression.class);
        PsiLiteralExpression endLiteralExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(endOffset), PsiLiteralExpression.class);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        try {
            String text = ((Object)file.getText().subSequence(startOffset, endOffset)).toString();
            String prefix = null;
            String suffix = null;
            String stripped = text;
            if (startLiteralExpression != null) {
                int startExpressionOffset = startLiteralExpression.getTextOffset();
                if (startOffset == startExpressionOffset) {
                    if (StringUtil.startsWithChar((CharSequence)text, (char)'\"') || StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                        stripped = text.substring(1);
                    }
                } else if (startOffset == startExpressionOffset + 1) {
                    text = "\"" + text;
                } else if (startOffset > startExpressionOffset + 1) {
                    prefix = "\" + ";
                    text = "\"" + text;
                }
            }
            if (endLiteralExpression != null) {
                int endExpressionOffset = endLiteralExpression.getTextOffset() + endLiteralExpression.getTextLength();
                if (endOffset == endExpressionOffset) {
                    if (StringUtil.endsWithChar((CharSequence)stripped, (char)'\"') || StringUtil.endsWithChar((CharSequence)stripped, (char)'\'')) {
                        stripped = stripped.substring(0, stripped.length() - 1);
                    }
                } else if (endOffset == endExpressionOffset - 1) {
                    text = text + "\"";
                } else if (endOffset < endExpressionOffset - 1) {
                    suffix = " + \"";
                    text = text + "\"";
                }
            }
            boolean primitive = false;
            if (stripped.equals("true") || stripped.equals("false")) {
                primitive = true;
            } else {
                try {
                    Integer.parseInt(stripped);
                    primitive = true;
                }
                catch (NumberFormatException e1) {
                    // empty catch block
                }
            }
            if (primitive) {
                text = stripped;
            }
            PsiLiteralExpression parent = literalExpression != null ? literalExpression : elementAt;
            tempExpr = elementFactory.createExpressionFromText(text, (PsiElement)parent);
            final boolean[] hasErrors = new boolean[1];
            JavaRecursiveElementWalkingVisitor errorsVisitor = new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (hasErrors[0]) {
                        return;
                    }
                    super.visitElement(element);
                }

                public void visitErrorElement(PsiErrorElement element) {
                    hasErrors[0] = true;
                }
            };
            tempExpr.accept((PsiElementVisitor)errorsVisitor);
            if (hasErrors[0]) {
                return null;
            }
            tempExpr.putUserData(ElementToWorkOn.PREFIX, (Object)prefix);
            tempExpr.putUserData(ElementToWorkOn.SUFFIX, (Object)suffix);
            RangeMarker rangeMarker = FileDocumentManager.getInstance().getDocument(file.getVirtualFile()).createRangeMarker(startOffset, endOffset);
            tempExpr.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)rangeMarker);
            tempExpr.putUserData(ElementToWorkOn.PARENT, (Object)parent);
            String fakeInitializer = "intellijidearulezzz";
            int[] refIdx = new int[1];
            PsiExpression toBeExpression = IntroduceVariableBase.createReplacement("intellijidearulezzz", project, prefix, suffix, (PsiElement)parent, rangeMarker, refIdx);
            toBeExpression.accept((PsiElementVisitor)errorsVisitor);
            if (hasErrors[0]) {
                return null;
            }
            PsiReferenceExpression refExpr = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)toBeExpression.findElementAt(refIdx[0]), PsiReferenceExpression.class);
            assert (refExpr != null);
            if (ReplaceExpressionUtil.isNeedParenthesis(refExpr.getNode(), tempExpr.getNode())) {
                return null;
            }
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        return tempExpr;
    }

    @Override
    protected boolean invokeImpl(final Project project, final PsiExpression expr, final Editor editor) {
        int line;
        boolean replaceSelf;
        boolean declareFinal;
        IntroduceVariableSettings settings;
        String message;
        PsiMethod method;
        PsiExpression enclosingExpr;
        if (expr != null && expr.getParent() instanceof PsiExpressionStatement) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable.incompleteStatement");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + expr);
        }
        if (expr == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.an.expression"));
            this.showErrorMessage(project, editor, message2);
            return false;
        }
        final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiType originalType = RefactoringUtil.getTypeByExpressionWithExpectedType(expr);
        if (originalType == null) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"unknown.expression.type"));
            this.showErrorMessage(project, editor, message3);
            return false;
        }
        if (PsiType.VOID.equals(originalType)) {
            String message4 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            this.showErrorMessage(project, editor, message4);
            return false;
        }
        PsiElement physicalElement = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT);
        PsiElement anchorStatement = RefactoringUtil.getParentStatement((PsiElement)(physicalElement != null ? physicalElement : expr), false);
        if (anchorStatement == null) {
            return this.parentStatementNotFound(project, editor);
        }
        if (anchorStatement instanceof PsiExpressionStatement && (enclosingExpr = ((PsiExpressionStatement)anchorStatement).getExpression()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)enclosingExpr).resolveMethod()) != null && method.isConstructor()) {
            String message5 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"invalid.expression.context"));
            this.showErrorMessage(project, editor, message5);
            return false;
        }
        PsiElement tempContainer = anchorStatement.getParent();
        if (!(tempContainer instanceof PsiCodeBlock) && !IntroduceVariableBase.isLoopOrIf(tempContainer)) {
            message = RefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME});
            this.showErrorMessage(project, editor, message);
            return false;
        }
        if (!NotInSuperCallOccurenceFilter.INSTANCE.isOK(expr)) {
            message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"cannot.introduce.variable.in.super.constructor.call"));
            this.showErrorMessage(project, editor, message);
            return false;
        }
        PsiFile file = anchorStatement.getContainingFile();
        LOG.assertTrue(file != null, (Object)"expr.getContainingFile() == null");
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return false;
        }
        PsiElement containerParent = tempContainer;
        PsiElement lastScope = tempContainer;
        while (!(containerParent instanceof PsiFile) && !(containerParent instanceof PsiMethod)) {
            if (!((containerParent = containerParent.getParent()) instanceof PsiCodeBlock)) continue;
            lastScope = containerParent;
        }
        ExpressionOccurenceManager occurenceManager = new ExpressionOccurenceManager(expr, lastScope, NotInSuperCallOccurenceFilter.INSTANCE);
        final PsiExpression[] occurrences = occurenceManager.getOccurences();
        PsiElement anchorStatementIfAll = occurenceManager.getAnchorStatementForAll();
        boolean declareFinalIfAll = occurenceManager.isInFinalContext();
        boolean anyAssignmentLHS = false;
        for (PsiExpression occurrence : occurrences) {
            if (!RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) continue;
            anyAssignmentLHS = true;
            break;
        }
        if (!(settings = this.getSettings(project, editor, expr, (PsiElement[])occurrences, anyAssignmentLHS, declareFinalIfAll, originalType, new TypeSelectorManagerImpl(project, originalType, expr, occurrences), new InputValidator(this, project, anchorStatementIfAll, anchorStatement, occurenceManager))).isOK()) {
            return false;
        }
        final String variableName = settings.getEnteredName();
        final PsiType type = settings.getSelectedType();
        final boolean replaceAll = settings.isReplaceAllOccurrences();
        final boolean replaceWrite = settings.isReplaceLValues();
        boolean bl = declareFinal = replaceAll && declareFinalIfAll || settings.isDeclareFinal();
        if (replaceAll) {
            anchorStatement = anchorStatementIfAll;
            tempContainer = anchorStatement.getParent();
        }
        final PsiElement container = tempContainer;
        PsiElement child = anchorStatement;
        if (!IntroduceVariableBase.isLoopOrIf(container)) {
            child = IntroduceVariableBase.locateAnchor(child);
        }
        final PsiElement anchor = child == null ? anchorStatement : child;
        boolean tempDeleteSelf = false;
        boolean bl2 = replaceSelf = replaceWrite || !RefactoringUtil.isAssignmentLHS((PsiElement)expr);
        if (!IntroduceVariableBase.isLoopOrIf(container)) {
            PsiStatement statement;
            PsiElement parent;
            if (expr.getParent() instanceof PsiExpressionStatement && anchor.equals(anchorStatement) && ((parent = (statement = (PsiStatement)expr.getParent()).getParent()) instanceof PsiCodeBlock || parent instanceof PsiCodeFragment)) {
                tempDeleteSelf = true;
            }
            tempDeleteSelf &= replaceSelf;
        }
        final boolean deleteSelf = tempDeleteSelf;
        final int col = editor != null ? editor.getCaretModel().getLogicalPosition().column : 0;
        int n = line = editor != null ? editor.getCaretModel().getLogicalPosition().line : 0;
        if (deleteSelf && editor != null) {
            LogicalPosition pos = new LogicalPosition(line, col);
            editor.getCaretModel().moveToLogicalPosition(pos);
        }
        PsiCodeBlock newDeclarationScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)container, PsiCodeBlock.class, (boolean)false);
        final FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(variableName, newDeclarationScope);
        final PsiElement finalAnchorStatement = anchorStatement;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PsiNewExpression newExpression;
                    PsiStatement statement = null;
                    boolean isInsideLoop = IntroduceVariableBase.isLoopOrIf(container);
                    if (!isInsideLoop && deleteSelf) {
                        statement = (PsiStatement)expr.getParent();
                    }
                    PsiExpression expr1 = fieldConflictsResolver.fixInitializer(expr);
                    PsiExpression initializer = RefactoringUtil.unparenthesizeExpression(expr1);
                    if (expr1 instanceof PsiNewExpression && (newExpression = (PsiNewExpression)expr1).getArrayInitializer() != null) {
                        initializer = newExpression.getArrayInitializer();
                    }
                    PsiDeclarationStatement declaration = factory.createVariableDeclarationStatement(variableName, type, initializer);
                    if (!isInsideLoop) {
                        declaration = (PsiDeclarationStatement)container.addBefore((PsiElement)declaration, anchor);
                        LOG.assertTrue(expr1.isValid());
                        if (deleteSelf) {
                            PsiElement lastChild = statement.getLastChild();
                            if (lastChild instanceof PsiComment) {
                                declaration.addBefore(lastChild, null);
                            }
                            statement.delete();
                            if (editor != null) {
                                LogicalPosition pos = new LogicalPosition(line, col);
                                editor.getCaretModel().moveToLogicalPosition(pos);
                                editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
                                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                                editor.getSelectionModel().removeSelection();
                            }
                        }
                    }
                    PsiExpression ref = factory.createExpressionFromText(variableName, null);
                    if (replaceAll) {
                        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
                        for (PsiExpression occurrence : occurrences) {
                            if (deleteSelf && occurrence.equals(expr)) continue;
                            if (occurrence.equals(expr)) {
                                occurrence = expr1;
                            }
                            if (occurrence != null) {
                                occurrence = RefactoringUtil.outermostParenthesizedExpression(occurrence);
                            }
                            if (!replaceWrite && RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) continue;
                            array.add(IntroduceVariableBase.replace(occurrence, ref, project));
                        }
                        if (editor != null) {
                            PsiElement[] replacedOccurences = array.toArray(new PsiElement[array.size()]);
                            IntroduceVariableBase.this.highlightReplacedOccurences(project, editor, replacedOccurences);
                        }
                    } else if (!deleteSelf && replaceSelf) {
                        IntroduceVariableBase.replace(expr1, ref, project);
                    }
                    declaration = (PsiDeclarationStatement)IntroduceVariableBase.putStatementInLoopBody((PsiStatement)declaration, container, finalAnchorStatement);
                    declaration = (PsiDeclarationStatement)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)declaration);
                    PsiVariable var = (PsiVariable)declaration.getDeclaredElements()[0];
                    PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)declareFinal);
                    fieldConflictsResolver.fix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        }, REFACTORING_NAME, null);
        return true;
    }

    public static PsiElement replace(PsiExpression expr1, PsiExpression ref, Project project) throws IncorrectOperationException {
        PsiExpression expr2 = RefactoringUtil.outermostParenthesizedExpression(expr1);
        if (expr2.isPhysical()) {
            return expr2.replace((PsiElement)ref);
        }
        String prefix = (String)expr1.getUserData(ElementToWorkOn.PREFIX);
        String suffix = (String)expr1.getUserData(ElementToWorkOn.SUFFIX);
        PsiElement parent = (PsiElement)expr1.getUserData(ElementToWorkOn.PARENT);
        RangeMarker rangeMarker = (RangeMarker)expr1.getUserData(ElementToWorkOn.TEXT_RANGE);
        return parent.replace((PsiElement)IntroduceVariableBase.createReplacement(ref.getText(), project, prefix, suffix, parent, rangeMarker, new int[1]));
    }

    private static PsiExpression createReplacement(String refText, Project project, String prefix, String suffix, PsiElement parent, RangeMarker rangeMarker, int[] refIdx) {
        String end;
        TextRange parentRange;
        String allText = parent.getContainingFile().getText();
        String beg = allText.substring((parentRange = parent.getTextRange()).getStartOffset(), rangeMarker.getStartOffset());
        if (StringUtil.stripQuotesAroundValue((String)beg).trim().length() == 0 && prefix == null) {
            beg = "";
        }
        if (StringUtil.stripQuotesAroundValue((String)(end = allText.substring(rangeMarker.getEndOffset(), parentRange.getEndOffset()))).trim().length() == 0 && suffix == null) {
            end = "";
        }
        String start = beg + (prefix != null ? prefix : "");
        refIdx[0] = start.length();
        String text = start + refText + (suffix != null ? suffix : "") + end;
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(text, parent);
    }

    public static PsiStatement putStatementInLoopBody(PsiStatement declaration, PsiElement container, PsiElement finalAnchorStatement) throws IncorrectOperationException {
        if (IntroduceVariableBase.isLoopOrIf(container)) {
            PsiElement pprev;
            PsiStatement loopBody = IntroduceVariableBase.getLoopBody(container, finalAnchorStatement);
            PsiStatement loopBodyCopy = loopBody != null ? (PsiStatement)loopBody.copy() : null;
            PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getInstance((Project)container.getProject()).getElementFactory().createStatementFromText("{}", null);
            blockStatement = (PsiBlockStatement)CodeStyleManager.getInstance((Project)container.getProject()).reformat((PsiElement)blockStatement);
            PsiElement prevSibling = loopBody.getPrevSibling();
            if (!(!(prevSibling instanceof PsiWhiteSpace) || (pprev = prevSibling.getPrevSibling()) instanceof PsiComment && ((PsiComment)pprev).getTokenType().equals(JavaTokenType.END_OF_LINE_COMMENT))) {
                prevSibling.delete();
            }
            blockStatement = (PsiBlockStatement)loopBody.replace((PsiElement)blockStatement);
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            declaration = (PsiStatement)codeBlock.add((PsiElement)declaration);
            JavaCodeStyleManager.getInstance((Project)declaration.getProject()).shortenClassReferences((PsiElement)declaration);
            if (loopBodyCopy != null) {
                codeBlock.add((PsiElement)loopBodyCopy);
            }
        }
        return declaration;
    }

    private boolean parentStatementNotFound(Project project, Editor editor) {
        String message = RefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME});
        this.showErrorMessage(project, editor, message);
        return false;
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        throw new UnsupportedOperationException();
    }

    private static PsiElement locateAnchor(PsiElement child) {
        PsiElement prev;
        while (!(child == null || (prev = child.getPrevSibling()) instanceof PsiStatement || prev instanceof PsiJavaToken && ((PsiJavaToken)prev).getTokenType() == JavaTokenType.LBRACE)) {
            child = prev;
        }
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getNextSibling();
        }
        return child;
    }

    protected abstract void highlightReplacedOccurences(Project var1, Editor var2, PsiElement[] var3);

    protected abstract IntroduceVariableSettings getSettings(Project var1, Editor var2, PsiExpression var3, PsiElement[] var4, boolean var5, boolean var6, PsiType var7, TypeSelectorManagerImpl var8, InputValidator var9);

    protected abstract void showErrorMessage(Project var1, Editor var2, String var3);

    @Nullable
    private static PsiStatement getLoopBody(PsiElement container, PsiElement anchorStatement) {
        if (container instanceof PsiLoopStatement) {
            return ((PsiLoopStatement)container).getBody();
        }
        if (container instanceof PsiIfStatement) {
            PsiStatement thenBranch = ((PsiIfStatement)container).getThenBranch();
            if (thenBranch != null && PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)anchorStatement, (boolean)false)) {
                return thenBranch;
            }
            PsiStatement elseBranch = ((PsiIfStatement)container).getElseBranch();
            if (elseBranch != null && PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)anchorStatement, (boolean)false)) {
                return elseBranch;
            }
            LOG.assertTrue(false);
        }
        LOG.assertTrue(false);
        return null;
    }

    public static boolean isLoopOrIf(PsiElement element) {
        return element instanceof PsiLoopStatement || element instanceof PsiIfStatement;
    }

    protected abstract boolean reportConflicts(MultiMap<PsiElement, String> var1, Project var2, IntroduceVariableSettings var3);

    public static void checkInLoopCondition(PsiExpression occurence, MultiMap<PsiElement, String> conflicts) {
        PsiElement loopForLoopCondition = RefactoringUtil.getLoopForLoopCondition(occurence);
        if (loopForLoopCondition == null) {
            return;
        }
        List<PsiVariable> referencedVariables = RefactoringUtil.collectReferencedVariables((PsiElement)occurence);
        ArrayList<PsiVariable> modifiedInBody = new ArrayList<PsiVariable>();
        for (PsiVariable psiVariable : referencedVariables) {
            if (!RefactoringUtil.isModifiedInScope(psiVariable, loopForLoopCondition)) continue;
            modifiedInBody.add(psiVariable);
        }
        if (!modifiedInBody.isEmpty()) {
            for (PsiVariable variable : modifiedInBody) {
                String message = RefactoringBundle.message((String)"is.modified.in.loop.body", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)variable, false)});
                conflicts.putValue((Object)variable, (Object)CommonRefactoringUtil.capitalize((String)message));
            }
            conflicts.putValue((Object)occurence, (Object)RefactoringBundle.message((String)"introducing.variable.may.break.code.logic"));
        }
    }

    public static interface Validator {
        public boolean isOK(IntroduceVariableSettings var1);
    }
}

