/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceField.IntroduceConstantDialog;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.occurences.ExpressionOccurenceManager;
import com.intellij.refactoring.util.occurences.OccurenceManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceConstantHandler
extends BaseExpressionToFieldHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.constant.title");

    @Override
    protected String getHelpID() {
        return "refactoring.introduceConstant";
    }

    public void invoke(Project project, PsiExpression[] expressions) {
        for (PsiExpression expression : expressions) {
            PsiFile file = expression.getContainingFile();
            if (CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) continue;
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        super.invoke(project, (PsiElement[])expressions, null);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceField/IntroduceConstantHandler.invoke must not be null");
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ElementToWorkOn.processElementToWorkOn(editor, file, REFACTORING_NAME, this.getHelpID(), project, this.getElementProcessor(project, editor));
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        LocalToFieldHandler localToFieldHandler = new LocalToFieldHandler(project, true);
        return localToFieldHandler.convertLocalToField(localVariable, editor);
    }

    @Override
    protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(Project project, Editor editor, PsiClass parentClass, PsiExpression expr, PsiType type, PsiExpression[] occurences, PsiElement anchorElement, PsiElement anchorElementIfAll) {
        PsiElement ref;
        PsiLocalVariable localVariable = null;
        if (expr instanceof PsiReferenceExpression && (ref = ((PsiReferenceExpression)expr).resolve()) instanceof PsiLocalVariable) {
            localVariable = (PsiLocalVariable)ref;
        }
        if (localVariable == null) {
            PsiElement errorElement = this.isStaticFinalInitializer(expr);
            if (errorElement != null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.cannot.be.a.constant.initializer"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)this.getHelpID());
                IntroduceConstantHandler.highlightError(project, editor, errorElement);
                return null;
            }
        } else {
            PsiExpression initializer = localVariable.getInitializer();
            if (initializer == null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.does.not.have.an.initializer", (Object[])new Object[]{localVariable.getName()}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)this.getHelpID());
                return null;
            }
            PsiElement errorElement = this.isStaticFinalInitializer(initializer);
            if (errorElement != null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"initializer.for.variable.cannot.be.a.constant.initializer", (Object[])new Object[]{localVariable.getName()}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)this.getHelpID());
                IntroduceConstantHandler.highlightError(project, editor, errorElement);
                return null;
            }
        }
        IntroduceConstantDialog dialog = new IntroduceConstantDialog(project, parentClass, expr, localVariable, false, occurences, this.getParentClass(), new TypeSelectorManagerImpl(project, type, expr, occurences));
        dialog.show();
        if (!dialog.isOK()) {
            if (occurences.length > 1) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
            return null;
        }
        return new BaseExpressionToFieldHandler.Settings(dialog.getEnteredName(), dialog.isReplaceAllOccurrences(), true, true, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, dialog.getFieldVisibility(), localVariable, dialog.getSelectedType(), dialog.isDeleteVariable(), dialog.getDestinationClass(), dialog.isAnnotateAsNonNls(), dialog.introduceEnumConstant());
    }

    private static void highlightError(Project project, Editor editor, PsiElement errorElement) {
        if (editor != null) {
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            TextRange textRange = errorElement.getTextRange();
            HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, new ArrayList());
        }
    }

    @Override
    protected String getRefactoringName() {
        return REFACTORING_NAME;
    }

    @Nullable
    private PsiElement isStaticFinalInitializer(PsiExpression expr) {
        PsiClass parentClass = this.getParentClass(expr);
        if (parentClass == null) {
            return null;
        }
        IsStaticFinalInitializerExpression visitor = new IsStaticFinalInitializerExpression(parentClass, expr);
        expr.accept((PsiElementVisitor)visitor);
        return visitor.getElementReference();
    }

    @Override
    protected OccurenceManager createOccurenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
        return new ExpressionOccurenceManager(selectedExpr, (PsiElement)parentClass, null);
    }

    @Override
    public PsiClass getParentClass(PsiExpression initializerExpression) {
        PsiType type = initializerExpression.getType();
        if (type != null && PsiUtil.isConstantExpression((PsiExpression)initializerExpression) && (type instanceof PsiPrimitiveType || PsiType.getJavaLangString((PsiManager)initializerExpression.getManager(), (GlobalSearchScope)initializerExpression.getResolveScope()).equals((Object)type))) {
            return super.getParentClass(initializerExpression);
        }
        PsiElement parent = (PsiElement)initializerExpression.getUserData(ElementToWorkOn.PARENT);
        if (parent == null) {
            parent = initializerExpression;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class);
        while (aClass != null) {
            if (aClass.hasModifierProperty("static")) {
                return aClass;
            }
            if (aClass.getParent() instanceof PsiJavaFile) {
                return aClass;
            }
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
        }
        return null;
    }

    @Override
    protected boolean validClass(PsiClass parentClass, Editor editor) {
        return true;
    }

    @Override
    protected boolean isStaticField() {
        return true;
    }

    private static class IsStaticFinalInitializerExpression
    extends ClassMemberReferencesVisitor {
        private PsiElement myElementReference = null;
        private final PsiExpression myInitializer;

        public IsStaticFinalInitializerExpression(PsiClass aClass, PsiExpression initializer) {
            super(aClass);
            this.myInitializer = initializer;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement psiElement = expression.resolve();
            if ((psiElement instanceof PsiLocalVariable || psiElement instanceof PsiParameter) && !PsiTreeUtil.isAncestor((PsiElement)this.myInitializer, (PsiElement)psiElement, (boolean)false)) {
                this.myElementReference = expression;
            } else {
                super.visitReferenceExpression(expression);
            }
        }

        @Override
        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (!classMember.hasModifierProperty("static")) {
                this.myElementReference = classMemberReference;
            }
        }

        public void visitElement(PsiElement element) {
            if (this.myElementReference != null) {
                return;
            }
            super.visitElement(element);
        }

        @Nullable
        public PsiElement getElementReference() {
            return this.myElementReference;
        }
    }
}

