/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodDialog;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;

class InlineMethodHandler
extends JavaInlineActionHandler {
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.method.title");

    private InlineMethodHandler() {
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiMethod && element.getNavigationElement() instanceof PsiMethod && element.getLanguage() == StdLanguages.JAVA;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        boolean invokedOnReference;
        PsiMethod method = (PsiMethod)element.getNavigationElement();
        if (method.getBody() == null) {
            String message = method.hasModifierProperty("abstract") ? RefactoringBundle.message((String)"refactoring.cannot.be.applied.to.abstract.methods", (Object[])new Object[]{REFACTORING_NAME}) : RefactoringBundle.message((String)"refactoring.cannot.be.applied.no.sources.attached", (Object[])new Object[]{REFACTORING_NAME});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
            return;
        }
        PsiReference reference = editor != null ? TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset()) : null;
        boolean allowInlineThisOnly = false;
        if (InlineMethodProcessor.checkBadReturns(method) && !InlineUtil.allUsagesAreTailCalls(method)) {
            if (reference != null && InlineUtil.getTailCallType(reference) != InlineUtil.TailCallType.None) {
                allowInlineThisOnly = true;
            } else {
                String message = RefactoringBundle.message((String)"refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
                return;
            }
        }
        if (reference == null && InlineMethodHandler.checkRecursive(method)) {
            String message = RefactoringBundle.message((String)"refactoring.is.not.supported.for.recursive.methods", (Object[])new Object[]{REFACTORING_NAME});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
            return;
        }
        if (method.isConstructor()) {
            if (method.isVarArgs()) {
                String message = RefactoringBundle.message((String)"refactoring.cannot.be.applied.to.vararg.constructors", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineConstructor");
                return;
            }
            if (!InlineMethodHandler.isChainingConstructor(method)) {
                String message = RefactoringBundle.message((String)"refactoring.cannot.be.applied.to.inline.non.chaining.constructors", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineConstructor");
                return;
            }
            if (reference != null) {
                PsiCall constructorCall;
                PsiElement refElement = reference.getElement();
                PsiCall psiCall = constructorCall = refElement instanceof PsiJavaCodeReferenceElement ? RefactoringUtil.getEnclosingConstructorCall((PsiJavaCodeReferenceElement)refElement) : null;
                if (constructorCall == null || !method.equals(constructorCall.resolveMethod())) {
                    reference = null;
                }
            }
        } else if (reference != null && !method.getManager().areElementsEquivalent((PsiElement)method, reference.resolve())) {
            reference = null;
        }
        boolean bl = invokedOnReference = reference != null;
        if (!invokedOnReference) {
            VirtualFile vFile = method.getContainingFile().getVirtualFile();
            ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{vFile});
        }
        PsiJavaCodeReferenceElement refElement = reference != null ? (PsiJavaCodeReferenceElement)reference.getElement() : null;
        InlineMethodDialog dialog = new InlineMethodDialog(project, method, refElement, editor, allowInlineThisOnly);
        dialog.show();
    }

    public static boolean isChainingConstructor(PsiMethod constructor) {
        PsiReferenceExpression methodExpr;
        PsiExpression expression;
        PsiStatement[] statements;
        PsiCodeBlock body = constructor.getBody();
        if (body != null && (statements = body.getStatements()).length == 1 && statements[0] instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && "this".equals((methodExpr = ((PsiMethodCallExpression)expression).getMethodExpression()).getReferenceName())) {
            PsiElement resolved = methodExpr.resolve();
            return resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor();
        }
        return false;
    }

    public static boolean checkRecursive(PsiMethod method) {
        return InlineMethodHandler.checkCalls((PsiElement)method.getBody(), method);
    }

    private static boolean checkCalls(PsiElement scope, PsiMethod method) {
        PsiMethod refMethod;
        if (scope instanceof PsiMethodCallExpression && method.equals(refMethod = (PsiMethod)((PsiMethodCallExpression)scope).getMethodExpression().resolve())) {
            return true;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!InlineMethodHandler.checkCalls(child, method)) continue;
            return true;
        }
        return false;
    }
}

