/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseProcessor;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.ui.RecentsManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public abstract class ExtractSuperBaseDialog
extends RefactoringDialog {
    protected String myRefactoringName;
    protected PsiClass mySourceClass;
    protected PsiDirectory myTargetDirectory;
    protected List<MemberInfo> myMemberInfos;
    protected JRadioButton myRbExtractSuperclass;
    protected JRadioButton myRbExtractSubclass;
    protected JTextField mySourceClassField;
    protected JTextField myExtractedSuperNameField;
    protected PackageNameReferenceEditorCombo myPackageNameField;
    protected DocCommentPanel myJavaDocPanel;
    private static final String DESTINATION_PACKAGE_RECENT_KEY = "ExtractSuperBase.RECENT_KEYS";

    public ExtractSuperBaseDialog(Project project, PsiClass sourceClass, List<MemberInfo> members, String refactoringName) {
        super(project, true);
        this.myRefactoringName = refactoringName;
        this.mySourceClass = sourceClass;
        this.myMemberInfos = members;
        this.myTargetDirectory = this.mySourceClass.getContainingFile().getContainingDirectory();
    }

    protected void init() {
        this.setTitle(this.myRefactoringName);
        this.initPackageNameField();
        this.initSourceClassField();
        this.myExtractedSuperNameField = new JTextField();
        this.myJavaDocPanel = new DocCommentPanel(this.getJavaDocPanelName());
        this.myJavaDocPanel.setPolicy(this.getJavaDocPolicySetting());
        super.init();
        this.updateDialogForExtractSuperclass();
    }

    private void initPackageNameField() {
        String name = "";
        PsiFile file = this.mySourceClass.getContainingFile();
        if (file instanceof PsiJavaFile) {
            name = ((PsiJavaFile)file).getPackageName();
        }
        this.myPackageNameField = new PackageNameReferenceEditorCombo(name, this.myProject, DESTINATION_PACKAGE_RECENT_KEY, RefactoringBundle.message((String)"choose.destination.package"));
    }

    private void initSourceClassField() {
        this.mySourceClassField = new JTextField();
        this.mySourceClassField.setEditable(false);
        this.mySourceClassField.setText(this.mySourceClass.getQualifiedName());
    }

    protected JComponent createActionComponent() {
        Box box = Box.createHorizontalBox();
        String s = StringUtil.decapitalize((String)this.getEntityName());
        this.myRbExtractSuperclass = new JRadioButton();
        this.myRbExtractSuperclass.setText(RefactoringBundle.message((String)"extractSuper.extract", (Object[])new Object[]{s}));
        this.myRbExtractSubclass = new JRadioButton();
        this.myRbExtractSubclass.setText(RefactoringBundle.message((String)"extractSuper.rename.original.class", (Object[])new Object[]{s}));
        box.add(this.myRbExtractSuperclass);
        box.add(this.myRbExtractSubclass);
        box.add(Box.createHorizontalGlue());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbExtractSuperclass);
        buttonGroup.add(this.myRbExtractSubclass);
        this.myRbExtractSuperclass.setSelected(true);
        this.myRbExtractSuperclass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExtractSuperBaseDialog.this.updateDialogForExtractSuperclass();
            }
        });
        this.myRbExtractSubclass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExtractSuperBaseDialog.this.updateDialogForExtractSubclass();
            }
        });
        return box;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedSuperNameField;
    }

    protected void updateDialogForExtractSubclass() {
        this.getClassNameLabel().setText(RefactoringBundle.message((String)"extractSuper.rename.original.class.to"));
        this.getPreviewAction().setEnabled(true);
    }

    protected void updateDialogForExtractSuperclass() {
        this.getClassNameLabel().setText(this.getClassNameLabelText());
        this.getPreviewAction().setEnabled(false);
    }

    public String getExtractedSuperName() {
        return this.myExtractedSuperNameField.getText().trim();
    }

    protected String getTargetPackageName() {
        return this.myPackageNameField.getText().trim();
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    protected abstract String getClassNameLabelText();

    protected abstract JLabel getClassNameLabel();

    protected abstract JLabel getPackageNameLabel();

    protected abstract String getEntityName();

    public int getJavaDocPolicy() {
        return this.myJavaDocPanel.getPolicy();
    }

    public boolean isExtractSuperclass() {
        return this.myRbExtractSuperclass.isSelected();
    }

    @Override
    protected void doAction() {
        final String[] errorString = new String[]{null};
        final String extractedSuperName = this.getExtractedSuperName();
        final String packageName = this.getTargetPackageName();
        RecentsManager.getInstance(this.myProject).registerRecentEntry(DESTINATION_PACKAGE_RECENT_KEY, packageName);
        final PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        if ("".equals(extractedSuperName)) {
            errorString[0] = this.getExtractedSuperNameNotSpecifiedKey();
            this.myExtractedSuperNameField.requestFocusInWindow();
        } else if (!JavaPsiFacade.getInstance((Project)manager.getProject()).getNameHelper().isIdentifier(extractedSuperName)) {
            errorString[0] = RefactoringMessageUtil.getIncorrectIdentifierMessage(extractedSuperName);
            this.myExtractedSuperNameField.requestFocusInWindow();
        } else {
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    try {
                        PsiDirectory[] directories;
                        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(packageName);
                        if (aPackage != null && (directories = aPackage.getDirectories(ExtractSuperBaseDialog.this.mySourceClass.getResolveScope())).length >= 1) {
                            ExtractSuperBaseDialog.this.myTargetDirectory = ExtractSuperBaseDialog.this.getDirUnderSameSourceRoot(directories);
                        }
                        ExtractSuperBaseDialog.this.myTargetDirectory = PackageUtil.findOrCreateDirectoryForPackage(ExtractSuperBaseDialog.this.myProject, packageName, ExtractSuperBaseDialog.this.myTargetDirectory, true);
                        if (ExtractSuperBaseDialog.this.myTargetDirectory == null) {
                            errorString[0] = "";
                            return;
                        }
                        errorString[0] = RefactoringMessageUtil.checkCanCreateClass(ExtractSuperBaseDialog.this.myTargetDirectory, extractedSuperName);
                    }
                    catch (IncorrectOperationException e) {
                        errorString[0] = e.getMessage();
                        ExtractSuperBaseDialog.this.myPackageNameField.requestFocusInWindow();
                    }
                }
            }, RefactoringBundle.message((String)"create.directory"), null);
        }
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                CommonRefactoringUtil.showErrorMessage((String)this.myRefactoringName, (String)errorString[0], (String)this.getHelpId(), (Project)this.myProject);
            }
            return;
        }
        if (!this.checkConflicts()) {
            return;
        }
        if (!this.isExtractSuperclass()) {
            this.invokeRefactoring(this.createProcessor());
        }
        this.setJavaDocPolicySetting(this.getJavaDocPolicy());
        this.closeOKAction();
    }

    private PsiDirectory getDirUnderSameSourceRoot(PsiDirectory[] directories) {
        ProjectFileIndex fileIndex;
        VirtualFile sourceRoot;
        VirtualFile sourceFile = this.mySourceClass.getContainingFile().getVirtualFile();
        if (sourceFile != null && (sourceRoot = (fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex()).getSourceRootForFile(sourceFile)) != null) {
            for (PsiDirectory dir : directories) {
                if (fileIndex.getSourceRootForFile(dir.getVirtualFile()) != sourceRoot) continue;
                return dir;
            }
        }
        return directories[0];
    }

    protected abstract String getJavaDocPanelName();

    protected abstract String getExtractedSuperNameNotSpecifiedKey();

    protected boolean checkConflicts() {
        return true;
    }

    protected abstract ExtractSuperBaseProcessor createProcessor();

    protected abstract int getJavaDocPolicySetting();

    protected abstract void setJavaDocPolicySetting(int var1);

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpId());
    }

    protected abstract String getHelpId();
}

