/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametersFolder {
    private final Map<PsiVariable, PsiExpression> myExpressions = new HashMap<PsiVariable, PsiExpression>();
    private final Map<PsiVariable, List<PsiExpression>> myMentionedInExpressions = new HashMap<PsiVariable, List<PsiExpression>>();
    private final Set<String> myUsedNames = new HashSet<String>();
    private final Set<PsiVariable> myDeleted = new HashSet<PsiVariable>();
    private boolean myFoldingSelectedByDefault = false;

    public void clear() {
        this.myExpressions.clear();
        this.myMentionedInExpressions.clear();
        this.myUsedNames.clear();
        this.myDeleted.clear();
    }

    public boolean isParameterSafeToDelete(@NotNull ParameterTablePanel.VariableData data, @NotNull LocalSearchScope scope) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractMethod/ParametersFolder.isParameterSafeToDelete must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/extractMethod/ParametersFolder.isParameterSafeToDelete must not be null");
        }
        block0: for (PsiReference reference : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
            PsiElement expression = reference.getElement();
            while (expression != null) {
                for (PsiExpression psiExpression : this.myExpressions.values()) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression, (PsiElement)psiExpression)) continue;
                    continue block0;
                }
                expression = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpression.class);
            }
            return false;
        }
        PsiExpression psiExpression = this.myExpressions.get(data.variable);
        if (psiExpression == null) {
            return true;
        }
        for (PsiVariable variable : this.myExpressions.keySet()) {
            PsiExpression expr;
            if (variable == data.variable || this.myDeleted.contains(variable) || (expr = this.myExpressions.get(variable)) == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expr, (PsiElement)psiExpression)) continue;
            this.myDeleted.add(data.variable);
            return true;
        }
        return false;
    }

    public void foldParameterUsagesInBody(@NotNull ParameterTablePanel.VariableData data, PsiElement[] elements, SearchScope scope) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractMethod/ParametersFolder.foldParameterUsagesInBody must not be null");
        }
        if (this.myDeleted.contains(data.variable)) {
            return;
        }
        PsiExpression psiExpression = this.myExpressions.get(data.variable);
        if (psiExpression == null) {
            return;
        }
        HashSet<PsiExpression> eqExpressions = new HashSet<PsiExpression>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
            PsiExpression expression = ParametersFolder.findEquivalent(psiExpression, reference.getElement());
            if (expression == null || !expression.isValid()) continue;
            eqExpressions.add(expression);
        }
        block1: for (PsiExpression expression : eqExpressions) {
            PsiExpression refExpression = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(data.variable.getName(), (PsiElement)expression);
            PsiElement replaced = expression.replace((PsiElement)refExpression);
            for (PsiElement psiElement : elements) {
                if (expression != psiElement) continue;
                elements[i] = replaced;
                continue block1;
            }
        }
    }

    public boolean isParameterFoldable(@NotNull ParameterTablePanel.VariableData data, @NotNull LocalSearchScope scope, @NotNull List<? extends PsiVariable> inputVariables) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractMethod/ParametersFolder.isParameterFoldable must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/extractMethod/ParametersFolder.isParameterFoldable must not be null");
        }
        if (inputVariables == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/extractMethod/ParametersFolder.isParameterFoldable must not be null");
        }
        List<PsiExpression> mentionedInExpressions = this.getMentionedExpressions(data.variable, scope);
        if (mentionedInExpressions == null) {
            return false;
        }
        int currentRank = 0;
        PsiExpression mostRanked = null;
        for (int i = mentionedInExpressions.size() - 1; i >= 0; --i) {
            PsiExpression expression = mentionedInExpressions.get(i);
            if (expression instanceof PsiArrayAccessExpression) {
                mostRanked = expression;
                this.myFoldingSelectedByDefault = true;
                break;
            }
            int r = ParametersFolder.findUsedVariables(data, inputVariables, expression).size();
            if (currentRank >= r) continue;
            currentRank = r;
            mostRanked = expression;
        }
        if (mostRanked != null) {
            this.myExpressions.put(data.variable, mostRanked);
            data.type = mostRanked.getType();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)mostRanked.getProject());
            SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, mostRanked, data.type);
            if (nameInfo.names.length > 0) {
                data.name = nameInfo.names[0];
            }
            this.setUniqueName(data);
        }
        return mostRanked != null;
    }

    private void setUniqueName(ParameterTablePanel.VariableData data) {
        int idx = 1;
        while (this.myUsedNames.contains(data.name)) {
            data.name = data.name + idx;
        }
        this.myUsedNames.add(data.name);
    }

    private static Set<PsiVariable> findUsedVariables(ParameterTablePanel.VariableData data, final List<? extends PsiVariable> inputVariables, PsiExpression expression) {
        final HashSet<PsiVariable> found = new HashSet<PsiVariable>();
        expression.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiVariable && inputVariables.contains(resolved)) {
                    found.add((PsiVariable)resolved);
                }
            }
        });
        found.remove(data.variable);
        return found;
    }

    public boolean isFoldable() {
        return !this.myExpressions.isEmpty();
    }

    @Nullable
    private List<PsiExpression> getMentionedExpressions(PsiVariable var, LocalSearchScope scope) {
        if (this.myMentionedInExpressions.containsKey(var)) {
            return this.myMentionedInExpressions.get(var);
        }
        PsiElement[] scopeElements = scope.getScope();
        ArrayList<PsiExpression> expressions = null;
        block0: for (PsiReference reference : ReferencesSearch.search((PsiElement)var, (SearchScope)scope)) {
            PsiElement expression = reference.getElement();
            if (expressions == null) {
                expressions = new ArrayList<PsiExpression>();
                while (expression != null) {
                    if (PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)expression))) {
                        return null;
                    }
                    for (PsiElement scopeElement : scopeElements) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)scopeElement, (boolean)true)) continue;
                        expression = null;
                        break;
                    }
                    if (expression == null) continue block0;
                    PsiType expressionType = ((PsiExpression)expression).getType();
                    if (expressionType != null && expressionType != PsiType.VOID && !(expression.getParent() instanceof PsiExpressionStatement)) {
                        expressions.add((PsiExpression)expression);
                    }
                    expression = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpression.class);
                }
                continue;
            }
            Iterator iterator = expressions.iterator();
            while (iterator.hasNext()) {
                if (ParametersFolder.findEquivalent((PsiExpression)iterator.next(), expression) != null) continue;
                iterator.remove();
            }
        }
        this.myMentionedInExpressions.put(var, expressions);
        return expressions;
    }

    @NotNull
    public String getGeneratedCallArgument(@NotNull ParameterTablePanel.VariableData data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractMethod/ParametersFolder.getGeneratedCallArgument must not be null");
        }
        String string = this.myExpressions.containsKey(data.variable) ? this.myExpressions.get(data.variable).getText() : data.variable.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/extractMethod/ParametersFolder.getGeneratedCallArgument must not return null");
        }
        return string;
    }

    public boolean annotateWithParameter(@NotNull ParameterTablePanel.VariableData data, @NotNull PsiElement element) {
        PsiExpression expression;
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractMethod/ParametersFolder.annotateWithParameter must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/extractMethod/ParametersFolder.annotateWithParameter must not be null");
        }
        PsiExpression psiExpression = this.myExpressions.get(data.variable);
        if (psiExpression != null && (expression = ParametersFolder.findEquivalent(psiExpression, element)) != null) {
            expression.putUserData(DuplicatesFinder.PARAMETER, (Object)Pair.create((Object)data.variable, (Object)expression.getType()));
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiExpression findEquivalent(PsiExpression expr, PsiElement element) {
        PsiElement expression = element;
        while (expression != null) {
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression, (PsiElement)expr)) {
                return (PsiExpression)expression;
            }
            expression = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpression.class);
        }
        return null;
    }

    public boolean wasExcluded(PsiVariable variable) {
        return this.myDeleted.contains(variable) || this.myMentionedInExpressions.containsKey(variable) && this.myExpressions.get(variable) == null;
    }

    public boolean isFoldingSelectedByDefault() {
        return this.myFoldingSelectedByDefault;
    }
}

