/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaInheritanceWeigher
extends ProximityWeigher {
    @Override
    public Comparable weigh(@NotNull PsiElement element, ProximityLocation location) {
        PsiClass psiClass;
        PsiType type;
        PsiExpression qualifierExpression;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/proximity/JavaInheritanceWeigher.weigh must not be null");
        }
        if (element instanceof PsiClass && JavaInheritanceWeigher.isTooGeneral((PsiClass)element)) {
            return Boolean.valueOf(false);
        }
        if (element instanceof PsiMethod && JavaInheritanceWeigher.isTooGeneral(((PsiMethod)element).getContainingClass())) {
            return Boolean.valueOf(false);
        }
        PsiElement position = location.getPosition();
        PsiClass placeClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (position.getParent() instanceof PsiReferenceExpression && (qualifierExpression = ((PsiReferenceExpression)position.getParent()).getQualifierExpression()) != null && (type = qualifierExpression.getType()) instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null) {
            placeClass = psiClass;
        }
        if (placeClass == null) {
            return Boolean.valueOf(false);
        }
        for (PsiClass contextClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)position, PsiClass.class, (boolean)false); contextClass != null; contextClass = contextClass.getContainingClass()) {
            for (PsiClass elementClass = placeClass; elementClass != null; elementClass = elementClass.getContainingClass()) {
                if (!contextClass.isInheritor(elementClass, true)) continue;
                return Boolean.valueOf(true);
            }
        }
        return Boolean.valueOf(false);
    }

    private static boolean isTooGeneral(@Nullable PsiClass element) {
        if (element == null) {
            return true;
        }
        String qname = element.getQualifiedName();
        return qname == null || qname.startsWith("java.lang.");
    }
}

