/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.TIntArrayList;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubUpdatingIndex
extends CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree, FileContent> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubUpdatingIndex");
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    private static final int VERSION = 18;
    private static final DataExternalizer<SerializedStubTree> KEY_EXTERNALIZER = new DataExternalizer<SerializedStubTree>(){

        public void save(DataOutput out, SerializedStubTree v) throws IOException {
            byte[] value = v.getBytes();
            out.writeInt(value.length);
            out.write(value);
        }

        public SerializedStubTree read(DataInput in) throws IOException {
            int len = in.readInt();
            byte[] result = new byte[len];
            in.readFully(result);
            return new SerializedStubTree(result);
        }
    };
    private static final FileBasedIndex.InputFilter INPUT_FILTER = new FileBasedIndex.InputFilter(){

        @Override
        public boolean acceptInput(VirtualFile file) {
            return StubUpdatingIndex.canHaveStub(file);
        }
    };
    private static final KeyDescriptor<Integer> DATA_DESCRIPTOR = new IntInlineKeyDescriptor();

    public static boolean canHaveStub(VirtualFile file) {
        FileType fileType = file.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType filetype = parserDefinition.getFileNodeType();
            return filetype instanceof IStubFileElementType && (((IStubFileElementType)filetype).shouldBuildStubFor(file) || IndexingStamp.isFileIndexed(file, INDEX_ID, IndexInfrastructure.getIndexCreationStamp(INDEX_ID)));
        }
        if (fileType.isBinary()) {
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            return builder != null && builder.acceptsFile(file);
        }
        return false;
    }

    @Override
    public ID<Integer, SerializedStubTree> getName() {
        return INDEX_ID;
    }

    @Override
    public int getCacheSize() {
        return 5;
    }

    @Override
    public DataIndexer<Integer, SerializedStubTree, FileContent> getIndexer() {
        return new DataIndexer<Integer, SerializedStubTree, FileContent>(){

            @Override
            @NotNull
            public Map<Integer, SerializedStubTree> map(final FileContent inputData) {
                final HashMap<Integer, SerializedStubTree> result = new HashMap<Integer, SerializedStubTree>();
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        StubElement rootStub = StubUpdatingIndex.buildStubTree(inputData);
                        if (rootStub == null) {
                            return;
                        }
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        SerializationManager.getInstance().serialize(rootStub, (OutputStream)bytes);
                        int key = Math.abs(FileBasedIndex.getFileId(inputData.getFile()));
                        result.put(key, new SerializedStubTree(bytes.toByteArray()));
                    }
                });
                HashMap<Integer, SerializedStubTree> hashMap = result;
                if (hashMap == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/StubUpdatingIndex$3.map must not return null");
                }
                return hashMap;
            }
        };
    }

    @Nullable
    static StubElement buildStubTree(FileContent inputData) {
        FileType fileType = inputData.getFileType();
        if (fileType.isBinary()) {
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            assert (builder != null);
            return builder.buildStubTree(inputData.getFile(), inputData.getContent(), inputData.getProject());
        }
        LanguageFileType filetype = (LanguageFileType)fileType;
        Language l = filetype.getLanguage();
        IFileElementType type = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l)).getFileNodeType();
        PsiFile psi = inputData.getPsiFile();
        return ((IStubFileElementType)type).getBuilder().buildStubTree(psi);
    }

    @Override
    public KeyDescriptor<Integer> getKeyDescriptor() {
        return DATA_DESCRIPTOR;
    }

    @Override
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        return KEY_EXTERNALIZER;
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        return INPUT_FILTER;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return StubUpdatingIndex.getCumulativeVersion();
    }

    private static int getCumulativeVersion() {
        int version = 18;
        for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            BinaryFileStubBuilder builder;
            if (fileType instanceof LanguageFileType) {
                IFileElementType type;
                Language l = ((LanguageFileType)fileType).getLanguage();
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
                if (parserDefinition == null || !((type = parserDefinition.getFileNodeType()) instanceof IStubFileElementType)) continue;
                version += ((IStubFileElementType)type).getStubVersion();
                continue;
            }
            if (!fileType.isBinary() || (builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) == null) continue;
            version += builder.getStubVersion();
        }
        return version;
    }

    @Override
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(ID<Integer, SerializedStubTree> indexId, FileBasedIndex owner, IndexStorage<Integer, SerializedStubTree> storage) {
        if (storage instanceof MemoryIndexStorage) {
            MemoryIndexStorage memStorage = (MemoryIndexStorage)storage;
            memStorage.addBufferingStateListsner(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    ((StubIndexImpl)StubIndexImpl.getInstance()).setDataBufferingEnabled(newState);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndexImpl.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        return new MyIndex(indexId, owner, storage, this.getIndexer());
    }

    private static void updateStubIndices(Collection<StubIndexKey> indexKeys, int inputId, Map<StubIndexKey, Map<Object, TIntArrayList>> oldStubTree, Map<StubIndexKey, Map<Object, TIntArrayList>> newStubTree) {
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        for (StubIndexKey key : indexKeys) {
            Map<Object, TIntArrayList> oldMap = oldStubTree.get(key);
            Map<Object, TIntArrayList> newMap = newStubTree.get(key);
            Map<Object, Object> _oldMap = oldMap != null ? oldMap : Collections.emptyMap();
            Map<Object, Object> _newMap = newMap != null ? newMap : Collections.emptyMap();
            stubIndex.updateIndex(key, inputId, _oldMap, _newMap);
        }
    }

    private static Collection<StubIndexKey> getAffectedIndices(Map<StubIndexKey, Map<Object, TIntArrayList>> oldStubTree, Map<StubIndexKey, Map<Object, TIntArrayList>> newStubTree) {
        HashSet<StubIndexKey> allIndices = new HashSet<StubIndexKey>();
        allIndices.addAll(oldStubTree.keySet());
        allIndices.addAll(newStubTree.keySet());
        return allIndices;
    }

    private static class MyIndex
    extends MapReduceIndex<Integer, SerializedStubTree, FileContent> {
        private final StubIndexImpl myStubIndex = (StubIndexImpl)StubIndex.getInstance();

        public MyIndex(ID<Integer, SerializedStubTree> indexId, FileBasedIndex owner, IndexStorage<Integer, SerializedStubTree> storage, DataIndexer<Integer, SerializedStubTree, FileContent> indexer) {
            super(indexId, indexer, storage);
            try {
                MyIndex.checkNameStorage();
            }
            catch (StorageException e) {
                LOG.info((Throwable)e);
                FileBasedIndex.requestRebuild(INDEX_ID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws StorageException {
            StubIndexImpl stubIndex = this.myStubIndex;
            try {
                for (StubIndexKey key : stubIndex.getAllStubIndexKeys()) {
                    stubIndex.flush(key);
                }
            }
            finally {
                super.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateWithMap(int inputId, Map<Integer, SerializedStubTree> newData, Callable<Collection<Integer>> oldKeysGetter) throws StorageException {
            MyIndex.checkNameStorage();
            Map<StubIndexKey, Map<Object, TIntArrayList>> newStubTree = MyIndex.getStubTree(newData);
            StubIndexImpl stubIndex = this.myStubIndex;
            Collection<StubIndexKey> allStubIndices = stubIndex.getAllStubIndexKeys();
            try {
                for (StubIndexKey key : allStubIndices) {
                    stubIndex.getWriteLock(key).lock();
                }
                try {
                    this.getWriteLock().lock();
                    Map<Integer, SerializedStubTree> oldData = this.readOldData(inputId);
                    Map<StubIndexKey, Map<Object, TIntArrayList>> oldStubTree = MyIndex.getStubTree(oldData);
                    super.updateWithMap(inputId, newData, oldKeysGetter);
                    StubUpdatingIndex.updateStubIndices(StubUpdatingIndex.getAffectedIndices(oldStubTree, newStubTree), inputId, oldStubTree, newStubTree);
                }
                finally {
                    this.getWriteLock().unlock();
                }
            }
            finally {
                for (StubIndexKey key : allStubIndices) {
                    stubIndex.getWriteLock(key).unlock();
                }
            }
        }

        private static void checkNameStorage() throws StorageException {
            SerializationManager serializationManager = SerializationManager.getInstance();
            if (serializationManager.isNameStorageCorrupted()) {
                serializationManager.repairNameStorage();
                throw new StorageException("NameStorage for stubs serialization has been corrupted");
            }
        }

        private static Map<StubIndexKey, Map<Object, TIntArrayList>> getStubTree(Map<Integer, SerializedStubTree> data) {
            Map<StubIndexKey, Map<Object, TIntArrayList>> stubTree;
            if (!data.isEmpty()) {
                SerializedStubTree stub = data.values().iterator().next();
                stubTree = new StubTree((PsiFileStub)stub.getStub()).indexStubTree();
            } else {
                stubTree = Collections.emptyMap();
            }
            return stubTree;
        }

        private Map<Integer, SerializedStubTree> readOldData(int key) throws StorageException {
            ValueContainer valueContainer;
            MemoryIndexStorage memIndexStorage;
            HashMap<Integer, SerializedStubTree> result = new HashMap<Integer, SerializedStubTree>();
            IndexStorage indexStorage = this.myStorage;
            if (indexStorage instanceof MemoryIndexStorage && !(memIndexStorage = (MemoryIndexStorage)indexStorage).isBufferingEnabled()) {
                indexStorage = memIndexStorage.getBackendStorage();
            }
            if ((valueContainer = indexStorage.read(key)).size() != 1) {
                LOG.assertTrue(valueContainer.size() == 0);
                return result;
            }
            result.put(key, (SerializedStubTree)valueContainer.getValueIterator().next());
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() throws StorageException {
            StubIndexImpl stubIndex = this.myStubIndex;
            try {
                for (StubIndexKey key : stubIndex.getAllStubIndexKeys()) {
                    stubIndex.getWriteLock(key).lock();
                }
                this.getWriteLock().lock();
                stubIndex.clearAllIndices();
                super.clear();
            }
            finally {
                this.getWriteLock().unlock();
                for (StubIndexKey key : stubIndex.getAllStubIndexKeys()) {
                    stubIndex.getWriteLock(key).unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            try {
                super.dispose();
            }
            finally {
                try {
                    this.myStubIndex.dispose();
                }
                finally {
                    ((SerializationManagerImpl)SerializationManager.getInstance()).disposeComponent();
                }
            }
        }
    }
}

