/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.List;

public class FilterScopeProcessor<T>
extends BaseScopeProcessor {
    protected final List<T> myResults;
    private PsiElement myCurrentDeclarationHolder;
    private final ElementFilter myFilter;
    private final PsiScopeProcessor myProcessor;

    public FilterScopeProcessor(ElementFilter filter, PsiScopeProcessor processor, List<T> container) {
        this.myFilter = filter;
        this.myProcessor = processor;
        this.myResults = container;
    }

    public FilterScopeProcessor(ElementFilter filter, List<T> container) {
        this(filter, null, container);
    }

    public FilterScopeProcessor(ElementFilter filter, PsiScopeProcessor proc) {
        this(filter, proc, (List<T>)new SmartList());
    }

    public FilterScopeProcessor(ElementFilter filter) {
        this(filter, null, (List<T>)new SmartList());
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (this.myProcessor != null) {
            this.myProcessor.handleEvent(event, associated);
        }
        if (event == PsiScopeProcessor.Event.SET_DECLARATION_HOLDER && associated instanceof PsiElement) {
            this.myCurrentDeclarationHolder = (PsiElement)associated;
        }
    }

    public boolean execute(PsiElement element, ResolveState state) {
        if (this.myFilter.isAcceptable((Object)element, this.myCurrentDeclarationHolder)) {
            if (this.myProcessor != null) {
                return this.myProcessor.execute(element, state);
            }
            this.add(element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY));
        }
        return true;
    }

    protected void add(PsiElement element, PsiSubstitutor substitutor) {
        this.myResults.add(element);
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (this.myProcessor != null) {
            return (T)this.myProcessor.getHint(hintKey);
        }
        return null;
    }

    public List<T> getResults() {
        return this.myResults;
    }
}

