/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;

public class PsiConditionalExpressionImpl
extends ExpressionPsiElement
implements PsiConditionalExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiConditionalExpressionImpl");

    public PsiConditionalExpressionImpl() {
        super(JavaElementType.CONDITIONAL_EXPRESSION);
    }

    @NotNull
    public PsiExpression getCondition() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(32);
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiConditionalExpressionImpl.getCondition must not return null");
        }
        return psiExpression;
    }

    public PsiExpression getThenExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(112);
    }

    public PsiExpression getElseExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(113);
    }

    public PsiType getType() {
        PsiType type2;
        PsiExpression expr1 = this.getThenExpression();
        PsiExpression expr2 = this.getElseExpression();
        PsiType type1 = expr1 == null ? null : expr1.getType();
        PsiType psiType = type2 = expr2 == null ? null : expr2.getType();
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.equals(type2)) {
            return type1;
        }
        int typeRank1 = TypeConversionUtil.getTypeRank((PsiType)type1);
        int typeRank2 = TypeConversionUtil.getTypeRank((PsiType)type2);
        if (type1 instanceof PsiClassType && type2.equals(PsiPrimitiveType.getUnboxedType((PsiType)type1))) {
            return type2;
        }
        if (type2 instanceof PsiClassType && type1.equals(PsiPrimitiveType.getUnboxedType((PsiType)type2))) {
            return type1;
        }
        if (TypeConversionUtil.isNumericType((int)typeRank1) && TypeConversionUtil.isNumericType((int)typeRank2)) {
            if (typeRank1 == 1 && typeRank2 == 2) {
                return type2;
            }
            if (typeRank1 == 2 && typeRank2 == 1) {
                return type1;
            }
            if (typeRank2 == 4 && (typeRank1 == 1 || typeRank1 == 2 || typeRank1 == 3) && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)type1, (PsiExpression)expr2)) {
                return type1;
            }
            if (typeRank1 == 4 && (typeRank2 == 1 || typeRank2 == 2 || typeRank2 == 3) && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)type2, (PsiExpression)expr1)) {
                return type2;
            }
            return TypeConversionUtil.binaryNumericPromotion((PsiType)type1, (PsiType)type2);
        }
        if (TypeConversionUtil.isNullType((PsiType)type1) && !(type2 instanceof PsiPrimitiveType)) {
            return type2;
        }
        if (TypeConversionUtil.isNullType((PsiType)type2) && !(type1 instanceof PsiPrimitiveType)) {
            return type1;
        }
        if (TypeConversionUtil.isAssignable((PsiType)type1, (PsiType)type2, (boolean)false)) {
            return type1;
        }
        if (TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)type1, (boolean)false)) {
            return type2;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)this)) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type1) && (type1 = ((PsiPrimitiveType)type1).getBoxedType((PsiElement)this)) == null) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2) && (type2 = ((PsiPrimitiveType)type2).getBoxedType((PsiElement)this)) == null) {
            return null;
        }
        return GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type2, (PsiManager)this.getManager());
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 32: {
                return this.getFirstChildNode();
            }
            case 114: {
                return this.findChildByType(JavaTokenType.QUEST);
            }
            case 112: {
                ASTNode quest = this.findChildByRole(114);
                ASTNode child = quest.getTreeNext();
                while (true) {
                    if (child == null) {
                        return null;
                    }
                    if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) break;
                    child = child.getTreeNext();
                }
                return child;
            }
            case 87: {
                return this.findChildByType(JavaTokenType.COLON);
            }
            case 113: 
        }
        ASTNode colon = this.findChildByRole(87);
        if (colon == null) {
            return null;
        }
        return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            int role = this.getChildRole(child, 32);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 112);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 113);
            return role;
        }
        if (child.getElementType() == JavaTokenType.QUEST) {
            return 114;
        }
        if (child.getElementType() == JavaTokenType.COLON) {
            return 87;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiConditionalExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitConditionalExpression((PsiConditionalExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiConditionalExpression:" + this.getText();
    }
}

