/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.light.LightModifierList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiCompositeModifierList
extends LightModifierList {
    private final List<PsiModifierList> mySublists;

    public PsiCompositeModifierList(PsiManager manager, List<PsiModifierList> sublists) {
        super(manager);
        this.mySublists = sublists;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        ArrayList<PsiAnnotation> annotations = new ArrayList<PsiAnnotation>();
        for (PsiModifierList list : this.mySublists) {
            annotations.addAll(Arrays.asList(list.getAnnotations()));
        }
        PsiAnnotation[] psiAnnotationArray = annotations.toArray(new PsiAnnotation[annotations.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList.findAnnotation must not be null");
        }
        for (PsiModifierList sublist : this.mySublists) {
            PsiAnnotation annotation = sublist.findAnnotation(qualifiedName);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList.hasModifierProperty must not be null");
        }
        for (PsiModifierList sublist : this.mySublists) {
            if (!sublist.hasModifierProperty(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList.hasExplicitModifier must not be null");
        }
        for (PsiModifierList sublist : this.mySublists) {
            if (!sublist.hasExplicitModifier(name)) continue;
            return true;
        }
        return false;
    }
}

