/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;

class LeafPatcher
extends RecursiveTreeElementWalkingVisitor {
    private LeafElement prevElement;
    private String prevElementTail;
    private int shredNo;
    private String hostText;
    private final Place myShreds;
    private final List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> myEscapers;
    final Map<LeafElement, String> newTexts = new THashMap();
    final StringBuilder catLeafs = new StringBuilder();

    LeafPatcher(Place shreds, List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers) {
        this.myShreds = shreds;
        this.myEscapers = escapers;
    }

    @Override
    public void visitLeaf(LeafElement leaf) {
        String leafText = leaf.getText();
        this.catLeafs.append(leafText);
        TextRange leafRange = leaf.getTextRange();
        StringBuilder leafEncodedText = this.constructTextFromHostPSI(leafRange.getStartOffset(), leafRange.getEndOffset());
        if (leaf.getElementType() == TokenType.WHITE_SPACE && this.prevElementTail != null) {
            leafEncodedText.insert(0, this.prevElementTail);
            this.newTexts.remove(this.prevElement);
            LeafPatcher.storeUnescapedTextFor(this.prevElement, null);
        }
        if (!Comparing.equal((CharSequence)leafText, (CharSequence)leafEncodedText)) {
            this.newTexts.put(leaf, leafEncodedText.toString());
            LeafPatcher.storeUnescapedTextFor(leaf, leafText);
        }
        this.prevElementTail = StringUtil.startsWith((CharSequence)leafEncodedText, (CharSequence)leafText) && leafEncodedText.length() != leafText.length() ? leafEncodedText.substring(leafText.length()) : null;
        this.prevElement = leaf;
    }

    private StringBuilder constructTextFromHostPSI(int startOffset, int endOffset) {
        PsiLanguageInjectionHost.Shred current = (PsiLanguageInjectionHost.Shred)this.myShreds.get(this.shredNo);
        if (this.hostText == null) {
            this.hostText = current.host.getText();
        }
        StringBuilder text = new StringBuilder(endOffset - startOffset);
        while (startOffset < endOffset) {
            TextRange shredRange = current.range;
            String prefix = current.prefix;
            if (startOffset >= shredRange.getEndOffset()) {
                current = (PsiLanguageInjectionHost.Shred)this.myShreds.get(++this.shredNo);
                this.hostText = current.host.getText();
                continue;
            }
            assert (startOffset >= shredRange.getStartOffset());
            if (startOffset - shredRange.getStartOffset() < prefix.length()) {
                TextRange rangeInPrefix = new TextRange(startOffset - shredRange.getStartOffset(), Math.min(prefix.length(), endOffset - shredRange.getStartOffset()));
                text.append(prefix, rangeInPrefix.getStartOffset(), rangeInPrefix.getEndOffset());
                startOffset += rangeInPrefix.getLength();
                continue;
            }
            String suffix = current.suffix;
            if (startOffset < shredRange.getEndOffset() - suffix.length()) {
                int startOffsetInHost = this.myEscapers.get(this.shredNo).getOffsetInHost(startOffset - shredRange.getStartOffset() - prefix.length(), current.getRangeInsideHost());
                int endOffsetCut = Math.min(endOffset, shredRange.getEndOffset() - suffix.length());
                int endOffsetInHost = this.myEscapers.get(this.shredNo).getOffsetInHost(endOffsetCut - shredRange.getStartOffset() - prefix.length(), current.getRangeInsideHost());
                if (endOffsetInHost != -1) {
                    text.append(this.hostText, startOffsetInHost, endOffsetInHost);
                    startOffset = endOffsetCut;
                    continue;
                }
            }
            TextRange rangeInSuffix = new TextRange(suffix.length() - shredRange.getEndOffset() + startOffset, Math.min(suffix.length(), endOffset + suffix.length() - shredRange.getEndOffset()));
            text.append(suffix, rangeInSuffix.getStartOffset(), rangeInSuffix.getEndOffset());
            startOffset += rangeInSuffix.getLength();
        }
        return text;
    }

    private static void storeUnescapedTextFor(LeafElement leaf, String leafText) {
        PsiElement psi = leaf.getPsi();
        if (psi != null) {
            psi.putUserData(InjectedLanguageManagerImpl.UNESCAPED_TEXT, (Object)leafText);
        }
    }
}

