/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceProviderBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.AttributeValueSelfReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdRefReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IdReferenceProvider
extends PsiReferenceProviderBase {
    @NonNls
    public static final String FOR_ATTR_NAME = "for";
    @NonNls
    public static final String ID_ATTR_NAME = "id";
    @NonNls
    public static final String STYLE_ID_ATTR_NAME = "styleId";
    @NonNls
    public static final String NAME_ATTR_NAME = "name";
    private static final THashSet<String> ourNamespacesWithoutNameReference = new THashSet();

    public String[] getIdForAttributeNames() {
        return new String[]{FOR_ATTR_NAME, ID_ATTR_NAME, NAME_ATTR_NAME, STYLE_ID_ATTR_NAME};
    }

    public ElementFilter getIdForFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                XmlTag tag;
                PsiElement grandParent = ((PsiElement)element).getParent().getParent();
                return grandParent instanceof XmlTag && (tag = (XmlTag)grandParent).getNamespacePrefix().length() > 0;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/IdReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/IdReferenceProvider.getReferencesByElement must not be null");
        }
        if (element instanceof XmlAttributeValue) {
            boolean allowReferences;
            boolean jsfNs;
            XmlExtension extension = XmlExtension.getExtensionByElement(element);
            if (extension != null && extension.hasDynamicComponents(element)) {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
                if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/IdReferenceProvider.getReferencesByElement must not return null");
                return psiReferenceArray;
            }
            final PsiElement parentElement = element.getParent();
            if (!(parentElement instanceof XmlAttribute)) {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
                if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/IdReferenceProvider.getReferencesByElement must not return null");
                return psiReferenceArray;
            }
            String name = ((XmlAttribute)parentElement).getName();
            String ns = ((XmlAttribute)parentElement).getParent().getNamespace();
            boolean bl = jsfNs = "http://java.sun.com/jsf/core".equals(ns) || "http://java.sun.com/jsf/html".equals(ns);
            if (FOR_ATTR_NAME.equals(name)) {
                psiReferenceArray = new PsiReference[]{jsfNs && element.getText().indexOf(58) == -1 ? new IdRefReference(element) : new IdRefReference(element){

                    @Override
                    public boolean isSoft() {
                        XmlAttributeDescriptor descriptor = ((XmlAttribute)parentElement).getDescriptor();
                        return descriptor != null ? !descriptor.hasIdRefType() : false;
                    }
                }};
                if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/IdReferenceProvider.getReferencesByElement must not return null");
                return psiReferenceArray;
            }
            boolean bl2 = allowReferences = !ourNamespacesWithoutNameReference.contains((Object)ns);
            if (ID_ATTR_NAME.equals(name) && allowReferences || STYLE_ID_ATTR_NAME.equals(name) || NAME_ATTR_NAME.equals(name) && allowReferences) {
                AttributeValueSelfReference attributeValueSelfReference = jsfNs ? new AttributeValueSelfReference(element) : new GlobalAttributeValueSelfReference(element, true);
                psiReferenceArray = new PsiReference[]{attributeValueSelfReference};
                if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/IdReferenceProvider.getReferencesByElement must not return null");
                return psiReferenceArray;
            }
        }
        psiReferenceArray = PsiReference.EMPTY_ARRAY;
        if (PsiReference.EMPTY_ARRAY != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/IdReferenceProvider.getReferencesByElement must not return null");
    }

    static {
        ourNamespacesWithoutNameReference.add((Object)"http://java.sun.com/JSP/Page");
        ourNamespacesWithoutNameReference.add((Object)"http://struts.apache.org/tags-bean");
        ourNamespacesWithoutNameReference.add((Object)"http://jakarta.apache.org/struts/tags-bean");
        ourNamespacesWithoutNameReference.add((Object)"http://struts.apache.org/tags-logic");
        for (String s : XmlUtil.JSTL_CORE_URIS) {
            ourNamespacesWithoutNameReference.add((Object)s);
        }
        ourNamespacesWithoutNameReference.add((Object)"http://struts.apache.org/tags-tiles");
        for (String s : XmlUtil.SCHEMA_URIS) {
            ourNamespacesWithoutNameReference.add((Object)s);
        }
    }

    public static class GlobalAttributeValueSelfReference
    extends AttributeValueSelfReference {
        private final boolean mySoft;

        public GlobalAttributeValueSelfReference(PsiElement element, boolean soft) {
            super(element);
            this.mySoft = soft;
        }

        @Override
        public boolean isSoft() {
            return this.mySoft;
        }
    }
}

