/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiElementArrayConstructor;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PsiDocCommentImpl
extends LazyParseablePsiElement
implements PsiDocComment,
JavaTokenType,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.javadoc.PsiDocCommentImpl");
    private static final TokenSet TAG_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{DOC_TAG});
    private static final PsiElementArrayConstructor<PsiDocTag> PSI_TAG_ARRAY_CONSTRUCTOR = new PsiElementArrayConstructor<PsiDocTag>(){

        public PsiDocTag[] newPsiElementArray(int length) {
            return length == 0 ? PsiDocTag.EMPTY_ARRAY : new PsiDocTag[length];
        }
    };
    private static final Pattern WS_PATTERN = Pattern.compile("\\s*");

    public PsiDocCommentImpl(CharSequence text) {
        super((IElementType)JavaDocElementType.DOC_COMMENT, text);
    }

    public PsiDocCommentOwner getOwner() {
        PsiDocCommentOwner owner;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiDocCommentOwner && (owner = (PsiDocCommentOwner)parent).getDocComment() == this) {
            return owner;
        }
        return null;
    }

    @NotNull
    public PsiElement[] getDescriptionElements() {
        IElementType i;
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (TreeElement child = this.getFirstChildNode(); child != null && (i = child.getElementType()) != DOC_TAG; child = child.getTreeNext()) {
            if (i == DOC_COMMENT_START || i == DOC_COMMENT_END || i == DOC_COMMENT_LEADING_ASTERISKS) continue;
            array.add(child.getPsi());
        }
        PsiElement[] psiElementArray = array.toArray(new PsiElement[array.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.getDescriptionElements must not return null");
        }
        return psiElementArray;
    }

    @NotNull
    public PsiDocTag[] getTags() {
        PsiDocTag[] psiDocTagArray = (PsiDocTag[])this.getChildrenAsPsiElements(TAG_BIT_SET, PSI_TAG_ARRAY_CONSTRUCTOR);
        if (psiDocTagArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.getTags must not return null");
        }
        return psiDocTagArray;
    }

    public PsiDocTag findTagByName(String name) {
        if (this.getFirstChildNode().getElementType() == JavaDocElementType.DOC_COMMENT && this.getFirstChildNode().getText().indexOf(name) < 0) {
            return null;
        }
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiDocTag tag;
            CharSequence nameText;
            if (child.getElementType() != DOC_TAG || (nameText = ((LeafElement)(tag = (PsiDocTag)SourceTreeToPsiMap.treeElementToPsi(child)).getNameElement()).getChars()).length() <= 0 || nameText.charAt(0) != '@' || !CharArrayUtil.regionMatches((CharSequence)nameText, (int)1, (CharSequence)name)) continue;
            return tag;
        }
        return null;
    }

    @NotNull
    public PsiDocTag[] findTagsByName(String name) {
        ArrayList<PsiDocTag> array = new ArrayList<PsiDocTag>();
        PsiDocTag[] tags = this.getTags();
        name = "@" + name;
        for (PsiDocTag tag : tags) {
            if (!tag.getNameElement().getText().equals(name)) continue;
            array.add(tag);
        }
        PsiDocTag[] psiDocTagArray = array.toArray(new PsiDocTag[array.size()]);
        if (psiDocTagArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.findTagsByName must not return null");
        }
        return psiDocTagArray;
    }

    public IElementType getTokenType() {
        return this.getElementType();
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 110: {
                return this.getFirstChildNode();
            }
            case 111: 
        }
        if (this.getLastChildNode().getElementType() == DOC_COMMENT_END) {
            return this.getLastChildNode();
        }
        return null;
    }

    private static boolean isWhitespaceCommentData(ASTNode docCommentData) {
        return WS_PATTERN.matcher(docCommentData.getText()).matches();
    }

    private static void addNewLineToTag(CompositeElement tag, Project project) {
        TreeElement current;
        LOG.assertTrue(tag != null && tag.getElementType() == DOC_TAG);
        for (current = tag.getLastChildNode(); current != null && current.getElementType() == DOC_COMMENT_DATA && PsiDocCommentImpl.isWhitespaceCommentData(current); current = current.getTreePrev()) {
        }
        if (current != null && current.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
            return;
        }
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(tag);
        LeafElement newLine = Factory.createSingleLeafElement(DOC_COMMENT_DATA, "\n", 0, 1, treeCharTab, SharedImplUtil.getManagerByTree(tag));
        tag.addChild(newLine, null);
        TreeElement leadingWhitespaceAnchor = null;
        if (CodeStyleSettingsManager.getSettings((Project)project).JD_LEADING_ASTERISKS_ARE_ENABLED) {
            LeafElement leadingAsterisk = Factory.createSingleLeafElement(DOC_COMMENT_LEADING_ASTERISKS, "*", 0, 1, treeCharTab, SharedImplUtil.getManagerByTree(tag));
            leadingWhitespaceAnchor = tag.addInternal(leadingAsterisk, leadingAsterisk, null, Boolean.TRUE);
        }
        LeafElement commentData = Factory.createSingleLeafElement(DOC_COMMENT_DATA, " ", 0, 1, treeCharTab, SharedImplUtil.getManagerByTree(tag));
        tag.addInternal(commentData, commentData, leadingWhitespaceAnchor, Boolean.TRUE);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        boolean needToAddNewline = false;
        if (first == last && first.getElementType() == DOC_TAG) {
            if (anchor == null) {
                anchor = this.getLastChildNode();
                ASTNode prevBeforeWS = TreeUtil.skipElementsBack(anchor.getTreePrev(), WHITE_SPACE_BIT_SET);
                if (prevBeforeWS != null) {
                    anchor = prevBeforeWS;
                    before = Boolean.FALSE;
                } else {
                    before = Boolean.TRUE;
                }
                needToAddNewline = true;
            }
            if (anchor.getElementType() != DOC_TAG) {
                CharTable charTable = SharedImplUtil.findCharTableByTree(this);
                LeafElement newLine = Factory.createSingleLeafElement(DOC_COMMENT_DATA, "\n", 0, 1, charTable, this.getManager());
                LeafElement leadingAsterisk = Factory.createSingleLeafElement(DOC_COMMENT_LEADING_ASTERISKS, "*", 0, 1, charTable, this.getManager());
                LeafElement commentData = Factory.createSingleLeafElement(DOC_COMMENT_DATA, " ", 0, 1, charTable, this.getManager());
                LeafElement indentWS = Factory.createSingleLeafElement(DOC_COMMENT_DATA, " ", 0, 1, charTable, this.getManager());
                newLine.getTreeParent().addChild(indentWS);
                newLine.getTreeParent().addChild(leadingAsterisk);
                newLine.getTreeParent().addChild(commentData);
                super.addInternal(newLine, commentData, anchor, Boolean.FALSE);
                anchor = commentData;
                before = Boolean.FALSE;
            } else {
                needToAddNewline = true;
            }
        }
        if (before.booleanValue()) {
            anchor.getTreeParent().addChildren((ASTNode)first, last.getTreeNext(), anchor);
        } else {
            anchor.getTreeParent().addChildren((ASTNode)first, last.getTreeNext(), anchor.getTreeNext());
        }
        if (needToAddNewline) {
            if (first.getTreePrev() != null && first.getTreePrev().getElementType() == DOC_TAG) {
                PsiDocCommentImpl.addNewLineToTag((CompositeElement)first.getTreePrev(), this.getProject());
            }
            if (first.getTreeNext() != null && first.getTreeNext().getElementType() == DOC_TAG) {
                PsiDocCommentImpl.addNewLineToTag((CompositeElement)first, this.getProject());
            } else {
                PsiDocCommentImpl.removeEndingAsterisksFromTag((CompositeElement)first);
            }
        }
        return first;
    }

    private static void removeEndingAsterisksFromTag(CompositeElement tag) {
        TreeElement current;
        for (current = tag.getLastChildNode(); current != null && current.getElementType() == DOC_COMMENT_DATA; current = current.getTreePrev()) {
        }
        if (current != null && current.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
            ASTNode prevWhiteSpace = TreeUtil.skipElementsBack(current.getTreePrev(), WHITE_SPACE_BIT_SET);
            ASTNode toBeDeleted = prevWhiteSpace.getTreeNext();
            while (toBeDeleted != null) {
                ASTNode next = toBeDeleted.getTreeNext();
                tag.deleteChildInternal(toBeDeleted);
                toBeDeleted = next;
            }
        }
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.deleteChildInternal must not be null");
        }
        if (child.getElementType() == DOC_TAG && (child.getTreeNext() == null || child.getTreeNext().getElementType() != DOC_TAG)) {
            ASTNode next;
            ASTNode prev;
            for (prev = child.getTreePrev(); prev != null && prev.getElementType() == DOC_COMMENT_DATA; prev = prev.getTreePrev()) {
            }
            for (next = child.getTreeNext(); next != null && (next.getElementType() == DOC_COMMENT_DATA || next.getElementType() == WHITE_SPACE); next = next.getTreeNext()) {
            }
            if (prev != null && prev.getElementType() == DOC_COMMENT_LEADING_ASTERISKS && !(next instanceof PsiDocTag)) {
                ASTNode leadingAsterisk = prev;
                if (leadingAsterisk.getTreePrev() != null) {
                    super.deleteChildInternal(leadingAsterisk.getTreePrev());
                    super.deleteChildInternal(leadingAsterisk);
                }
            } else if (prev != null && prev.getElementType() == DOC_TAG) {
                TreeElement lastPrevChild;
                TreeElement prevChild;
                CompositeElement compositePrev = (CompositeElement)prev;
                for (prevChild = lastPrevChild = compositePrev.getLastChildNode(); prevChild != null && prevChild.getElementType() == DOC_COMMENT_DATA; prevChild = prevChild.getTreePrev()) {
                }
                if (prevChild != null && prevChild.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
                    TreeElement current = prevChild;
                    while (current != null) {
                        ASTNode nextChild = current.getTreeNext();
                        compositePrev.deleteChildInternal(current);
                        current = nextChild;
                    }
                }
            } else {
                next = child.getTreeNext();
                if (next != null && next.getElementType() == WHITE_SPACE) {
                    next.getTreeParent().removeChild(next);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == DOC_TAG) {
            return 104;
        }
        if (i == JavaDocElementType.DOC_COMMENT || i == DOC_INLINE_TAG) {
            return 106;
        }
        if (i == DOC_COMMENT_LEADING_ASTERISKS) {
            return 107;
        }
        if (i == DOC_COMMENT_START) {
            return 110;
        }
        if (i == DOC_COMMENT_END) {
            return 111;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocComment((PsiDocComment)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiDocComment";
    }
}

