/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.source.codeStyle.Helper;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;

public class JavaHelper
extends Helper {
    public JavaHelper(FileType fileType, Project project) {
        super(fileType, project);
    }

    @Override
    protected int getIndentInner(ASTNode element, boolean includeNonSpace, int recursionLevel) {
        if (recursionLevel > 450) {
            return 0;
        }
        if (element.getTreePrev() != null) {
            ASTNode parent;
            ASTNode prev = element.getTreePrev();
            while (prev instanceof CompositeElement && !TreeUtil.isStrongWhitespaceHolder(prev.getElementType())) {
                ASTNode lastCompositePrev = prev;
                if ((prev = prev.getLastChildNode()) != null) continue;
                return this.getIndentInner(lastCompositePrev, includeNonSpace, recursionLevel + 1);
            }
            String text = prev.getText();
            int index = Math.max(text.lastIndexOf(10), text.lastIndexOf(13));
            if (index >= 0) {
                return this.getIndent(text.substring(index + 1), includeNonSpace);
            }
            if (includeNonSpace) {
                return this.getIndentInner(prev, includeNonSpace, recursionLevel + 1) + this.getIndent(text, includeNonSpace);
            }
            if (element.getElementType() == ElementType.CODE_BLOCK) {
                parent = element.getTreeParent();
                if (parent.getElementType() == ElementType.BLOCK_STATEMENT) {
                    parent = parent.getTreeParent();
                }
                if (parent.getElementType() != ElementType.CODE_BLOCK) {
                    return this.getIndentInner(parent, includeNonSpace, recursionLevel + 1);
                }
            } else if (element.getElementType() == ElementType.LBRACE) {
                return this.getIndentInner(element.getTreeParent(), includeNonSpace, recursionLevel + 1);
            }
            ASTNode child = prev;
            for (parent = prev.getTreeParent(); parent != null && child.getTreePrev() == null; parent = parent.getTreeParent()) {
                child = parent;
            }
            if (parent == null) {
                return this.getIndent(text, includeNonSpace);
            }
            if (prev.getTreeParent().getElementType() == ElementType.LABELED_STATEMENT) {
                return this.getIndentInner(prev, true, recursionLevel + 1) + this.getIndent(text, true);
            }
            return this.getIndentInner(prev, includeNonSpace, recursionLevel + 1);
        }
        if (element.getTreeParent() == null) {
            return 0;
        }
        return this.getIndentInner(element.getTreeParent(), includeNonSpace, recursionLevel + 1);
    }
}

