/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.codeStyle.ReferenceAdjuster;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCodeStyleManagerImpl
extends JavaCodeStyleManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl");
    @NonNls
    private static final String IMPL_TYPNAME_SUFFIX = "Impl";
    @NonNls
    private static final String GET_PREFIX = "get";
    @NonNls
    private static final String IS_PREFIX = "is";
    @NonNls
    private static final String FIND_PREFIX = "find";
    @NonNls
    private static final String CREATE_PREFIX = "create";
    private final Project myProject;

    public JavaCodeStyleManagerImpl(Project project) {
        this.myProject = project;
    }

    public PsiElement shortenClassReferences(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.shortenClassReferences must not be null");
        }
        return this.shortenClassReferences(element, 0);
    }

    public PsiElement shortenClassReferences(@NotNull PsiElement element, int flags) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.shortenClassReferences must not be null");
        }
        CheckUtil.checkWritable(element);
        if (!SourceTreeToPsiMap.hasTreeElement(element)) {
            return element;
        }
        return SourceTreeToPsiMap.treeElementToPsi(new ReferenceAdjuster(this.myProject).process((TreeElement)element.getNode(), (flags & 0x1000) == 0, (flags & 0x2000) != 0));
    }

    public void shortenClassReferences(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.shortenClassReferences must not be null");
        }
        CheckUtil.checkWritable(element);
        if (SourceTreeToPsiMap.hasTreeElement(element)) {
            new ReferenceAdjuster(this.myProject).processRange((TreeElement)element.getNode(), startOffset, endOffset);
        }
    }

    public PsiElement qualifyClassReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.qualifyClassReferences must not be null");
        }
        return SourceTreeToPsiMap.treeElementToPsi(new ReferenceAdjuster(true, true).process((TreeElement)element.getNode(), false, false));
    }

    public void optimizeImports(@NotNull PsiFile file) throws IncorrectOperationException {
        PsiImportList importList;
        PsiImportList newList;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.optimizeImports must not be null");
        }
        CheckUtil.checkWritable((PsiElement)file);
        if (file instanceof PsiJavaFile && (newList = this.prepareOptimizeImportsResult((PsiJavaFile)file)) != null && (importList = ((PsiJavaFile)file).getImportList()) != null) {
            importList.replace((PsiElement)newList);
        }
    }

    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.prepareOptimizeImportsResult must not be null");
        }
        return new ImportHelper(this.getSettings()).prepareOptimizeImportsResult(file);
    }

    public boolean addImport(@NotNull PsiJavaFile file, @NotNull PsiClass refClass) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.addImport must not be null");
        }
        if (refClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.addImport must not be null");
        }
        return new ImportHelper(this.getSettings()).addImport(file, refClass);
    }

    public void removeRedundantImports(final @NotNull PsiJavaFile file) throws IncorrectOperationException {
        THashSet redundants;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.removeRedundantImports must not be null");
        }
        PsiImportList importList = file.getImportList();
        if (importList == null) {
            return;
        }
        PsiImportStatementBase[] imports = importList.getAllImportStatements();
        if (imports.length == 0) {
            return;
        }
        THashSet allImports = new THashSet(Arrays.asList(imports));
        if (JspPsiUtil.isInJspFile((PsiElement)file)) {
            redundants = new THashSet(TObjectHashingStrategy.IDENTITY);
            redundants.addAll(Arrays.asList(imports));
            redundants.removeAll((Collection<?>)allImports);
            for (PsiImportStatementBase importStatement : imports) {
                if (!(importStatement instanceof JspxImportStatement) || !((JspxImportStatement)importStatement).isForeignFileImport()) continue;
                redundants.remove(importStatement);
            }
        } else {
            PsiFile[] roots;
            redundants = allImports;
            for (PsiFile root : roots = file.getPsiRoots()) {
                root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Collection)redundants){
                    final /* synthetic */ Collection val$redundants;
                    {
                        this.val$redundants = collection;
                    }

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        PsiElement resolveScope;
                        JavaResolveResult resolveResult;
                        if (!reference.isQualified() && !this.inTheSamePackage(file, (resolveResult = reference.advancedResolve(false)).getElement()) && (resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
                            PsiImportStatementBase importStatementBase = (PsiImportStatementBase)resolveScope;
                            this.val$redundants.remove(importStatementBase);
                        }
                        super.visitReferenceElement(reference);
                    }

                    private boolean inTheSamePackage(PsiJavaFile file2, PsiElement element) {
                        PsiFile containingFile;
                        if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null && (containingFile = element.getContainingFile()) instanceof PsiJavaFile) {
                            return Comparing.strEqual((String)file2.getPackageName(), (String)((PsiJavaFile)containingFile).getPackageName());
                        }
                        return false;
                    }
                });
            }
        }
        for (PsiImportStatementBase importStatement : redundants) {
            PsiJavaCodeReferenceElement ref = importStatement.getImportReference();
            if (ref == null || ref.resolve() == null) continue;
            importStatement.delete();
        }
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.findEntryIndex must not be null");
        }
        return new ImportHelper(this.getSettings()).findEntryIndex(statement);
    }

    public VariableKind getVariableKind(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.getVariableKind must not be null");
        }
        if (variable instanceof PsiField) {
            if (variable.hasModifierProperty("static")) {
                if (variable.hasModifierProperty("final")) {
                    return VariableKind.STATIC_FINAL_FIELD;
                }
                return VariableKind.STATIC_FIELD;
            }
            return VariableKind.FIELD;
        }
        if (variable instanceof PsiParameter) {
            if (((PsiParameter)variable).getDeclarationScope() instanceof PsiForeachStatement) {
                return VariableKind.LOCAL_VARIABLE;
            }
            return VariableKind.PARAMETER;
        }
        if (variable instanceof PsiLocalVariable) {
            return VariableKind.LOCAL_VARIABLE;
        }
        return VariableKind.LOCAL_VARIABLE;
    }

    public SuggestedNameInfo suggestVariableName(final @NotNull VariableKind kind, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type) {
        NamesByExprInfo namesByExpr;
        if (kind == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.suggestVariableName must not be null");
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (expr != null && type == null) {
            type = expr.getType();
        }
        if (propertyName != null) {
            String[] namesByName = this.getSuggestionsByName(propertyName, kind, false);
            this.sortVariableNameSuggestions(namesByName, kind, propertyName, null);
            names.addAll(Arrays.asList(namesByName));
        }
        if (expr != null) {
            namesByExpr = this.suggestVariableNameByExpression(expr, kind);
            if (namesByExpr.propertyName != null) {
                this.sortVariableNameSuggestions(namesByExpr.names, kind, namesByExpr.propertyName, null);
            }
            names.addAll(Arrays.asList(namesByExpr.names));
        } else {
            namesByExpr = null;
        }
        if (type != null) {
            String[] namesByType = this.suggestVariableNameByType(type, kind);
            this.sortVariableNameSuggestions(namesByType, kind, null, type);
            names.addAll(Arrays.asList(namesByType));
        }
        final String _propertyName = propertyName != null ? propertyName : (namesByExpr != null ? namesByExpr.propertyName : null);
        JavaCodeStyleManagerImpl.addNamesFromStatistics(names, kind, _propertyName, type);
        String[] namesArray = ArrayUtil.toStringArray(names);
        this.sortVariableNameSuggestions(namesArray, kind, _propertyName, type);
        final PsiType _type = type;
        return new SuggestedNameInfo(namesArray){

            public void nameChoosen(String name) {
                if (_propertyName != null || _type != null && _type.isValid()) {
                    JavaStatisticsManager.incVariableNameUseCount((String)name, (VariableKind)kind, (String)_propertyName, (PsiType)_type);
                }
            }
        };
    }

    private static void addNamesFromStatistics(Set<String> names, VariableKind variableKind, String propertyName, PsiType type) {
        String[] allNames = JavaStatisticsManager.getAllVariableNamesUsed((VariableKind)variableKind, (String)propertyName, (PsiType)type);
        int maxFrequency = 0;
        for (String name : allNames) {
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
            maxFrequency = Math.max(maxFrequency, count);
        }
        int frequencyLimit = Math.max(5, maxFrequency / 2);
        for (String name : allNames) {
            if (names.contains(name)) continue;
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
            if (LOG.isDebugEnabled()) {
                LOG.debug("new name:" + name + " count:" + count);
                LOG.debug("frequencyLimit:" + frequencyLimit);
            }
            if (count < frequencyLimit) continue;
            names.add(name);
        }
        if (propertyName != null && type != null) {
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, propertyName, null);
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, null, type);
        }
    }

    private String[] suggestVariableNameByType(PsiType type, VariableKind variableKind) {
        String longTypeName = JavaCodeStyleManagerImpl.getLongTypeName(type);
        CodeStyleSettings.TypeToNameMap map = this.getMapByVariableKind(variableKind);
        if (map != null && longTypeName != null) {
            String name;
            if (type.equals(PsiType.NULL)) {
                longTypeName = "java.lang.Object";
            }
            if ((name = map.nameByType(longTypeName)) != null && JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(name, LanguageLevel.HIGHEST)) {
                return new String[]{name};
            }
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        this.suggestNamesForCollectionInheritors(type, variableKind, suggestions);
        this.suggestNamesFromGenericParameters(type, variableKind, suggestions);
        String typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(type));
        if (typeName != null) {
            suggestions.addAll(Arrays.asList(this.getSuggestionsByName(typeName, variableKind, type instanceof PsiArrayType)));
        }
        return ArrayUtil.toStringArray(suggestions);
    }

    private void suggestNamesFromGenericParameters(PsiType type, VariableKind variableKind, Collection<String> suggestions) {
        PsiType[] parameters;
        if (!(type instanceof PsiClassType)) {
            return;
        }
        StringBuilder fullNameBuilder = new StringBuilder();
        for (PsiType parameter : parameters = ((PsiClassType)type).getParameters()) {
            String typeName;
            if (!(parameter instanceof PsiClassType) || (typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(parameter))) == null) continue;
            fullNameBuilder.append(typeName);
        }
        String baseName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(type));
        if (baseName != null) {
            fullNameBuilder.append(baseName);
            suggestions.addAll(Arrays.asList(this.getSuggestionsByName(fullNameBuilder.toString(), variableKind, false)));
        }
    }

    private void suggestNamesForCollectionInheritors(PsiType type, VariableKind variableKind, Collection<String> suggestions) {
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClassType.ClassResolveResult resolved = classType.resolveGenerics();
        PsiClass element = resolved.getElement();
        if (element == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiClass collectionClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Collection", element.getResolveScope());
        if (collectionClass == null) {
            return;
        }
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)element, (PsiClass)collectionClass, (boolean)true)) {
            PsiClass componentClass;
            PsiSubstitutor substitutor = !manager.areElementsEquivalent((PsiElement)element, (PsiElement)collectionClass) ? TypeConversionUtil.getClassSubstitutor((PsiClass)collectionClass, (PsiClass)element, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            PsiTypeParameterList typeParameterList = collectionClass.getTypeParameterList();
            if (typeParameterList == null) {
                return;
            }
            PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
            if (typeParameters.length == 0) {
                return;
            }
            PsiType componentTypeParameter = substitutor.substitute(typeParameters[0]);
            if (componentTypeParameter instanceof PsiClassType && (componentClass = ((PsiClassType)componentTypeParameter).resolve()) instanceof PsiTypeParameter && collectionClass.getManager().areElementsEquivalent((PsiElement)((PsiTypeParameter)componentClass).getOwner(), (PsiElement)element)) {
                PsiType componentType = resolved.getSubstitutor().substitute((PsiTypeParameter)componentClass);
                if (componentType == null) {
                    return;
                }
                String typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(componentType));
                if (typeName != null) {
                    suggestions.addAll(Arrays.asList(this.getSuggestionsByName(typeName, variableKind, true)));
                }
            }
        }
    }

    @Nullable
    private static String normalizeTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.endsWith(IMPL_TYPNAME_SUFFIX) && typeName.length() > IMPL_TYPNAME_SUFFIX.length()) {
            return typeName.substring(0, typeName.length() - IMPL_TYPNAME_SUFFIX.length());
        }
        return typeName;
    }

    @Nullable
    private static String getTypeName(PsiType type) {
        if ((type = type.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            String className = classType.getClassName();
            if (className != null) {
                return className;
            }
            PsiClass aClass = classType.resolve();
            if (aClass instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)aClass).getBaseClassType().getClassName();
            }
            return null;
        }
        if (type instanceof PsiPrimitiveType) {
            return type.getPresentableText();
        }
        if (type instanceof PsiWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiWildcardType)type).getExtendsBound());
        }
        if (type instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiIntersectionType)type).getRepresentative());
        }
        if (type instanceof PsiCapturedWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName((PsiType)((PsiCapturedWildcardType)type).getWildcard());
        }
        LOG.error("Unknown type:" + type);
        return null;
    }

    @Nullable
    private static String getLongTypeName(PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClass aClass = ((PsiClassType)type).resolve();
            if (aClass == null) {
                return null;
            }
            if (aClass instanceof PsiAnonymousClass) {
                PsiClass baseClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve();
                if (baseClass == null) {
                    return null;
                }
                return baseClass.getQualifiedName();
            }
            return aClass.getQualifiedName();
        }
        if (type instanceof PsiArrayType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiArrayType)type).getComponentType()) + "[]";
        }
        if (type instanceof PsiPrimitiveType) {
            return type.getPresentableText();
        }
        if (type instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type).getBound();
            if (bound != null) {
                return JavaCodeStyleManagerImpl.getLongTypeName(bound);
            }
            return "java.lang.Object";
        }
        if (type instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type).getWildcard().getBound();
            if (bound != null) {
                return JavaCodeStyleManagerImpl.getLongTypeName(bound);
            }
            return "java.lang.Object";
        }
        if (type instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiIntersectionType)type).getRepresentative());
        }
        LOG.error("Unknown type:" + type);
        return null;
    }

    private NamesByExprInfo suggestVariableNameByExpression(PsiExpression expr, VariableKind variableKind) {
        NamesByExprInfo names1 = this.suggestVariableNameByExpressionOnly(expr, variableKind);
        NamesByExprInfo names2 = this.suggestVariableNameByExpressionPlace(expr, variableKind);
        PsiType type = expr.getType();
        String[] names3 = type != null ? this.suggestVariableNameByType(type, variableKind) : null;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.addAll(Arrays.asList(names1.names));
        names.addAll(Arrays.asList(names2.names));
        if (names3 != null) {
            names.addAll(Arrays.asList(names3));
        }
        String[] namesArray = ArrayUtil.toStringArray(names);
        String propertyName = names1.propertyName != null ? names1.propertyName : names2.propertyName;
        return new NamesByExprInfo(propertyName, namesArray);
    }

    private NamesByExprInfo suggestVariableNameByExpressionOnly(PsiExpression expr, VariableKind variableKind) {
        String stringValue;
        String[] names;
        PsiLiteralExpression literalExpression;
        Object value;
        if (expr instanceof PsiMethodCallExpression) {
            String firstWord;
            String[] words;
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)expr).getMethodExpression();
            String methodName = methodExpr.getReferenceName();
            if (methodName != null && (words = NameUtil.nameToWords((String)methodName)).length > 1 && (GET_PREFIX.equals(firstWord = words[0]) || IS_PREFIX.equals(firstWord) || FIND_PREFIX.equals(firstWord) || CREATE_PREFIX.equals(firstWord))) {
                String propertyName = methodName.substring(firstWord.length());
                String[] names2 = this.getSuggestionsByName(propertyName, variableKind, false);
                return new NamesByExprInfo(propertyName, names2);
            }
        } else if (expr instanceof PsiReferenceExpression) {
            String propertyName = ((PsiReferenceExpression)expr).getReferenceName();
            PsiElement refElement = ((PsiReferenceExpression)expr).resolve();
            if (refElement instanceof PsiVariable) {
                VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
                propertyName = this.variableNameToPropertyName(propertyName, refVariableKind);
            }
            if (refElement != null && propertyName != null) {
                String[] names3 = this.getSuggestionsByName(propertyName, variableKind, false);
                return new NamesByExprInfo(propertyName, names3);
            }
        } else if (expr instanceof PsiArrayAccessExpression) {
            PsiExpression arrayExpr = ((PsiArrayAccessExpression)expr).getArrayExpression();
            if (arrayExpr instanceof PsiReferenceExpression) {
                String name;
                String arrayName = ((PsiReferenceExpression)arrayExpr).getReferenceName();
                PsiElement refElement = ((PsiReferenceExpression)arrayExpr).resolve();
                if (refElement instanceof PsiVariable) {
                    VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
                    arrayName = this.variableNameToPropertyName(arrayName, refVariableKind);
                }
                if (arrayName != null && (name = StringUtil.unpluralize((String)arrayName)) != null) {
                    String[] names4 = this.getSuggestionsByName(name, variableKind, false);
                    return new NamesByExprInfo(name, names4);
                }
            }
        } else if (expr instanceof PsiLiteralExpression && variableKind == VariableKind.STATIC_FINAL_FIELD && (value = (literalExpression = (PsiLiteralExpression)expr).getValue()) instanceof String && (names = JavaCodeStyleManagerImpl.getSuggestionsByValue(stringValue = (String)value)).length > 0) {
            return new NamesByExprInfo(null, JavaCodeStyleManagerImpl.constantValueToConstantName(names));
        }
        return new NamesByExprInfo(null, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private static String constantValueToConstantName(String[] names) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                result.append("_");
            }
            result.append(names[i]);
        }
        return result.toString();
    }

    private static String[] getSuggestionsByValue(String stringValue) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        boolean prevIsUpperCase = false;
        for (int i = 0; i < stringValue.length(); ++i) {
            char c = stringValue.charAt(i);
            if (Character.isUpperCase(c)) {
                if (currentWord.length() > 0 && !prevIsUpperCase) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                currentWord.append(c);
            } else if (Character.isLowerCase(c)) {
                currentWord.append(Character.toUpperCase(c));
            } else if (Character.isJavaIdentifierPart(c) && c != '_') {
                if (Character.isJavaIdentifierStart(c) || currentWord.length() > 0 || !result.isEmpty()) {
                    currentWord.append(c);
                }
            } else if (currentWord.length() > 0) {
                result.add(currentWord.toString());
                currentWord = new StringBuffer();
            }
            prevIsUpperCase = Character.isUpperCase(c);
        }
        if (currentWord.length() > 0) {
            result.add(currentWord.toString());
        }
        return ArrayUtil.toStringArray(result);
    }

    private NamesByExprInfo suggestVariableNameByExpressionPlace(PsiExpression expr, VariableKind variableKind) {
        String name;
        PsiExpression leftExpression;
        PsiAssignmentExpression assignmentExpression;
        if (expr.getParent() instanceof PsiExpressionList) {
            PsiExpressionList list = (PsiExpressionList)expr.getParent();
            PsiElement listParent = list.getParent();
            PsiMethod method = null;
            if (listParent instanceof PsiMethodCallExpression) {
                method = (PsiMethod)((PsiMethodCallExpression)listParent).getMethodExpression().resolve();
            } else {
                if (listParent instanceof PsiAnonymousClass) {
                    listParent = listParent.getParent();
                }
                if (listParent instanceof PsiNewExpression) {
                    method = ((PsiNewExpression)listParent).resolveConstructor();
                }
            }
            if (method != null) {
                String name2;
                PsiIdentifier identifier;
                PsiParameter[] parms;
                PsiElement navElement = method.getNavigationElement();
                if (navElement instanceof PsiMethod) {
                    method = (PsiMethod)navElement;
                }
                PsiExpression[] expressions = list.getExpressions();
                int index = -1;
                for (int i = 0; i < expressions.length; ++i) {
                    if (expressions[i] != expr) continue;
                    index = i;
                    break;
                }
                if (index < (parms = method.getParameterList().getParameters()).length && (identifier = parms[index].getNameIdentifier()) != null && (name2 = identifier.getText()) != null) {
                    name2 = this.variableNameToPropertyName(name2, VariableKind.PARAMETER);
                    String[] names = this.getSuggestionsByName(name2, variableKind, false);
                    return new NamesByExprInfo(name2, names);
                }
            }
        } else if (expr.getParent() instanceof PsiAssignmentExpression && variableKind == VariableKind.PARAMETER && expr == (assignmentExpression = (PsiAssignmentExpression)expr.getParent()).getRExpression() && (leftExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)leftExpression).getQualifier() == null && (name = leftExpression.getText()) != null) {
            String[] names = this.getSuggestionsByName(name, variableKind, false);
            return new NamesByExprInfo(name, names);
        }
        return new NamesByExprInfo(null, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public String variableNameToPropertyName(String name, VariableKind variableKind) {
        if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c != '_') {
                    if (Character.isLowerCase(c)) {
                        return this.variableNameToPropertyNameInner(name, variableKind);
                    }
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (++i >= name.length()) continue;
                c = name.charAt(i);
                buffer.append(c);
            }
            return buffer.toString();
        }
        return this.variableNameToPropertyNameInner(name, variableKind);
    }

    private String variableNameToPropertyNameInner(String name, VariableKind variableKind) {
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        boolean doDecapitalize = false;
        if (name.startsWith(prefix) && name.length() > prefix.length()) {
            name = name.substring(prefix.length());
            doDecapitalize = true;
        }
        if (name.endsWith(suffix) && name.length() > suffix.length()) {
            name = name.substring(0, name.length() - suffix.length());
            doDecapitalize = true;
        }
        if (name.startsWith(IS_PREFIX) && name.length() > IS_PREFIX.length() && Character.isUpperCase(name.charAt(IS_PREFIX.length()))) {
            name = name.substring(IS_PREFIX.length());
            doDecapitalize = true;
        }
        if (doDecapitalize) {
            name = Introspector.decapitalize(name);
        }
        return name;
    }

    public String propertyNameToVariableName(String propertyName, VariableKind variableKind) {
        if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
            String[] words = NameUtil.nameToWords((String)propertyName);
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                String word = words[i];
                if (i > 0) {
                    buffer.append("_");
                }
                buffer.append(word.toUpperCase());
            }
            return buffer.toString();
        }
        String prefix = this.getPrefixByVariableKind(variableKind);
        String name = propertyName;
        if (name.length() > 0 && prefix.length() > 0 && !StringUtil.endsWithChar((CharSequence)prefix, (char)'_')) {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        name = prefix + name + this.getSuffixByVariableKind(variableKind);
        name = this.changeIfNotIdentifier(name);
        return name;
    }

    private String[] getSuggestionsByName(String name, VariableKind variableKind, boolean isArray) {
        String prefix = this.getPrefixByVariableKind(variableKind);
        ArrayList<String> list = new ArrayList<String>();
        String[] words = NameUtil.nameToWords((String)name);
        for (int step = 0; step < words.length; ++step) {
            int wordCount = this.getSettings().PREFER_LONGER_NAMES ? words.length - step : step + 1;
            String startWord = words[words.length - wordCount];
            char c = startWord.charAt(0);
            if (c == '_' || !Character.isJavaIdentifierStart(c)) continue;
            StringBuilder buffer = new StringBuilder();
            buffer.append(prefix);
            startWord = variableKind == VariableKind.STATIC_FINAL_FIELD ? startWord.toUpperCase() : (prefix.length() == 0 || StringUtil.endsWithChar((CharSequence)prefix, (char)'_') ? startWord.toLowerCase() : Character.toUpperCase(c) + startWord.substring(1));
            buffer.append(startWord);
            for (int i = words.length - wordCount + 1; i < words.length; ++i) {
                String word = words[i];
                String prevWord = words[i - 1];
                if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
                    word = word.toUpperCase();
                    if (prevWord.charAt(prevWord.length() - 1) != '_') {
                        word = "_" + word;
                    }
                } else if (prevWord.charAt(prevWord.length() - 1) == '_') {
                    word = word.toLowerCase();
                }
                buffer.append(word);
            }
            String suggestion = buffer.toString();
            if (isArray) {
                suggestion = StringUtil.pluralize((String)suggestion);
                if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
                    suggestion = suggestion.toUpperCase();
                }
            }
            suggestion = this.changeIfNotIdentifier(suggestion + this.getSuffixByVariableKind(variableKind));
            if (!JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(suggestion, LanguageLevel.HIGHEST)) continue;
            list.add(suggestion);
        }
        return ArrayUtil.toStringArray(list);
    }

    public String suggestUniqueVariableName(String baseName, PsiElement place, boolean lookForward) {
        String name;
        int index = 0;
        PsiElement scope = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class});
        block2: while (true) {
            name = baseName;
            if (index > 0) {
                name = name + index;
            }
            ++index;
            if (!PsiUtil.isVariableNameUnique((String)name, (PsiElement)place)) continue;
            if (!lookForward) break;
            final String name1 = name;
            for (PsiElement run = scope; run != null; run = run.getNextSibling()) {
                class CancelException
                extends RuntimeException {
                    CancelException() {
                    }
                }
                try {
                    run.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitAnonymousClass(PsiAnonymousClass aClass) {
                        }

                        public void visitVariable(PsiVariable variable) {
                            if (name1.equals(variable.getName())) {
                                throw new CancelException();
                            }
                        }
                    });
                    continue;
                }
                catch (CancelException e) {
                    continue block2;
                }
            }
            break;
        }
        return name;
    }

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(final @NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean lookForward) {
        if (baseNameInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.suggestUniqueVariableName must not be null");
        }
        String[] names = baseNameInfo.names;
        HashSet uniqueNames = new HashSet(names.length);
        for (String name : names) {
            uniqueNames.add(this.suggestUniqueVariableName(name, place, lookForward));
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(ArrayUtil.toStringArray((Collection)uniqueNames)){

            public void nameChoosen(String name) {
                baseNameInfo.nameChoosen(name);
            }
        };
        if (suggestedNameInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.suggestUniqueVariableName must not return null");
        }
        return suggestedNameInfo;
    }

    private void sortVariableNameSuggestions(String[] names, final VariableKind variableKind, final String propertyName, final PsiType type) {
        if (names.length <= 1) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorting names:" + variableKind);
            if (propertyName != null) {
                LOG.debug("propertyName:" + propertyName);
            }
            if (type != null) {
                LOG.debug("type:" + type);
            }
            for (String name : names) {
                int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
                LOG.debug(name + " : " + count);
            }
        }
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int count1 = JavaStatisticsManager.getVariableNameUseCount((String)s1, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
                int count2 = JavaStatisticsManager.getVariableNameUseCount((String)s2, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
                return count2 - count1;
            }
        };
        Arrays.sort(names, comparator);
    }

    @NotNull
    public String getPrefixByVariableKind(VariableKind variableKind) {
        String prefix = "";
        switch (variableKind) {
            case FIELD: {
                prefix = this.getSettings().FIELD_NAME_PREFIX;
                break;
            }
            case STATIC_FIELD: {
                prefix = this.getSettings().STATIC_FIELD_NAME_PREFIX;
                break;
            }
            case PARAMETER: {
                prefix = this.getSettings().PARAMETER_NAME_PREFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                prefix = this.getSettings().LOCAL_VARIABLE_NAME_PREFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                prefix = "";
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        String string = prefix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.getPrefixByVariableKind must not return null");
        }
        return string;
    }

    @NotNull
    public String getSuffixByVariableKind(VariableKind variableKind) {
        String suffix = "";
        switch (variableKind) {
            case FIELD: {
                suffix = this.getSettings().FIELD_NAME_SUFFIX;
                break;
            }
            case STATIC_FIELD: {
                suffix = this.getSettings().STATIC_FIELD_NAME_SUFFIX;
                break;
            }
            case PARAMETER: {
                suffix = this.getSettings().PARAMETER_NAME_SUFFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                suffix = this.getSettings().LOCAL_VARIABLE_NAME_SUFFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                suffix = "";
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        if (suffix == null) {
            suffix = "";
        }
        String string = suffix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl.getSuffixByVariableKind must not return null");
        }
        return string;
    }

    private CodeStyleSettings.TypeToNameMap getMapByVariableKind(VariableKind variableKind) {
        if (variableKind == VariableKind.FIELD) {
            return this.getSettings().FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.STATIC_FIELD) {
            return this.getSettings().STATIC_FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.PARAMETER) {
            return this.getSettings().PARAMETER_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.LOCAL_VARIABLE) {
            return this.getSettings().LOCAL_VARIABLE_TYPE_TO_NAME;
        }
        return null;
    }

    @NonNls
    private String changeIfNotIdentifier(String name) {
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        if (!JavaPsiFacade.getInstance((Project)manager.getProject()).getNameHelper().isIdentifier(name, LanguageLevel.HIGHEST)) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
        }
        return name;
    }

    private CodeStyleSettings getSettings() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject);
    }

    private static class NamesByExprInfo {
        final String[] names;
        final String propertyName;

        public NamesByExprInfo(String propertyName, String ... names) {
            this.names = names;
            this.propertyName = propertyName;
        }
    }
}

