/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PatchedSoftReference;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiTypeElementImpl");
    private volatile PsiType myCachedType = null;
    private volatile PatchedSoftReference<PsiType> myCachedDetachedType = null;
    private static final Function<PsiAnnotation, String> ANNOTATION_TEXT = new Function<PsiAnnotation, String>(){

        public String fun(PsiAnnotation psiAnnotation) {
            return psiAnnotation.getText();
        }
    };

    public PsiTypeElementImpl() {
        super(JavaElementType.TYPE);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedType = null;
        this.myCachedDetachedType = null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiType getType() {
        void var1_8;
        void var1_2;
        PsiType psiType;
        PsiType psiType2 = this.myCachedType;
        if (psiType2 != null) {
            psiType = psiType2;
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getType must not return null");
            return psiType;
        }
        TreeElement element = this.getFirstChildNode();
        ArrayList<PsiAnnotation> typeAnnos = new ArrayList<PsiAnnotation>();
        while (element != null) {
            PsiAnnotation[] array;
            IElementType elementType = element.getElementType();
            if (element.getTreeNext() == null && ElementType.PRIMITIVE_TYPE_BIT_SET.contains(elementType)) {
                PsiTypeElementImpl.addTypeUseAnnotationsFromModifierList(this.getParent(), typeAnnos);
                array = PsiTypeElementImpl.toAnnotationsArray(typeAnnos);
                PsiType psiType3 = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createPrimitiveType(element.getText(), array);
                assert (psiType3 != null);
            } else if (elementType == JavaElementType.TYPE) {
                PsiType componentType = ((PsiTypeElement)SourceTreeToPsiMap.treeElementToPsi(element)).getType();
                PsiEllipsisType psiEllipsisType = this.getLastChildNode().getElementType() == JavaTokenType.ELLIPSIS ? new PsiEllipsisType(componentType) : componentType.createArrayType();
            } else if (elementType == JavaElementType.JAVA_CODE_REFERENCE) {
                PsiTypeElementImpl.addTypeUseAnnotationsFromModifierList(this.getParent(), typeAnnos);
                array = PsiTypeElementImpl.toAnnotationsArray(typeAnnos);
                PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType((PsiJavaCodeReferenceElement)element.getPsi(), null, array);
            } else if (elementType == JavaTokenType.QUEST) {
                PsiType psiType4 = this.createWildcardType();
            } else {
                if (JavaTokenType.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(elementType)) {
                    element = element.getTreeNext();
                    continue;
                }
                if (elementType == JavaElementType.ANNOTATION) {
                    PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createAnnotationFromText(element.getText(), (PsiElement)this);
                    typeAnnos.add(annotation);
                    element = element.getTreeNext();
                    continue;
                }
                LOG.error("Unknown element type: " + elementType);
            }
            if (element.getTextLength() != 0) break;
            element = element.getTreeNext();
        }
        if (var1_2 == null) {
            PsiType psiType5 = PsiType.NULL;
        }
        this.myCachedType = var1_8;
        psiType = var1_8;
        if (psiType != null) return psiType;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getType must not return null");
    }

    private static PsiAnnotation[] toAnnotationsArray(List<PsiAnnotation> typeAnnos) {
        int size = typeAnnos.size();
        return size == 0 ? PsiAnnotation.EMPTY_ARRAY : typeAnnos.toArray(new PsiAnnotation[size]);
    }

    public static void addTypeUseAnnotationsFromModifierList(PsiElement member, List<PsiAnnotation> typeAnnos) {
        PsiAnnotation[] gluedAnnos;
        if (!(member instanceof PsiModifierListOwner)) {
            return;
        }
        PsiModifierList list = ((PsiModifierListOwner)member).getModifierList();
        for (PsiAnnotation anno : gluedAnnos = list == null ? PsiAnnotation.EMPTY_ARRAY : list.getAnnotations()) {
            if (!AnnotationsHighlightUtil.isAnnotationApplicableTo(anno, true, "TYPE_USE")) continue;
            typeAnnos.add(anno);
        }
    }

    public PsiType getDetachedType(@NotNull PsiElement context) {
        PsiType type;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.getDetachedType must not be null");
        }
        PatchedSoftReference<PsiType> cached = this.myCachedDetachedType;
        PsiType psiType = type = cached == null ? null : (PsiType)cached.get();
        if (type != null) {
            return type;
        }
        try {
            String combinedAnnos = this.getCombinedAnnosText();
            String text = combinedAnnos.length() == 0 ? this.getText().trim() : combinedAnnos + " " + this.getText().trim();
            type = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeFromText(text, context);
            this.myCachedDetachedType = new PatchedSoftReference<PsiType>(type);
        }
        catch (IncorrectOperationException e) {
            return this.getType();
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private String getCombinedAnnosText() {
        boolean typeAnnotationsSupported = PsiUtil.getLanguageLevel((PsiElement)this).isAtLeast(LanguageLevel.JDK_1_7);
        if (!typeAnnotationsSupported) {
            return "";
        }
        String string = StringUtil.join((Object[])this.getApplicableAnnotations(), ANNOTATION_TEXT, (String)" ");
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getCombinedAnnosText must not return null");
        return string2;
    }

    public PsiType getTypeNoResolve(@NotNull PsiElement context) {
        String combinedAnnos;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.getTypeNoResolve must not be null");
        }
        PsiFile file = this.getContainingFile();
        String text = PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_7) ? ((combinedAnnos = StringUtil.join((Object[])this.getAnnotations(), ANNOTATION_TEXT, (String)" ")).length() == 0 ? this.getText().trim() : combinedAnnos + " " + this.getText().trim()) : this.getText().trim();
        try {
            return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeFromText(text, context);
        }
        catch (IncorrectOperationException e) {
            String s = "Parent: " + DebugUtil.psiToString(this.getParent(), false);
            s = s + "Context: " + DebugUtil.psiToString(context, false);
            LOG.error(s, (Throwable)e);
            return null;
        }
    }

    @NotNull
    private PsiType createWildcardType() {
        PsiWildcardType temp;
        if (this.getFirstChildNode().getTreeNext() == null) {
            temp = PsiWildcardType.createUnbounded((PsiManager)this.getManager());
        } else if (this.getLastChildNode().getElementType() == JavaElementType.TYPE) {
            TreeElement keyword;
            PsiTypeElement bound = (PsiTypeElement)SourceTreeToPsiMap.treeElementToPsi(this.getLastChildNode());
            for (keyword = this.getFirstChildNode(); keyword != null && keyword.getElementType() != JavaTokenType.EXTENDS_KEYWORD && keyword.getElementType() != JavaTokenType.SUPER_KEYWORD; keyword = keyword.getTreeNext()) {
            }
            if (keyword != null) {
                IElementType i = keyword.getElementType();
                if (i == JavaTokenType.EXTENDS_KEYWORD) {
                    temp = PsiWildcardType.createExtends((PsiManager)this.getManager(), (PsiType)bound.getType());
                } else if (i == JavaTokenType.SUPER_KEYWORD) {
                    temp = PsiWildcardType.createSuper((PsiManager)this.getManager(), (PsiType)bound.getType());
                } else {
                    LOG.assertTrue(false);
                    temp = PsiWildcardType.createUnbounded((PsiManager)this.getManager());
                }
            } else {
                temp = PsiWildcardType.createUnbounded((PsiManager)this.getManager());
            }
        } else {
            temp = PsiWildcardType.createUnbounded((PsiManager)this.getManager());
        }
        PsiWildcardType psiWildcardType = temp;
        if (psiWildcardType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.createWildcardType must not return null");
        }
        return psiWildcardType;
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeElementToPsi(firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    public PsiAnnotationOwner getOwner(PsiAnnotation annotation) {
        PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)annotation, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
        if (next != null && next.getNode().getElementType() == JavaTokenType.LBRACKET) {
            PsiType type = this.getType();
            return type;
        }
        return this;
    }

    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(ref);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        return true;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        SmartList result = null;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            ASTNode next;
            if (child.getElementType() != JavaElementType.ANNOTATION || (next = TreeUtil.skipElements(child.getTreeNext(), JavaTokenType.WHITE_SPACE_OR_COMMENT_BIT_SET)) != null && next.getElementType() == JavaTokenType.LBRACKET) continue;
            if (result == null) {
                result = new SmartList();
            }
            PsiElement element = child.getPsi();
            assert (element != null);
            result.add((PsiAnnotation)element);
        }
        PsiAnnotation[] psiAnnotationArray = result == null ? PsiAnnotation.EMPTY_ARRAY : PsiTypeElementImpl.toAnnotationsArray(result);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] annotations = this.getAnnotations();
        ArrayList<PsiAnnotation> list = new ArrayList<PsiAnnotation>(Arrays.asList(annotations));
        PsiTypeElementImpl.addTypeUseAnnotationsFromModifierList(this.getParent(), list);
        PsiAnnotation[] psiAnnotationArray = PsiTypeElementImpl.toAnnotationsArray(list);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.findAnnotation must not be null");
        }
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.addAnnotation must not be null");
        }
        throw new UnsupportedOperationException();
    }
}

