/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiModifierListImpl
extends JavaStubPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Map<String, IElementType> NAME_TO_KEYWORD_TYPE_MAP = new THashMap();
    public static final TObjectIntHashMap<String> NAME_TO_MODIFIER_FLAG_MAP;

    public PsiModifierListImpl(PsiModifierListStub stub) {
        super(stub, JavaStubElementTypes.MODIFIER_LIST);
    }

    public PsiModifierListImpl(ASTNode node) {
        super(node);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.hasModifierProperty must not be null");
        }
        PsiModifierListStub stub = (PsiModifierListStub)this.getStub();
        if (stub != null) {
            int flag = NAME_TO_MODIFIER_FLAG_MAP.get((Object)name);
            assert (flag != 0);
            return (stub.getModifiersMask() & flag) != 0;
        }
        IElementType type = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClass) {
            PsiElement pparent = parent.getParent();
            if (pparent instanceof PsiClass && ((PsiClass)pparent).isInterface()) {
                if (type == JavaTokenType.PUBLIC_KEYWORD) {
                    return true;
                }
                if (type == null) {
                    return false;
                }
                if (type == JavaTokenType.STATIC_KEYWORD) {
                    return true;
                }
            }
            if (((PsiClass)parent).isInterface()) {
                if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                    return true;
                }
                if (pparent instanceof PsiClass && type == JavaTokenType.STATIC_KEYWORD) {
                    return true;
                }
            }
            if (((PsiClass)parent).isEnum()) {
                if (type == JavaTokenType.STATIC_KEYWORD) {
                    if (!(pparent instanceof PsiFile)) {
                        return true;
                    }
                } else {
                    if (type == JavaTokenType.FINAL_KEYWORD) {
                        PsiField[] fields;
                        for (PsiField field : fields = ((PsiClass)parent).getFields()) {
                            if (!(field instanceof PsiEnumConstant) || ((PsiEnumConstant)field).getInitializingClass() == null) continue;
                            return false;
                        }
                        return true;
                    }
                    if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                        PsiMethod[] methods;
                        for (PsiMethod method : methods = ((PsiClass)parent).getMethods()) {
                            if (!method.hasModifierProperty("abstract")) continue;
                            return true;
                        }
                        return false;
                    }
                }
            }
        } else if (parent instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                if (type == JavaTokenType.PUBLIC_KEYWORD) {
                    return true;
                }
                if (type == null) {
                    return false;
                }
                if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                    return true;
                }
            }
        } else if (parent instanceof PsiField) {
            if (parent instanceof PsiEnumConstant) {
                return type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.STATIC_KEYWORD || type == JavaTokenType.FINAL_KEYWORD;
            }
            PsiClass aClass = ((PsiField)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                if (type == JavaTokenType.PUBLIC_KEYWORD) {
                    return true;
                }
                if (type == null) {
                    return false;
                }
                if (type == JavaTokenType.STATIC_KEYWORD) {
                    return true;
                }
                if (type == JavaTokenType.FINAL_KEYWORD) {
                    return true;
                }
            }
        }
        if (type == null) {
            return !this.hasModifierProperty("public") && !this.hasModifierProperty("private") && !this.hasModifierProperty("protected");
        }
        return this.getNode().findChildByType(type) != null;
    }

    public boolean hasExplicitModifier(@NotNull String name) {
        IElementType type;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.hasExplicitModifier must not be null");
        }
        CompositeElement tree = (CompositeElement)this.getNode();
        return tree.findChildByType(type = NAME_TO_KEYWORD_TYPE_MAP.get(name)) != null;
    }

    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.setModifierProperty must not be null");
        }
        this.checkSetModifierProperty(name, value);
        IElementType type = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        CompositeElement treeElement = (CompositeElement)this.getNode();
        CompositeElement parentTreeElement = treeElement.getTreeParent();
        if (value) {
            if (parentTreeElement.getElementType() == JavaElementType.FIELD && parentTreeElement.getTreeParent().getElementType() == JavaElementType.CLASS && ((PsiClass)SourceTreeToPsiMap.treeElementToPsi(parentTreeElement.getTreeParent())).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.STATIC_KEYWORD || type == JavaTokenType.FINAL_KEYWORD : (parentTreeElement.getElementType() == JavaElementType.METHOD && parentTreeElement.getTreeParent().getElementType() == JavaElementType.CLASS && ((PsiClass)SourceTreeToPsiMap.treeElementToPsi(parentTreeElement.getTreeParent())).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD : (parentTreeElement.getElementType() == JavaElementType.CLASS && parentTreeElement.getTreeParent().getElementType() == JavaElementType.CLASS && ((PsiClass)SourceTreeToPsiMap.treeElementToPsi(parentTreeElement.getTreeParent())).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD : parentTreeElement.getElementType() == JavaElementType.ANNOTATION_METHOD && parentTreeElement.getTreeParent().getElementType() == JavaElementType.CLASS && ((PsiClass)SourceTreeToPsiMap.treeElementToPsi(parentTreeElement.getTreeParent())).isAnnotationType() && (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD)))) {
                return;
            }
            if (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.PRIVATE_KEYWORD || type == JavaTokenType.PROTECTED_KEYWORD || type == null) {
                if (type != JavaTokenType.PUBLIC_KEYWORD) {
                    this.setModifierProperty("public", false);
                }
                if (type != JavaTokenType.PRIVATE_KEYWORD) {
                    this.setModifierProperty("private", false);
                }
                if (type != JavaTokenType.PROTECTED_KEYWORD) {
                    this.setModifierProperty("protected", false);
                }
                if (type == null) {
                    return;
                }
            }
            if (treeElement.findChildByType(type) == null) {
                LeafElement keyword = Factory.createSingleLeafElement(type, name, null, this.getManager());
                treeElement.addInternal(keyword, keyword, null, null);
            }
            if ((type == JavaTokenType.ABSTRACT_KEYWORD || type == JavaTokenType.NATIVE_KEYWORD) && parentTreeElement.getElementType() == JavaElementType.METHOD) {
                // empty if block
            }
        } else {
            if (type == null) {
                throw new IncorrectOperationException("Cannot reset package local modifier.");
            }
            ASTNode child = treeElement.findChildByType(type);
            if (child != null) {
                SourceTreeToPsiMap.treeElementToPsi(child).delete();
            }
        }
    }

    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.checkSetModifierProperty must not be null");
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])this.getStubOrPsiChildren(JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiModifierListImpl.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        final String[] fields = AnnotationsHighlightUtil.getApplicableElementTypeFields((PsiElement)this);
        List filtered = ContainerUtil.findAll((Object[])this.getAnnotations(), (Condition)new Condition<PsiAnnotation>(){

            public boolean value(PsiAnnotation annotation) {
                return AnnotationsHighlightUtil.isAnnotationApplicableTo(annotation, true, fields);
            }
        });
        PsiAnnotation[] psiAnnotationArray = filtered.toArray(new PsiAnnotation[filtered.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiModifierListImpl.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.findAnnotation must not be null");
        }
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.addAnnotation must not be null");
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addAfter((PsiElement)JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createAnnotationFromText("@" + qualifiedName, (PsiElement)this), null);
        if (psiAnnotation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiModifierListImpl.addAnnotation must not return null");
        }
        return psiAnnotation;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList((PsiModifierList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiModifierList:" + this.getText();
    }

    static {
        NAME_TO_KEYWORD_TYPE_MAP.put("public", JavaTokenType.PUBLIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("protected", JavaTokenType.PROTECTED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("private", JavaTokenType.PRIVATE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("static", JavaTokenType.STATIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("abstract", JavaTokenType.ABSTRACT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("final", JavaTokenType.FINAL_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("native", JavaTokenType.NATIVE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("strictfp", JavaTokenType.STRICTFP_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transient", JavaTokenType.TRANSIENT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("volatile", JavaTokenType.VOLATILE_KEYWORD);
        NAME_TO_MODIFIER_FLAG_MAP = new TObjectIntHashMap();
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"public", 1);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"protected", 4);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"private", 2);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"packageLocal", 4096);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"static", 8);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"abstract", 1024);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"final", 16);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"native", 256);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"synchronized", 32);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"strictfp", 2048);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"transient", 128);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"volatile", 64);
    }
}

