/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiCodeFragmentImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.annotations.NonNls;

public class PsiJavaCodeReferenceCodeFragmentImpl
extends PsiCodeFragmentImpl
implements PsiJavaCodeReferenceCodeFragment {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiJavaCodeReferenceCodeFragmentImpl");
    private final boolean myIsClassesAccepted;

    public PsiJavaCodeReferenceCodeFragmentImpl(Project project, boolean isPhysical, @NonNls String name, CharSequence text, boolean isClassesAccepted) {
        super(project, Constants.REFERENCE_TEXT, isPhysical, name, text);
        this.myIsClassesAccepted = isClassesAccepted;
    }

    public PsiJavaCodeReferenceElement getReferenceElement() {
        CompositeElement treeElement = this.calcTreeElement();
        LOG.assertTrue(treeElement.getFirstChildNode().getElementType() == ElementType.JAVA_CODE_REFERENCE);
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(treeElement.getFirstChildNode());
    }

    public boolean isClassesAccepted() {
        return this.myIsClassesAccepted;
    }
}

