/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.formatting.FormatTextRanges;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.PsiTreeDebugBuilder;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.Helper;
import com.intellij.psi.impl.source.codeStyle.HelperFactory;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementVisitor;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PostprocessReformattingAspect
implements PomModelAspect,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PostprocessReformatingAspect");
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final TreeAspect myTreeAspect;
    private final Map<FileViewProvider, List<ASTNode>> myReformatElements = new HashMap<FileViewProvider, List<ASTNode>>();
    private volatile int myDisabledCounter = 0;
    private final Set<FileViewProvider> myUpdatedProviders = new HashSet<FileViewProvider>();
    private final ApplicationListener myApplicationListener = new ApplicationAdapter(){

        public void writeActionStarted(Object action) {
            Project project;
            CommandProcessor processor = CommandProcessor.getInstance();
            if (processor != null && (project = processor.getCurrentCommandProject()) == PostprocessReformattingAspect.this.myProject) {
                PostprocessReformattingAspect.this.myPostponedCounter++;
            }
        }

        public void writeActionFinished(Object action) {
            Project project;
            CommandProcessor processor = CommandProcessor.getInstance();
            if (processor != null && (project = processor.getCurrentCommandProject()) == PostprocessReformattingAspect.this.myProject) {
                PostprocessReformattingAspect.this.decrementPostponedCounter();
            }
        }
    };
    private int myPostponedCounter = 0;
    private final Object LOCK = new Object();

    public PostprocessReformattingAspect(Project project, PsiManager psiManager, TreeAspect treeAspect) {
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.myTreeAspect = treeAspect;
        PomManager.getModel((Project)psiManager.getProject()).registerAspect(PostprocessReformattingAspect.class, (PomModelAspect)this, Collections.singleton(treeAspect));
        ApplicationManager.getApplication().addApplicationListener(this.myApplicationListener);
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public void dispose() {
        ApplicationManager.getApplication().removeApplicationListener(this.myApplicationListener);
    }

    public void disablePostprocessFormattingInside(final Runnable runnable) {
        this.disablePostprocessFormattingInside((Computable)new NullableComputable<Object>(){

            public Object compute() {
                runnable.run();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T disablePostprocessFormattingInside(Computable<T> computable) {
        Object object;
        try {
            ++this.myDisabledCounter;
            object = computable.compute();
            --this.myDisabledCounter;
            LOG.assertTrue(this.myDisabledCounter > 0 || !this.isDisabled());
        }
        catch (Throwable throwable) {
            --this.myDisabledCounter;
            LOG.assertTrue(this.myDisabledCounter > 0 || !this.isDisabled());
            throw throwable;
        }
        return (T)object;
    }

    public void postponeFormattingInside(final Runnable runnable) {
        this.postponeFormattingInside((Computable)new NullableComputable<Object>(){

            public Object compute() {
                runnable.run();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T postponeFormattingInside(Computable<T> computable) {
        try {
            ++this.myPostponedCounter;
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            this.decrementPostponedCounter();
        }
    }

    private void decrementPostponedCounter() {
        if (--this.myPostponedCounter == 0) {
            if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PostprocessReformattingAspect.this.doPostponedFormatting();
                    }
                });
            } else {
                this.doPostponedFormatting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomic(Runnable r) {
        Object object = this.LOCK;
        synchronized (object) {
            ProgressManager.getInstance().executeNonCancelableSection(r);
        }
    }

    public void update(final PomModelEvent event) {
        this.atomic(new Runnable(){

            @Override
            public void run() {
                if (PostprocessReformattingAspect.this.isDisabled() || PostprocessReformattingAspect.this.myPostponedCounter == 0 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet((PomModelAspect)PostprocessReformattingAspect.this.myTreeAspect);
                if (changeSet == null) {
                    return;
                }
                PsiElement psiElement = changeSet.getRootElement().getPsi();
                if (psiElement == null) {
                    return;
                }
                PsiFile containingFile = InjectedLanguageUtil.getTopLevelFile(psiElement);
                final FileViewProvider viewProvider = containingFile.getViewProvider();
                if (!viewProvider.isEventSystemEnabled()) {
                    return;
                }
                PostprocessReformattingAspect.this.myUpdatedProviders.add(viewProvider);
                for (ASTNode node : changeSet.getChangedElements()) {
                    TreeChange treeChange = changeSet.getChangesByElement(node);
                    block5: for (ASTNode affectedChild : treeChange.getAffectedChildren()) {
                        ChangeInfo childChange = treeChange.getChangeByChild(affectedChild);
                        switch (childChange.getChangeType()) {
                            case 0: 
                            case 2: {
                                PostprocessReformattingAspect.this.postponeFormatting(viewProvider, affectedChild);
                                continue block5;
                            }
                            case 3: {
                                if (CodeEditUtil.isNodeGenerated(affectedChild)) continue block5;
                                ((TreeElement)affectedChild).acceptTree(new RecursiveTreeElementWalkingVisitor(){

                                    @Override
                                    protected void visitNode(TreeElement element) {
                                        if (CodeEditUtil.isNodeGenerated(element)) {
                                            PostprocessReformattingAspect.this.postponeFormatting(viewProvider, element);
                                            return;
                                        }
                                        super.visitNode(element);
                                    }
                                });
                            }
                        }
                    }
                }
            }
        });
    }

    public void doPostponedFormatting() {
        this.atomic(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (PostprocessReformattingAspect.this.isDisabled()) {
                    return;
                }
                try {
                    FileViewProvider[] viewProviders;
                    for (FileViewProvider viewProvider : viewProviders = PostprocessReformattingAspect.this.myUpdatedProviders.toArray(new FileViewProvider[PostprocessReformattingAspect.this.myUpdatedProviders.size()])) {
                        PostprocessReformattingAspect.this.doPostponedFormatting(viewProvider);
                    }
                }
                finally {
                    LOG.assertTrue(PostprocessReformattingAspect.this.myReformatElements.isEmpty());
                }
            }
        });
    }

    public void postponedFormatting(FileViewProvider viewProvider) {
        this.postponedFormattingImpl(viewProvider, true);
    }

    public void doPostponedFormatting(FileViewProvider viewProvider) {
        this.postponedFormattingImpl(viewProvider, false);
    }

    private void postponedFormattingImpl(final FileViewProvider viewProvider, final boolean check) {
        this.atomic(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (PostprocessReformattingAspect.this.isDisabled() || check && !PostprocessReformattingAspect.this.myUpdatedProviders.contains(viewProvider)) {
                    return;
                }
                try {
                    PostprocessReformattingAspect.this.disablePostprocessFormattingInside(new Runnable(){

                        @Override
                        public void run() {
                            PostprocessReformattingAspect.this.doPostponedFormattingInner(viewProvider);
                        }
                    });
                }
                finally {
                    PostprocessReformattingAspect.this.myUpdatedProviders.remove(viewProvider);
                    PostprocessReformattingAspect.this.myReformatElements.remove(viewProvider);
                }
            }
        });
    }

    public boolean isViewProviderLocked(FileViewProvider fileViewProvider) {
        return this.myReformatElements.containsKey(fileViewProvider);
    }

    public static PostprocessReformattingAspect getInstance(Project project) {
        return (PostprocessReformattingAspect)project.getComponent(PostprocessReformattingAspect.class);
    }

    private void postponeFormatting(FileViewProvider viewProvider, ASTNode child) {
        List<ASTNode> list;
        if (!CodeEditUtil.isNodeGenerated(child) && child.getElementType() != TokenType.WHITE_SPACE) {
            int oldIndent = CodeEditUtil.getOldIndentation(child);
            LOG.assertTrue(oldIndent >= 0, (Object)("for not generated items old indentation must be defined: element=" + child + ", text=" + child.getText()));
        }
        if ((list = this.myReformatElements.get(viewProvider)) == null) {
            list = new ArrayList<ASTNode>();
            this.myReformatElements.put(viewProvider, list);
        }
        list.add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostponedFormattingInner(FileViewProvider key) {
        List<ASTNode> astNodes = this.myReformatElements.remove(key);
        Document document = key.getDocument();
        if (document == null) {
            return;
        }
        VirtualFile virtualFile = key.getVirtualFile();
        if (!virtualFile.isValid()) {
            return;
        }
        TreeSet<PostprocessFormattingTask> postprocessTasks = new TreeSet<PostprocessFormattingTask>();
        PostprocessReformattingAspect.handleReformatMarkers(key, postprocessTasks);
        if (astNodes != null) {
            PostprocessReformattingAspect.createActionsMap(astNodes, key, postprocessTasks);
        }
        if ("true".equals(System.getProperty("check.psi.is.valid")) && ApplicationManager.getApplication().isUnitTestMode()) {
            this.checkPsiIsCorrect(key);
        }
        while (!postprocessTasks.isEmpty()) {
            List<PostponedAction> normalizedActions = this.normalizeAndReorderPostponedActions(postprocessTasks, document);
            for (PostponedAction normalizedAction : normalizedActions) {
                CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myPsiManager.getProject());
                boolean old = settings.ENABLE_JAVADOC_FORMATTING;
                settings.ENABLE_JAVADOC_FORMATTING = false;
                try {
                    normalizedAction.execute(key);
                }
                finally {
                    settings.ENABLE_JAVADOC_FORMATTING = old;
                }
            }
        }
    }

    private void checkPsiIsCorrect(FileViewProvider key) {
        String expectedPsi;
        PsiFile actualPsi = key.getPsi(key.getBaseLanguage());
        PsiTreeDebugBuilder treeDebugBuilder = new PsiTreeDebugBuilder().setShowErrorElements(false).setShowWhiteSpaces(false);
        String actualPsiTree = treeDebugBuilder.psiToString((PsiElement)actualPsi);
        String fileName = key.getVirtualFile().getName();
        PsiFile psi = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, FileTypeManager.getInstance().getFileTypeByFileName(fileName), (CharSequence)actualPsi.getNode().getText(), LocalTimeCounter.currentTime(), false);
        if (actualPsi.getClass().equals(psi.getClass()) && !(expectedPsi = treeDebugBuilder.psiToString((PsiElement)psi)).equals(actualPsiTree)) {
            this.myReformatElements.clear();
            assert (expectedPsi.equals(actualPsiTree)) : "Refactored psi should be the same as result of parsing";
        }
    }

    private List<PostponedAction> normalizeAndReorderPostponedActions(TreeSet<PostprocessFormattingTask> rangesToProcess, Document document) {
        ArrayList<PostprocessFormattingTask> freeFormatingActions = new ArrayList<PostprocessFormattingTask>();
        ArrayList<ReindentTask> indentActions = new ArrayList<ReindentTask>();
        PostprocessFormattingTask accumulatedTask = null;
        Iterator<PostprocessFormattingTask> iterator = rangesToProcess.iterator();
        while (iterator.hasNext()) {
            PostprocessFormattingTask currentTask = iterator.next();
            if (accumulatedTask == null) {
                accumulatedTask = currentTask;
                iterator.remove();
                continue;
            }
            if (accumulatedTask.getStartOffset() > currentTask.getEndOffset() || accumulatedTask.getStartOffset() == currentTask.getEndOffset() && !PostprocessReformattingAspect.canStickActionsTogether(accumulatedTask, currentTask)) {
                if (accumulatedTask instanceof ReindentTask) {
                    indentActions.add((ReindentTask)accumulatedTask);
                } else {
                    freeFormatingActions.add(accumulatedTask);
                }
                accumulatedTask = currentTask;
                iterator.remove();
                continue;
            }
            if (accumulatedTask instanceof ReformatTask && currentTask instanceof ReindentTask) {
                if (accumulatedTask.getStartOffset() < currentTask.getStartOffset()) {
                    RangeMarker endOfRange = document.createRangeMarker(accumulatedTask.getStartOffset(), currentTask.getStartOffset());
                    rangesToProcess.add(new ReformatTask(endOfRange));
                    iterator = rangesToProcess.iterator();
                    while (iterator.next().getRange() != currentTask.getRange()) {
                    }
                }
                RangeMarker rangeToProcess = document.createRangeMarker(currentTask.getEndOffset(), accumulatedTask.getEndOffset());
                freeFormatingActions.add(new ReformatWithHeadingWhitespaceTask(rangeToProcess));
                accumulatedTask = currentTask;
                iterator.remove();
                continue;
            }
            if (!(accumulatedTask instanceof ReindentTask)) {
                iterator.remove();
                boolean withLeadingWhitespace = accumulatedTask instanceof ReformatWithHeadingWhitespaceTask;
                if (accumulatedTask instanceof ReformatTask && currentTask instanceof ReformatWithHeadingWhitespaceTask && accumulatedTask.getStartOffset() == currentTask.getStartOffset()) {
                    withLeadingWhitespace = true;
                } else if (accumulatedTask instanceof ReformatWithHeadingWhitespaceTask && currentTask instanceof ReformatTask && accumulatedTask.getStartOffset() < currentTask.getStartOffset()) {
                    withLeadingWhitespace = false;
                }
                RangeMarker rangeMarker = document.createRangeMarker(Math.min(accumulatedTask.getStartOffset(), currentTask.getStartOffset()), Math.max(accumulatedTask.getEndOffset(), currentTask.getEndOffset()));
                if (withLeadingWhitespace) {
                    accumulatedTask = new ReformatWithHeadingWhitespaceTask(rangeMarker);
                    continue;
                }
                accumulatedTask = new ReformatTask(rangeMarker);
                continue;
            }
            if (!(currentTask instanceof ReindentTask)) continue;
            iterator.remove();
        }
        if (accumulatedTask != null) {
            if (accumulatedTask instanceof ReindentTask) {
                indentActions.add((ReindentTask)accumulatedTask);
            } else {
                freeFormatingActions.add(accumulatedTask);
            }
        }
        ArrayList<PostponedAction> result = new ArrayList<PostponedAction>();
        Collections.reverse(freeFormatingActions);
        Collections.reverse(indentActions);
        if (!freeFormatingActions.isEmpty()) {
            FormatTextRanges ranges = new FormatTextRanges();
            for (PostprocessFormattingTask postprocessFormattingTask : freeFormatingActions) {
                TextRange range = new TextRange(postprocessFormattingTask.getStartOffset(), postprocessFormattingTask.getEndOffset());
                ranges.add(range, postprocessFormattingTask instanceof ReformatWithHeadingWhitespaceTask);
            }
            result.add(new ReformatRangesAction(ranges));
        }
        if (!indentActions.isEmpty()) {
            ReindentRangesAction reindentRangesAction = new ReindentRangesAction();
            for (ReindentTask reindentTask : indentActions) {
                reindentRangesAction.add(reindentTask.getRange(), reindentTask.getOldIndent());
            }
            result.add(reindentRangesAction);
        }
        return result;
    }

    private static boolean canStickActionsTogether(PostprocessFormattingTask currentTask, PostprocessFormattingTask nextTask) {
        if (nextTask instanceof ReformatWithHeadingWhitespaceTask && nextTask.getStartOffset() == nextTask.getEndOffset()) {
            return false;
        }
        if (currentTask instanceof ReformatWithHeadingWhitespaceTask && currentTask.getStartOffset() == currentTask.getEndOffset()) {
            return false;
        }
        return !(currentTask instanceof ReindentTask);
    }

    private static void createActionsMap(List<ASTNode> astNodes, FileViewProvider provider, final TreeSet<PostprocessFormattingTask> rangesToProcess) {
        final HashSet<ASTNode> nodesToProcess = new HashSet<ASTNode>(astNodes);
        final Document document = provider.getDocument();
        for (ASTNode node : astNodes) {
            nodesToProcess.remove(node);
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)node);
            if (fileElement == null || ((PsiFile)fileElement.getPsi()).getViewProvider() != provider) continue;
            final boolean isGenerated = CodeEditUtil.isNodeGenerated(node);
            ((TreeElement)node).acceptTree(new RecursiveTreeElementVisitor(){
                boolean inGeneratedContext;
                {
                    this.inGeneratedContext = !isGenerated;
                }

                @Override
                protected boolean visitNode(TreeElement element) {
                    if (nodesToProcess.contains(element)) {
                        return false;
                    }
                    boolean currentNodeGenerated = CodeEditUtil.isNodeGenerated(element);
                    CodeEditUtil.setNodeGenerated(element, false);
                    if (currentNodeGenerated && !this.inGeneratedContext) {
                        rangesToProcess.add(new ReformatTask(document.createRangeMarker(element.getTextRange())));
                        this.inGeneratedContext = true;
                    }
                    if (!currentNodeGenerated && this.inGeneratedContext) {
                        if (element.getElementType() == TokenType.WHITE_SPACE) {
                            return false;
                        }
                        int oldIndent = CodeEditUtil.getOldIndentation(element);
                        LOG.assertTrue(oldIndent >= 0, (Object)"for not generated items old indentation must be defined");
                        rangesToProcess.add(new ReindentTask(document.createRangeMarker(element.getTextRange()), oldIndent));
                        this.inGeneratedContext = false;
                    }
                    return true;
                }

                @Override
                public void visitComposite(CompositeElement composite) {
                    boolean oldGeneratedContext = this.inGeneratedContext;
                    super.visitComposite(composite);
                    this.inGeneratedContext = oldGeneratedContext;
                }

                @Override
                public void visitLeaf(LeafElement leaf) {
                    boolean oldGeneratedContext = this.inGeneratedContext;
                    super.visitLeaf(leaf);
                    this.inGeneratedContext = oldGeneratedContext;
                }
            });
        }
    }

    private static void handleReformatMarkers(FileViewProvider key, final TreeSet<PostprocessFormattingTask> rangesToProcess) {
        final Document document = key.getDocument();
        for (FileElement fileElement : ((SingleRootFileViewProvider)key).getKnownTreeRoots()) {
            fileElement.acceptTree(new RecursiveTreeElementWalkingVisitor(){

                @Override
                protected void visitNode(TreeElement element) {
                    if (CodeEditUtil.isMarkedToReformatBefore(element)) {
                        CodeEditUtil.markToReformatBefore(element, false);
                        rangesToProcess.add(new ReformatWithHeadingWhitespaceTask(document.createRangeMarker(element.getStartOffset(), element.getStartOffset())));
                    }
                    super.visitNode(element);
                }
            });
        }
    }

    private static void adjustIndentationInRange(PsiFile file, Document document, TextRange[] indents, int indentAdjustment) {
        Helper formatHelper = HelperFactory.createHelper(file.getFileType(), file.getProject());
        CharSequence charsSequence = document.getCharsSequence();
        for (TextRange indent : indents) {
            String oldIndentStr = ((Object)charsSequence.subSequence(indent.getStartOffset() + 1, indent.getEndOffset())).toString();
            int oldIndent = formatHelper.getIndent(oldIndentStr, true);
            String newIndentStr = formatHelper.fillIndent(Math.max(oldIndent + indentAdjustment, 0));
            document.replaceString(indent.getStartOffset() + 1, indent.getEndOffset(), (CharSequence)newIndentStr);
        }
    }

    private static int getNewIndent(PsiFile psiFile, int firstWhitespace) {
        int startOffset;
        Helper formatHelper = HelperFactory.createHelper(psiFile.getFileType(), psiFile.getProject());
        Document document = psiFile.getViewProvider().getDocument();
        int endOffset = startOffset = document.getLineStartOffset(document.getLineNumber(firstWhitespace));
        CharSequence charsSequence = document.getCharsSequence();
        while (Character.isWhitespace(charsSequence.charAt(endOffset++))) {
        }
        String newIndentStr = ((Object)charsSequence.subSequence(startOffset, endOffset - 1)).toString();
        return formatHelper.getIndent(newIndentStr, true);
    }

    public boolean isDisabled() {
        return this.myDisabledCounter > 0;
    }

    private CodeFormatterFacade getFormatterFacade(FileViewProvider viewProvider) {
        CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)this.myPsiManager.getProject());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject());
        Document document = viewProvider.getDocument();
        FileType fileType = viewProvider.getVirtualFile().getFileType();
        Helper helper = HelperFactory.createHelper(fileType, this.myPsiManager.getProject());
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(styleSettings, helper);
        documentManager.commitDocument(document);
        return codeFormatter;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("Postponed reformatting model" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PostprocessReformattingAspect.getComponentName must not return null");
        }
        return "Postponed reformatting model";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void clear() {
        this.myReformatElements.clear();
    }

    private static class ReindentRangesAction
    implements PostponedAction {
        private final List<Pair<Integer, RangeMarker>> myRangesToReindent = new ArrayList<Pair<Integer, RangeMarker>>();

        private ReindentRangesAction() {
        }

        public void add(RangeMarker rangeMarker, int oldIndent) {
            this.myRangesToReindent.add((Pair<Integer, RangeMarker>)new Pair((Object)oldIndent, (Object)rangeMarker));
        }

        @Override
        public void execute(FileViewProvider viewProvider) {
            Document document = viewProvider.getDocument();
            PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
            for (Pair<Integer, RangeMarker> integerRangeMarkerPair : this.myRangesToReindent) {
                RangeMarker marker = (RangeMarker)integerRangeMarkerPair.second;
                CharSequence charsSequence = document.getCharsSequence().subSequence(marker.getStartOffset(), marker.getEndOffset());
                int oldIndent = (Integer)integerRangeMarkerPair.first;
                TextRange[] whitespaces = CharArrayUtil.getIndents((CharSequence)charsSequence, (int)marker.getStartOffset());
                int indentAdjustment = PostprocessReformattingAspect.getNewIndent(psiFile, marker.getStartOffset()) - oldIndent;
                if (indentAdjustment == 0) continue;
                PostprocessReformattingAspect.adjustIndentationInRange(psiFile, document, whitespaces, indentAdjustment);
            }
        }
    }

    private class ReformatRangesAction
    implements PostponedAction {
        private final FormatTextRanges myRanges;

        public ReformatRangesAction(FormatTextRanges ranges) {
            this.myRanges = ranges;
        }

        @Override
        public void execute(FileViewProvider viewProvider) {
            CodeFormatterFacade codeFormatter = PostprocessReformattingAspect.this.getFormatterFacade(viewProvider);
            codeFormatter.processText(viewProvider.getPsi(viewProvider.getBaseLanguage()), this.myRanges.ensureNonEmpty());
        }
    }

    private static interface PostponedAction {
        public void execute(FileViewProvider var1);
    }

    private static class ReindentTask
    extends PostprocessFormattingTask {
        private final int myOldIndent;

        public ReindentTask(RangeMarker rangeMarker, int oldIndent) {
            super(rangeMarker);
            this.myOldIndent = oldIndent;
        }

        public int getOldIndent() {
            return this.myOldIndent;
        }
    }

    private static class ReformatWithHeadingWhitespaceTask
    extends PostprocessFormattingTask {
        public ReformatWithHeadingWhitespaceTask(RangeMarker rangeMarker) {
            super(rangeMarker);
        }
    }

    private static class ReformatTask
    extends PostprocessFormattingTask {
        public ReformatTask(RangeMarker rangeMarker) {
            super(rangeMarker);
        }
    }

    private static abstract class PostprocessFormattingTask
    implements Comparable<PostprocessFormattingTask> {
        private RangeMarker myRange;

        public PostprocessFormattingTask(RangeMarker rangeMarker) {
            this.myRange = rangeMarker;
        }

        @Override
        public int compareTo(PostprocessFormattingTask o) {
            RangeMarker o1 = this.myRange;
            RangeMarker o2 = o.myRange;
            if (o1.equals(o2)) {
                return 0;
            }
            int diff = o2.getEndOffset() - o1.getEndOffset();
            if (diff == 0) {
                if (o1.getStartOffset() == o2.getStartOffset()) {
                    return 0;
                }
                if (o1.getStartOffset() == o1.getEndOffset()) {
                    return -1;
                }
                if (o2.getStartOffset() == o2.getEndOffset()) {
                    return 1;
                }
                return o1.getStartOffset() - o2.getStartOffset();
            }
            return diff;
        }

        public RangeMarker getRange() {
            return this.myRange;
        }

        public int getStartOffset() {
            return this.myRange.getStartOffset();
        }

        public int getEndOffset() {
            return this.myRange.getEndOffset();
        }
    }
}

