/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfoFactory;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPsiElementPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl");
    private E myElement;
    private SmartPointerElementInfo myElementInfo;
    private final Project myProject;

    public SmartPsiElementPointerImpl(Project project, E element) {
        Document doc;
        PsiDocumentManager psiDocumentManager;
        this.myProject = project;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myElement = element;
        this.myElementInfo = null;
        PsiFile file = element.getContainingFile();
        if (file != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)project)) instanceof PsiDocumentManagerImpl && (doc = psiDocumentManager.getCachedDocument(file)) != null && !(element instanceof PsiFile)) {
            LOG.assertTrue(!psiDocumentManager.isUncommited(doc) || ((PsiDocumentManagerImpl)psiDocumentManager).isCommittingDocument(doc));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmartPsiElementPointer)) {
            return false;
        }
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)obj;
        return Comparing.equal((Object)pointer.getElement(), this.getElement());
    }

    public int hashCode() {
        E element = this.getElement();
        return element != null ? element.hashCode() : 0;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.getProject must not return null");
        }
        return project;
    }

    @Nullable
    public E getElement() {
        if (this.myElement != null && !this.myElement.isValid()) {
            if (this.myElementInfo == null) {
                this.myElement = null;
            } else {
                PsiElement restored = this.myElementInfo.restoreElement();
                if (!(restored == null || SmartPsiElementPointerImpl.areElementKindEqual(restored, this.myElement) && restored.isValid())) {
                    restored = null;
                }
                this.myElement = restored;
            }
        }
        return this.myElement;
    }

    public PsiFile getContainingFile() {
        Document doc;
        if (this.myElement != null) {
            return this.myElement.getContainingFile();
        }
        Document document = doc = this.myElementInfo == null ? null : this.myElementInfo.getDocumentToSynchronize();
        if (doc == null) {
            E resolved = this.getElement();
            return resolved != null ? resolved.getContainingFile() : null;
        }
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(doc);
    }

    @Nullable
    private SmartPointerElementInfo createElementInfo() {
        if (this.myElement instanceof PsiCompiledElement) {
            return null;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (!this.myElement.isPhysical()) {
            return null;
        }
        for (SmartPointerElementInfoFactory factory : (SmartPointerElementInfoFactory[])Extensions.getExtensions(SmartPointerElementInfoFactory.EP_NAME)) {
            SmartPointerElementInfo result = factory.createElementInfo((PsiElement)this.myElement);
            if (result == null) continue;
            return result;
        }
        return containingFile.getContext() != null ? new InjectedSelfElementInfo((PsiElement)this.myElement) : (this.myElement instanceof PsiFile ? new FileElementInfo((PsiFile)this.myElement) : new SelfElementInfo((PsiElement)this.myElement));
    }

    private static boolean areElementKindEqual(PsiElement element1, PsiElement element2) {
        return element1.getClass().equals(element2.getClass());
    }

    @Override
    public void documentAndPsiInSync() {
        if (this.myElementInfo != null) {
            this.myElementInfo.documentAndPsiInSync();
        }
    }

    @Override
    public void fastenBelt() {
        if (this.myElementInfo != null && this.myElement != null && this.myElement.isValid()) {
            return;
        }
        if (this.myElementInfo == null && this.myElement != null && this.myElement.isValid()) {
            this.myElementInfo = this.createElementInfo();
        }
    }
}

