/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelfElementInfo
implements SmartPointerElementInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SelfElementInfo");
    protected PsiFile myFile;
    private final RangeMarker myMarker;
    private int mySyncStartOffset;
    private int mySyncEndOffset;
    private boolean mySyncMarkerIsValid;
    private Class myType;
    private final Project myProject;

    public SelfElementInfo(PsiElement anchor) {
        LOG.assertTrue(anchor.isPhysical());
        this.myFile = anchor.getContainingFile();
        TextRange range = anchor.getTextRange();
        LOG.assertTrue(range != null, (Object)anchor);
        this.myProject = this.myFile.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = documentManager.getDocument(this.myFile);
        LOG.assertTrue(document != null, (Object)this.myFile.getName());
        if (documentManager.isUncommited(document)) {
            this.mySyncMarkerIsValid = false;
            this.myMarker = document.createRangeMarker(0, 0, false);
        } else {
            this.myMarker = document.createRangeMarker(range.getStartOffset(), range.getEndOffset(), true);
            range = this.getPersistentAnchorRange(anchor, document);
            this.mySyncStartOffset = range.getStartOffset();
            this.mySyncEndOffset = range.getEndOffset();
            this.mySyncMarkerIsValid = true;
            this.myType = anchor.getClass();
        }
    }

    protected TextRange getPersistentAnchorRange(PsiElement anchor, Document document) {
        return anchor.getTextRange();
    }

    @Override
    public Document getDocumentToSynchronize() {
        return this.myMarker.getDocument();
    }

    @Override
    public void documentAndPsiInSync() {
        if (!this.myMarker.isValid()) {
            this.mySyncMarkerIsValid = false;
            return;
        }
        this.mySyncStartOffset = this.myMarker.getStartOffset();
        this.mySyncEndOffset = this.myMarker.getEndOffset();
    }

    @Override
    public PsiElement restoreElement() {
        if (!this.mySyncMarkerIsValid) {
            return null;
        }
        this.myFile = SelfElementInfo.restoreFile(this.myFile, this.myProject);
        if (this.myFile == null) {
            return null;
        }
        int syncStartOffset = this.getSyncStartOffset();
        int syncEndOffset = this.getSyncEndOffset();
        PsiElement anchor = this.myFile.getViewProvider().findElementAt(syncStartOffset, this.myFile.getLanguage());
        if (anchor == null) {
            return null;
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != syncStartOffset) {
            return null;
        }
        while (range.getEndOffset() < syncEndOffset && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        while (range.getEndOffset() == syncEndOffset && anchor != null && !this.myType.equals(anchor.getClass()) && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        if (range.getEndOffset() == syncEndOffset) {
            return anchor;
        }
        return null;
    }

    @Nullable
    public static PsiFile restoreFile(PsiFile file, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SelfElementInfo.restoreFile must not be null");
        }
        if (file == null) {
            return null;
        }
        if (file.isValid()) {
            return file;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vParent = virtualFile.getParent();
        if (vParent == null || !vParent.isDirectory()) {
            return null;
        }
        String name = file.getName();
        VirtualFile child = vParent.findChild(name);
        if (child == null || !child.isValid()) {
            return null;
        }
        file = PsiManager.getInstance((Project)project).findFile(child);
        if (file == null || !file.isValid()) {
            return null;
        }
        return file;
    }

    protected int getSyncEndOffset() {
        return this.mySyncEndOffset;
    }

    protected int getSyncStartOffset() {
        return this.mySyncStartOffset;
    }
}

