/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class MethodTextOccurenceProcessor
implements TextOccurenceProcessor {
    private final PsiMethod[] myMethods;
    private final Processor<PsiReference> myConsumer;
    private final PsiClass myContainingClass;
    private final boolean myStrictSignatureSearch;

    public MethodTextOccurenceProcessor(Processor<PsiReference> consumer, @NotNull PsiClass aClass, boolean strictSignatureSearch, PsiMethod ... methods) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/MethodTextOccurenceProcessor.<init> must not be null");
        }
        this.myMethods = methods;
        this.myConsumer = consumer;
        this.myContainingClass = aClass;
        this.myStrictSignatureSearch = strictSignatureSearch;
    }

    public boolean execute(PsiElement element, int offsetInElement) {
        PsiReference[] refs;
        for (PsiReference ref : refs = element.getReferences()) {
            if (!ref.getRangeInElement().contains(offsetInElement)) continue;
            for (PsiMethod method : this.myMethods) {
                PsiManager manager;
                MethodSignature refSignature;
                MethodSignature superSignature;
                PsiSubstitutor substitutor;
                PsiMethod refMethod;
                PsiClass refMethodClass;
                if (!method.isValid()) continue;
                if (ref instanceof ResolvingHint && !((ResolvingHint)ref).canResolveTo((PsiElement)method)) {
                    return true;
                }
                if (ref.isReferenceTo((PsiElement)method)) {
                    return this.myConsumer.process((Object)ref);
                }
                PsiElement refElement = ref.resolve();
                if (!(refElement instanceof PsiMethod) || (refMethodClass = (refMethod = (PsiMethod)refElement).getContainingClass()) == null) continue;
                if (!refMethod.hasModifierProperty("static") && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)this.myContainingClass, (PsiClass)refMethodClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null && MethodSignatureUtil.isSubsignature((MethodSignature)(superSignature = method.getSignature(substitutor)), (MethodSignature)(refSignature = refMethod.getSignature(PsiSubstitutor.EMPTY))) && !this.myConsumer.process((Object)ref)) {
                    return false;
                }
                if (this.myStrictSignatureSearch || !(manager = method.getManager()).areElementsEquivalent((PsiElement)refMethodClass, (PsiElement)this.myContainingClass) || this.myConsumer.process((Object)ref)) continue;
                return false;
            }
        }
        return true;
    }
}

