/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.JavaIndexPatternBuilder;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharSequenceSubSequence;

public class JspIndexPatternBuilder
implements IndexPatternBuilder {
    @Override
    public Lexer getIndexingLexer(PsiFile file) {
        if (JspPsiUtil.isInJspFile((PsiElement)file)) {
            EditorHighlighter highlighter;
            EditorHighlighter cachedEditorHighlighter;
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            boolean alreadyInitializedHighlighter = false;
            if (document instanceof DocumentImpl && (cachedEditorHighlighter = ((DocumentImpl)document).getEditorHighlighterForCachesBuilding()) != null && IdTableBuilding.checkCanUseCachedEditorHighlighter(file.getText(), cachedEditorHighlighter)) {
                highlighter = cachedEditorHighlighter;
                alreadyInitializedHighlighter = true;
            } else {
                highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file.getProject(), file.getVirtualFile());
            }
            return new LexerEditorHighlighterLexer(highlighter, alreadyInitializedHighlighter);
        }
        return null;
    }

    @Override
    public TokenSet getCommentTokenSet(PsiFile file) {
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        TokenSet commentTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{JavaIndexPatternBuilder.XML_COMMENT_BIT_SET, StdTokenSets.COMMENT_BIT_SET});
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(jspFile.getViewProvider().getTemplateDataLanguage());
        if (parserDefinition != null) {
            commentTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{commentTokens, parserDefinition.getCommentTokens()});
        }
        return commentTokens;
    }

    @Override
    public int getCommentStartDelta(IElementType tokenType) {
        return tokenType == JspTokenType.JSP_COMMENT ? "<%--".length() : 0;
    }

    @Override
    public int getCommentEndDelta(IElementType tokenType) {
        return tokenType == JspTokenType.JSP_COMMENT ? "--%>".length() : 0;
    }

    private static class LexerEditorHighlighterLexer
    extends LexerBase {
        HighlighterIterator iterator;
        CharSequence buffer;
        int start;
        int end;
        private final EditorHighlighter myHighlighter;
        private final boolean myAlreadyInitializedHighlighter;

        public LexerEditorHighlighterLexer(EditorHighlighter highlighter, boolean alreadyInitializedHighlighter) {
            this.myHighlighter = highlighter;
            this.myAlreadyInitializedHighlighter = alreadyInitializedHighlighter;
        }

        public void start(CharSequence buffer, int startOffset, int endOffset, int state) {
            if (this.myAlreadyInitializedHighlighter) {
                this.buffer = buffer;
                this.start = startOffset;
                this.end = endOffset;
            } else {
                this.buffer = buffer;
                this.start = startOffset;
                this.end = endOffset;
                this.myHighlighter.setText((CharSequence)new CharSequenceSubSequence(this.buffer, this.start, this.end));
            }
            this.iterator = this.myHighlighter.createIterator(0);
        }

        public int getState() {
            return 0;
        }

        public IElementType getTokenType() {
            if (this.iterator.atEnd()) {
                return null;
            }
            return this.iterator.getTokenType();
        }

        public int getTokenStart() {
            return this.iterator.getStart();
        }

        public int getTokenEnd() {
            return this.iterator.getEnd();
        }

        public void advance() {
            this.iterator.advance();
        }

        public CharSequence getBufferSequence() {
            return this.buffer;
        }

        public int getBufferEnd() {
            return this.end;
        }
    }
}

