/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Collection;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    public boolean execute(DirectClassInheritorsSearch.SearchParameters p, final Processor<PsiClass> consumer) {
        final PsiClass aClass = p.getClassToProcess();
        final PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)aClass.getProject());
        SearchScope useScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return aClass.getUseScope();
            }
        });
        String qualifiedName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return aClass.getQualifiedName();
            }
        });
        if ("java.lang.Object".equals(qualifiedName)) {
            SearchScope scope = useScope.intersectWith((SearchScope)GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject()), (FileType[])new FileType[]{StdFileTypes.JSP, StdFileTypes.JSPX})));
            return AllClassesSearch.search((SearchScope)scope, (Project)aClass.getProject()).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    if (psiClass.isInterface()) {
                        return consumer.process((Object)psiClass);
                    }
                    PsiClass superClass = psiClass.getSuperClass();
                    if (superClass != null && "java.lang.Object".equals(superClass.getQualifiedName())) {
                        return consumer.process((Object)psiClass);
                    }
                    return true;
                }
            });
        }
        final GlobalSearchScope scope = useScope instanceof GlobalSearchScope ? (GlobalSearchScope)useScope : null;
        final String searchKey = aClass.getName();
        if (StringUtil.isEmpty((String)searchKey)) {
            return true;
        }
        Collection candidates = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiReferenceList>>(){

            public Collection<PsiReferenceList> compute() {
                return JavaSuperClassNameOccurenceIndex.getInstance().get(searchKey, psiManager.getProject(), scope);
            }
        });
        for (PsiReferenceList referenceList : candidates) {
            ProgressManager.checkCanceled();
            PsiClass candidate = (PsiClass)referenceList.getParent();
            if (consumer.process((Object)candidate)) continue;
            return false;
        }
        if (p.includeAnonymous()) {
            Collection anonymousCandidates = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiAnonymousClass>>(){

                public Collection<PsiAnonymousClass> compute() {
                    return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(searchKey, psiManager.getProject(), scope);
                }
            });
            for (PsiClass candidate : anonymousCandidates) {
                ProgressManager.checkCanceled();
                if (consumer.process((Object)candidate)) continue;
                return false;
            }
            if (aClass.isEnum()) {
                PsiField[] fields;
                for (final PsiField field : fields = (PsiField[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiField[]>(){

                    public PsiField[] compute() {
                        return aClass.getFields();
                    }
                })) {
                    PsiEnumConstantInitializer initializingClass;
                    if (!(field instanceof PsiEnumConstant) || (initializingClass = (PsiEnumConstantInitializer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiEnumConstantInitializer>(){

                        public PsiEnumConstantInitializer compute() {
                            return ((PsiEnumConstant)field).getInitializingClass();
                        }
                    })) == null || consumer.process((Object)initializingClass)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

