/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;

public class AnnotatedElementsSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.AnnotatedMembersSearcher");

    public boolean execute(AnnotatedElementsSearch.Parameters p, Processor<PsiModifierListOwner> consumer) {
        PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated members search";
        String annotationFQN = annClass.getQualifiedName();
        assert (annotationFQN != null);
        PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)annClass.getProject());
        SearchScope useScope = p.getScope();
        Class[] types = p.getTypes();
        GlobalSearchScope scope = useScope instanceof GlobalSearchScope ? (GlobalSearchScope)useScope : null;
        Collection<PsiAnnotation> annotations = JavaAnnotationIndex.getInstance().get(annClass.getName(), annClass.getProject(), scope);
        for (PsiElement psiElement : annotations) {
            PsiModifierList modlist;
            PsiElement owner;
            PsiElement parent;
            PsiAnnotation ann;
            PsiJavaCodeReferenceElement ref;
            if (AnnotatedElementsSearcher.notAnnotation(psiElement) || (ref = (ann = (PsiAnnotation)psiElement).getNameReferenceElement()) == null || !((parent = ann.getParent()) instanceof PsiModifierList) || !AnnotatedElementsSearcher.isInstanceof(owner = (modlist = (PsiModifierList)parent).getParent(), types)) continue;
            PsiModifierListOwner candidate = (PsiModifierListOwner)owner;
            if (!psiManager.areElementsEquivalent(ref.resolve(), (PsiElement)annClass) || useScope instanceof GlobalSearchScope && !((GlobalSearchScope)useScope).contains(candidate.getContainingFile().getVirtualFile()) || consumer.process((Object)candidate)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInstanceof(PsiElement owner, Class<? extends PsiModifierListOwner>[] types) {
        for (Class<? extends PsiModifierListOwner> type : types) {
            if (!type.isInstance(owner)) continue;
            return true;
        }
        return false;
    }

    private static boolean notAnnotation(PsiElement found) {
        if (found instanceof PsiAnnotation) {
            return false;
        }
        VirtualFile faultyContainer = PsiUtil.getVirtualFile((PsiElement)found);
        LOG.error("Non annotation in annotations list: " + faultyContainer + "; element:" + found);
        if (faultyContainer != null && faultyContainer.isValid()) {
            FileBasedIndex.getInstance().requestReindex(faultyContainer);
        }
        return true;
    }
}

