/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class LightVariableBase
extends LightElement
implements PsiVariable {
    protected PsiElement myScope;
    protected PsiIdentifier myNameIdentifier;
    protected final PsiType myType;
    protected final PsiModifierList myModifierList;
    protected boolean myWritable;

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, @NotNull PsiType type, boolean writable, PsiElement scope) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/light/LightVariableBase.<init> must not be null");
        }
        super(manager, StdFileTypes.JAVA.getLanguage());
        this.myModifierList = new LightModifierList(this.myManager);
        this.myNameIdentifier = nameIdentifier;
        this.myWritable = writable;
        this.myType = type;
        this.myScope = scope;
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = this.myScope;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightVariableBase.getDeclarationScope must not return null");
        }
        return psiElement;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    @Override
    public boolean isValid() {
        return this.myNameIdentifier == null || this.myNameIdentifier.isValid();
    }

    @NotNull
    public String getName() {
        String string = StringUtil.notNullize((String)this.getNameIdentifier().getText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightVariableBase.getName must not return null");
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightVariableBase.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myType;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightVariableBase.getType must not return null");
        }
        return psiType;
    }

    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement psiTypeElement = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeElement(this.myType);
        if (psiTypeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightVariableBase.getTypeElement must not return null");
        }
        return psiTypeElement;
    }

    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightVariableBase.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public String getText() {
        return this.myNameIdentifier.getText();
    }

    public PsiElement copy() {
        return null;
    }

    public Object computeConstantValue() {
        return null;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public boolean isWritable() {
        return this.myWritable;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = LightVariableBase.createLayeredIcon((Icon)Icons.VARIABLE_ICON, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    public PsiType getTypeNoResolve() {
        return this.getType();
    }
}

