/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class PsiFieldStubImpl
extends StubBase<PsiField>
implements PsiFieldStub {
    private static final int INITIALIZER_LENGTH_LIMIT = 1000;
    private final StringRef myName;
    private final TypeInfo myType;
    private final StringRef myInitializer;
    private final byte myFlags;
    private static final int ENUM_CONST = 1;
    private static final int DEPRECATED = 2;
    private static final int DEPRECATED_ANNOTATION = 4;

    public PsiFieldStubImpl(StubElement parent, String name, @NotNull TypeInfo type, String initializer, byte flags) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl.<init> must not be null");
        }
        this(parent, StringRef.fromString((String)name), type, StringRef.fromString((String)initializer), flags);
    }

    public PsiFieldStubImpl(StubElement parent, StringRef name, @NotNull TypeInfo type, StringRef initializer, byte flags) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl.<init> must not be null");
        }
        super(parent, (IStubElementType)(PsiFieldStubImpl.isEnumConst(flags) ? JavaStubElementTypes.ENUM_CONSTANT : JavaStubElementTypes.FIELD));
        this.myInitializer = initializer != null && initializer.length() > 1000 ? StringRef.fromString((String)";INITIALIZER_TOO_LONG;") : initializer;
        this.myName = name;
        this.myType = type;
        this.myFlags = flags;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TypeInfo getType(boolean doResolve) {
        TypeInfo typeInfo;
        if (!doResolve) {
            typeInfo = this.myType;
            if (typeInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl.getType must not return null");
            return typeInfo;
        }
        typeInfo = PsiFieldStubImpl.addApplicableTypeAnnotationsFromChildModifierList(this, this.myType);
        if (typeInfo != null) return typeInfo;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl.getType must not return null");
    }

    public static TypeInfo addApplicableTypeAnnotationsFromChildModifierList(StubBase<?> aThis, TypeInfo type) {
        PsiModifierListStub modifierList = (PsiModifierListStub)aThis.findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        if (modifierList == null) {
            return type;
        }
        TypeInfo typeInfo = new TypeInfo(type);
        for (StubElement child : modifierList.getChildrenStubs()) {
            if (!(child instanceof PsiAnnotationStub)) continue;
            PsiAnnotationStub annotationStub = (PsiAnnotationStub)child;
            PsiAnnotationImpl annotation = (PsiAnnotationImpl)annotationStub.getTreeElement().getPsi();
            if (!AnnotationsHighlightUtil.isAnnotationApplicableTo(annotation, true, "TYPE_USE")) continue;
            typeInfo.addAnnotation(annotationStub);
        }
        return typeInfo;
    }

    @Override
    public String getInitializerText() {
        return StringRef.toString((StringRef)this.myInitializer);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public boolean isEnumConstant() {
        return PsiFieldStubImpl.isEnumConst(this.myFlags);
    }

    private static boolean isEnumConst(byte flags) {
        return (flags & 1) != 0;
    }

    @Override
    public boolean isDeprecated() {
        return (this.myFlags & 2) != 0;
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return (this.myFlags & 4) != 0;
    }

    public String getName() {
        return StringRef.toString((StringRef)this.myName);
    }

    public static byte packFlags(boolean isEnumConst, boolean isDeprecated, boolean hasDeprecatedAnnotation) {
        byte flags = 0;
        if (isEnumConst) {
            flags = (byte)(flags | 1);
        }
        if (isDeprecated) {
            flags = (byte)(flags | 2);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiFieldStub[");
        if (this.isDeprecated() || this.hasDeprecatedAnnotation()) {
            builder.append("deprecated ");
        }
        if (this.isEnumConstant()) {
            builder.append("enumconst ");
        }
        builder.append(this.getName()).append(':').append(TypeInfo.createTypeText(this.getType(true)));
        if (this.myInitializer != null) {
            builder.append('=').append(this.myInitializer);
        }
        builder.append("]");
        return builder.toString();
    }
}

