/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ClsDocTagImpl
extends ClsElementImpl
implements PsiDocTag {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsDocTagImpl");
    private final ClsDocCommentImpl myDocComment;
    private final PsiElement myNameElement;

    public ClsDocTagImpl(ClsDocCommentImpl docComment, @NonNls String name) {
        this.myDocComment = docComment;
        this.myNameElement = new NameElement(name);
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        buffer.append(this.myNameElement.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsDocTagImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, ElementType.DOC_TAG);
    }

    @Override
    public String getText() {
        return this.myNameElement.getText();
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.myNameElement.textToCharArray();
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsDocTagImpl.textToCharArray must not return null");
        }
        return cArray;
    }

    public String getName() {
        return this.getNameElement().getText().substring(1);
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsDocTagImpl.textMatches must not be null");
        }
        return this.myNameElement.textMatches(text);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsDocTagImpl.textMatches must not be null");
        }
        return this.myNameElement.textMatches(element);
    }

    @Override
    public int getTextLength() {
        return this.myNameElement.getTextLength();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myNameElement};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsDocTagImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    public PsiElement getParent() {
        return this.getContainingComment();
    }

    public PsiDocComment getContainingComment() {
        return this.myDocComment;
    }

    public PsiElement getNameElement() {
        return this.myNameElement;
    }

    public PsiElement[] getDataElements() {
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiDocTagValue getValueElement() {
        return null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsDocTagImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocTag((PsiDocTag)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsDocTagImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameElement(), name);
        return this;
    }

    private class NameElement
    extends ClsElementImpl {
        private final String myText;

        public NameElement(String text) {
            this.myText = text;
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        @NotNull
        public char[] textToCharArray() {
            char[] cArray = this.myText.toCharArray();
            if (cArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement.textToCharArray must not return null");
            }
            return cArray;
        }

        @NotNull
        public PsiElement[] getChildren() {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement.getChildren must not return null");
            }
            return PsiElement.EMPTY_ARRAY;
        }

        @Override
        public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        }

        @Override
        public void setMirror(@NotNull TreeElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement.setMirror must not be null");
            }
            this.setMirrorCheckingType(element, null);
        }

        public PsiElement getParent() {
            return ClsDocTagImpl.this;
        }

        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement.accept must not be null");
            }
            visitor.visitElement((PsiElement)this);
        }
    }
}

