/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.impl.CacheUtil;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoOccurrenceConsumer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class LexerBasedTodoIndexer
implements DataIndexer<TodoIndexEntry, Integer, FileContent> {
    @Override
    @NotNull
    public Map<TodoIndexEntry, Integer> map(FileContent inputData) {
        TodoOccurrenceConsumer todoOccurrenceConsumer = new TodoOccurrenceConsumer();
        Lexer filterLexer = this.createLexer(todoOccurrenceConsumer);
        CharSequence chars = inputData.getContentAsText();
        filterLexer.start(chars);
        while (filterLexer.getTokenType() != null) {
            filterLexer.advance();
        }
        HashMap<TodoIndexEntry, Integer> map = new HashMap<TodoIndexEntry, Integer>();
        for (IndexPattern indexPattern : CacheUtil.getIndexPatterns()) {
            int count = todoOccurrenceConsumer.getOccurrenceCount(indexPattern);
            if (count <= 0) continue;
            map.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
        }
        HashMap<TodoIndexEntry, Integer> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/todo/LexerBasedTodoIndexer.map must not return null");
        }
        return hashMap;
    }

    protected abstract Lexer createLexer(TodoOccurrenceConsumer var1);
}

