/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.lexer.JavaLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.impl.source.jsp.jspJava.JspCodeBlock;
import com.intellij.psi.impl.source.jsp.jspJava.JspJavaComment;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.Map;

public class JavaSpacePropertyProcessor
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.java.JavaSpacePropertyProcessor");
    private PsiElement myParent;
    private int myRole1;
    private int myRole2;
    private CodeStyleSettings mySettings;
    private Spacing myResult;
    private ASTNode myChild1;
    private ASTNode myChild2;
    private IElementType myType1;
    private IElementType myType2;
    private ImportHelper myImportHelper;
    private static final ThreadLocal<JavaSpacePropertyProcessor> mySharedProcessorAllocator = new ThreadLocal();
    private static final Map<Pair<IElementType, IElementType>, Boolean> myCanStickJavaTokensMatrix = new ConcurrentHashMap();

    private JavaSpacePropertyProcessor() {
    }

    private void doInit(ASTNode child, CodeStyleSettings settings) {
        this.init(child);
        this.mySettings = settings;
        if (this.myChild1.getPsi().getLanguage() != StdLanguages.JAVA || this.myChild2.getPsi().getLanguage() != StdLanguages.JAVA) {
            return;
        }
        if (this.myChild2 != null && StdTokenSets.COMMENT_BIT_SET.contains(this.myChild2.getElementType())) {
            this.myResult = this.mySettings.KEEP_FIRST_COLUMN_COMMENT ? Spacing.createKeepingFirstColumnSpacing((int)0, (int)Integer.MAX_VALUE, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myParent != null) {
            this.myParent.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                ASTNode prev = JavaSpacePropertyProcessor.getPrevElementType(this.myChild2);
                if (prev != null && prev.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (!JavaSpacePropertyProcessor.canStickChildrenTogether(this.myChild1, this.myChild2)) {
                    this.myResult = Spacing.createSpacing((int)1, (int)Integer.MIN_VALUE, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (this.myChild1.getElementType() == JavaTokenType.C_STYLE_COMMENT) {
                    this.myResult = null;
                } else if (!JavaSpacePropertyProcessor.shouldKeepSpace(this.myParent)) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
            }
        }
    }

    private void clear() {
        this.myResult = null;
        this.myChild1 = null;
        this.myChild2 = null;
        this.myParent = null;
        this.myImportHelper = null;
        this.myRole2 = -1;
        this.myRole1 = -1;
        this.myType2 = null;
        this.myType1 = null;
    }

    private static boolean shouldKeepSpace(PsiElement parent) {
        IElementType type = parent.getNode().getElementType();
        if (type == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            return PsiTreeUtil.getParentOfType((PsiElement)parent, PsiDocMethodOrFieldRef.class) != null;
        }
        return type == JavaDocElementType.DOC_COMMENT || type == JavaDocElementType.DOC_TAG || type == JavaDocElementType.DOC_INLINE_TAG;
    }

    private void init(ASTNode child) {
        ASTNode treePrev;
        if (child == null) {
            return;
        }
        for (treePrev = child.getTreePrev(); treePrev != null && JavaSpacePropertyProcessor.isWhiteSpace(treePrev); treePrev = treePrev.getTreePrev()) {
        }
        if (treePrev == null) {
            this.init(child.getTreeParent());
        } else {
            this.myChild2 = child;
            this.myChild1 = treePrev;
            CompositeElement parent = (CompositeElement)treePrev.getTreeParent();
            this.myParent = SourceTreeToPsiMap.treeElementToPsi(parent);
            this.myRole1 = parent.getChildRole(treePrev);
            this.myType1 = treePrev.getElementType();
            this.myRole2 = parent.getChildRole(child);
            this.myType2 = child.getElementType();
        }
    }

    private static boolean isWhiteSpace(ASTNode treePrev) {
        return treePrev != null && (treePrev.getElementType() == TokenType.WHITE_SPACE || treePrev.getTextLength() == 0);
    }

    private Spacing getResult() {
        Spacing result = this.myResult;
        this.clear();
        return result;
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        if (this.myRole1 == 88 && this.myRole2 == 74) {
            boolean space = false;
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 74 || this.myRole2 == 75) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
    }

    private void createSpaceInCode(boolean space) {
        this.createSpaceProperty(space, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    public void visitNewExpression(PsiNewExpression expression) {
        if (this.myRole2 == 77) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE);
        } else if (this.myRole1 == 69) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        this.visitArrayInitializer();
    }

    public void visitClass(PsiClass aClass) {
        if (this.myChild1.getElementType() == JavaDocElementType.DOC_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            return;
        }
        if (this.myRole2 == 18) {
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            int dependanceStart = nameIdentifier == null ? this.myParent.getTextRange().getStartOffset() : nameIdentifier.getTextRange().getStartOffset();
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.CLASS_BRACE_STYLE, new TextRange(dependanceStart, this.myChild1.getTextRange().getEndOffset()), false);
        } else if (this.myRole1 == 18) {
            this.myResult = !(aClass instanceof PsiAnonymousClass) ? Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_CLASS_HEADER + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS) : (this.myRole2 == 6 && JavaSpacePropertyProcessor.isTheOnlyClassMember(this.myChild2) ? Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS));
        } else {
            this.processClassBody();
        }
    }

    private static boolean isTheOnlyClassMember(ASTNode node) {
        ASTNode next = node.getTreeNext();
        if (next == null || next.getElementType() != JavaTokenType.RBRACE) {
            return false;
        }
        ASTNode prev = node.getTreePrev();
        return prev != null && prev.getElementType() == JavaTokenType.LBRACE;
    }

    private void processClassBody() {
        if (this.myChild1 instanceof JspJavaComment || this.myChild2 instanceof JspJavaComment) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else if (this.myRole2 == 5 || this.myChild2.getElementType() == JavaElementType.METHOD) {
            if (this.myRole1 == 18) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
            } else {
                int blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole2 == 6) {
            if (this.myRole1 == 18) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (this.myRole1 == 4) {
                int lines = Math.max(this.getLinesAroundField(), this.getLinesAroundMethod()) + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)(this.mySettings.SPACE_BEFORE_CLASS_LBRACE ? 1 : 0), (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE, (int)lines);
            } else {
                int blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole1 == 5 || this.myChild1.getElementType() == JavaElementType.METHOD) {
            if (this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                int blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole1 == 6) {
            if (this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)(this.isInsideAnonimusClass() ? 0 : 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                int blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole1 == 3) {
            if (this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                int blankLines = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole2 == 3) {
            if (this.myRole1 == 18) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
            } else {
                int blankLines = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole2 == 4) {
            if (this.myRole1 == 23) {
                this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (this.myRole1 == 18) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
            } else {
                int blankLines = this.getLinesAroundField() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole1 == 4) {
            if (this.myRole2 == 23) {
                ASTNode lastChildNode = this.myChild1.getLastChildNode();
                if (lastChildNode != null && lastChildNode.getElementType() == JavaTokenType.SEMICOLON) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                } else {
                    this.createSpaceProperty(false, false, 0);
                }
            } else if (this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                int blankLines = this.getLinesAroundField() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole2 == 23 || this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
            this.createSpaceProperty(false, false, 0);
        } else if (this.myRole1 == 23) {
            this.createSpaceProperty(this.mySettings.SPACE_AFTER_COMMA, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myRole1 == 8) {
            this.processModifierList();
        } else if (this.myRole1 == 18 && this.myRole2 == 19) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
        } else if (this.myRole2 == 12 || this.myRole2 == 13) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 245) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_TYPE_PARAMETER_LIST);
        } else if (this.myRole2 == 73) {
            this.createSpaceInCode(false);
        } else if (this.myRole2 == 19) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
        }
    }

    private boolean isInsideAnonimusClass() {
        return this.myParent instanceof PsiAnonymousClass;
    }

    private int getLinesAroundMethod() {
        if (JavaSpacePropertyProcessor.isClass(this.myParent)) {
            return this.mySettings.BLANK_LINES_AROUND_METHOD;
        }
        return this.mySettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE;
    }

    private int getLinesAroundField() {
        if (JavaSpacePropertyProcessor.isClass(this.myParent)) {
            return this.mySettings.BLANK_LINES_AROUND_FIELD;
        }
        return this.mySettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE;
    }

    private static boolean isClass(PsiElement parent) {
        if (parent instanceof PsiClass) {
            return !((PsiClass)parent).isInterface();
        }
        return false;
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        this.createSpaceInCode(true);
    }

    public void visitEnumConstantInitializer(PsiEnumConstantInitializer enumConstantInitializer) {
        if (this.myRole2 == 12 || this.myRole2 == 13) {
            this.createSpaceInCode(true);
        }
    }

    public void visitImportList(PsiImportList list) {
        if (ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(this.myChild1.getElementType()) && ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(this.myChild2.getElementType())) {
            if (this.myImportHelper == null) {
                this.myImportHelper = new ImportHelper(this.mySettings);
            }
            int emptyLines = this.myImportHelper.getEmptyLinesBetween((PsiImportStatementBase)SourceTreeToPsiMap.treeElementToPsi(this.myChild1), (PsiImportStatementBase)SourceTreeToPsiMap.treeElementToPsi(this.myChild2)) + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)emptyLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
    }

    public void visitFile(PsiFile file) {
        if (this.myType1 == JavaElementType.PACKAGE_STATEMENT) {
            int lf = this.mySettings.BLANK_LINES_AFTER_PACKAGE + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaElementType.PACKAGE_STATEMENT) {
            int lf = this.mySettings.BLANK_LINES_BEFORE_PACKAGE + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType1 == JavaElementType.IMPORT_LIST) {
            int lf = this.mySettings.BLANK_LINES_AFTER_IMPORTS + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaElementType.IMPORT_LIST) {
            int lf = this.mySettings.BLANK_LINES_BEFORE_IMPORTS + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaElementType.CLASS) {
            int lf = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement) {
        if (this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        } else if (this.myRole2 == 38 || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            if (this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_WHILE_LBRACE, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        }
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        if (this.myRole1 == 35 && this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        } else if (this.myRole2 == 38) {
            if (this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_DO_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        } else if (this.myRole1 == 38 || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            this.processOnNewLineCondition(this.mySettings.WHILE_ON_NEW_LINE);
        }
    }

    private void processOnNewLineCondition(boolean onNewLine) {
        if (onNewLine) {
            this.myResult = !this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE ? Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        if (this.myChild1.getElementType() == JavaTokenType.THROW_KEYWORD) {
            this.createSpaceInCode(true);
        }
    }

    public void visitTryStatement(PsiTryStatement statement) {
        if (this.myRole2 == 47) {
            this.processOnNewLineCondition(this.mySettings.FINALLY_ON_NEW_LINE);
        } else if (this.myRole2 == 48) {
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_TRY_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.myRole2 == 52) {
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_FINALLY_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.myRole2 == 251) {
            this.processOnNewLineCondition(this.mySettings.CATCH_ON_NEW_LINE);
        }
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        if (this.myRole1 == 37 && this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
        } else if (this.myRole1 == 125 && this.myRole2 == 87) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 87 && this.myRole2 == 124) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 38) {
            this.myResult = this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT ? this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) : (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE ? Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE));
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        if (this.myRole1 == 63 || this.myRole2 == 63) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        if (this.myRole1 == 24) {
            this.createParenSpace(this.mySettings.PARENTHESES_EXPRESSION_LPAREN_WRAP, this.mySettings.SPACE_WITHIN_PARENTHESES);
        } else if (this.myRole2 == 25) {
            this.createParenSpace(this.mySettings.PARENTHESES_EXPRESSION_RPAREN_WRAP, this.mySettings.SPACE_WITHIN_PARENTHESES);
        }
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.processCodeBlock(this.keepInOneLine(block), block.getTextRange());
    }

    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        TokenSet statementBitSet = ElementType.STATEMENT_BIT_SET;
        if (statementBitSet.contains(this.myChild1.getElementType()) && statementBitSet.contains(this.myChild2.getElementType())) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private void processCodeBlock(boolean keepInOneLine, TextRange textRange) {
        if (this.myParent instanceof JspCodeBlock) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 0 || this.myRole2 == 0) {
            IElementType firstElementType = this.myChild1.getElementType();
            this.myResult = firstElementType == JavaTokenType.END_OF_LINE_COMMENT || firstElementType == JavaTokenType.C_STYLE_COMMENT ? Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : null;
        } else if (this.myRole1 == 18) {
            this.myResult = !keepInOneLine ? Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole2 == 19) {
            this.myResult = !keepInOneLine ? Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE) : Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
        } else if (this.myChild1.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT && this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT) {
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, null, false);
        } else if (this.myRole1 == 56 && this.myRole2 == 56) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private boolean keepInOneLine(PsiCodeBlock block) {
        if (block.getParent() instanceof PsiMethod) {
            return this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE;
        }
        return this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
    }

    public void visitIfStatement(PsiIfStatement statement) {
        if (this.myRole2 == 31) {
            if (this.myChild1.getElementType() != JavaElementType.BLOCK_STATEMENT) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (this.mySettings.ELSE_ON_NEW_LINE) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.createSpaceProperty(true, false, 0);
            }
        } else if (this.myRole1 == 31) {
            if (this.myChild2.getElementType() == JavaElementType.IF_STATEMENT) {
                if (this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.createSpaceProperty(false, false, 0);
                } else {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
            } else if (this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_ELSE_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        } else if (this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            boolean space = this.myRole2 == 34 ? this.mySettings.SPACE_BEFORE_ELSE_LBRACE : this.mySettings.SPACE_BEFORE_IF_LBRACE;
            this.myResult = this.getSpaceBeforeLBrace(space, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
        } else if (this.myRole1 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
        } else if (this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
        } else if (this.myRole2 == 33) {
            this.createSpacingBeforeElementInsideControlStatement();
        }
    }

    private void createSpacingBeforeElementInsideControlStatement() {
        if (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE && this.myChild1.getElementType() != JavaTokenType.END_OF_LINE_COMMENT) {
            this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private Spacing createNonLFSpace(int spaces, TextRange dependantRange, boolean keepLineBreaks) {
        ASTNode prev = JavaSpacePropertyProcessor.getPrevElementType(this.myChild2);
        if (prev != null && prev.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (dependantRange != null) {
            return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependantRange, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static ASTNode getPrevElementType(ASTNode child) {
        return FormatterUtil.getLeafNonSpaceBefore(child);
    }

    private Spacing getSpaceBeforeLBrace(boolean spaceBeforeLbrace, int braceStyle, TextRange dependantRange, boolean keepOneLine) {
        if (dependantRange != null && braceStyle == 5) {
            int space = spaceBeforeLbrace ? 1 : 0;
            return this.createNonLFSpace(space, dependantRange, false);
        }
        if (braceStyle == 1 || braceStyle == 5) {
            int space = spaceBeforeLbrace ? 1 : 0;
            return this.createNonLFSpace(space, null, false);
        }
        if (keepOneLine) {
            int space = spaceBeforeLbrace ? 1 : 0;
            return Spacing.createDependentLFSpacing((int)space, (int)space, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    public void visitBinaryExpression(PsiBinaryExpression expression) {
        PsiJavaToken sign = expression.getOperationSign();
        IElementType i = sign.getTokenType();
        if (this.myRole1 == 63 || this.myRole2 == 63) {
            if (i == JavaTokenType.OROR || i == JavaTokenType.ANDAND) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS);
            } else if (i == JavaTokenType.OR || i == JavaTokenType.AND || i == JavaTokenType.XOR) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_BITWISE_OPERATORS);
            } else if (i == JavaTokenType.EQEQ || i == JavaTokenType.NE) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_EQUALITY_OPERATORS);
            } else if (i == JavaTokenType.GT || i == JavaTokenType.LT || i == JavaTokenType.GE || i == JavaTokenType.LE) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS);
            } else if (i == JavaTokenType.PLUS || i == JavaTokenType.MINUS) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_ADDITIVE_OPERATORS);
            } else if (i == JavaTokenType.ASTERISK || i == JavaTokenType.DIV || i == JavaTokenType.PERC) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS);
            } else if (i == JavaTokenType.LTLT || i == JavaTokenType.GTGT || i == JavaTokenType.GTGTGT) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_SHIFT_OPERATORS);
            } else {
                this.createSpaceInCode(false);
            }
        }
    }

    public void visitField(PsiField field) {
        if (this.myChild1.getElementType() == JavaDocElementType.DOC_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            return;
        }
        if (this.myRole1 == 20 || this.myRole2 == 20) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else if (this.myRole1 == 10 || this.myRole2 == 10) {
            this.createSpaceInCode(true);
        } else if (this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
            this.createSpaceProperty(false, false, 0);
        } else if (this.myRole1 == 8) {
            this.createSpaceProperty(true, false, 0);
        }
    }

    public void visitLocalVariable(PsiLocalVariable variable) {
        if (this.myRole1 == 20 || this.myRole2 == 20) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else if (this.myRole1 == 8) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 71 || this.myRole1 == 71) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 10 || this.myRole1 == 10) {
            this.createSpaceInCode(true);
        } else if (this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
            PsiElement ppp;
            PsiElement pp = this.myParent.getParent();
            if (pp instanceof PsiDeclarationStatement && (ppp = pp.getParent()) instanceof PsiForStatement) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON);
                return;
            }
            this.createSpaceProperty(false, false, 0);
        }
    }

    public void visitMethod(PsiMethod method) {
        if (this.myChild1.getElementType() == JavaDocElementType.DOC_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            return;
        }
        if (this.myRole2 == 14) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
        } else if (this.myRole1 == 14 && this.myRole2 == 16 || this.myRole1 == 245) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 17) {
            PsiIdentifier methodName = method.getNameIdentifier();
            int dependancyStart = methodName == null ? this.myParent.getTextRange().getStartOffset() : methodName.getTextRange().getStartOffset();
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.METHOD_BRACE_STYLE, new TextRange(dependancyStart, this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE);
        } else if (this.myRole1 == 8) {
            this.processModifierList();
        } else if (StdTokenSets.COMMENT_BIT_SET.contains(this.myChild1.getElementType()) && (this.myRole2 == 8 || this.myRole2 == 71)) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else if (this.myRole2 == 85) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 248) {
            this.createSpaceInCode(true);
        } else if (this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 10) {
            this.createSpaceInCode(true);
        }
    }

    private void processModifierList() {
        if (this.mySettings.MODIFIER_LIST_WRAP) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.createSpaceProperty(true, false, 0);
        }
    }

    public void visitModifierList(PsiModifierList list) {
        this.createSpaceInCode(true);
    }

    public void visitParameterList(PsiParameterList list) {
        if (this.myRole1 == 24 && this.myRole2 == 25) {
            this.createParenSpace(this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, false);
        } else if (this.myRole2 == 25) {
            this.createParenSpace(this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 24) {
            this.createParenSpace(this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        }
    }

    private void createParenSpace(boolean onNewLine, boolean space) {
        this.createParenSpace(onNewLine, space, this.myParent.getTextRange());
    }

    private void createParenSpace(boolean onNewLine, boolean space, TextRange dependance) {
        if (onNewLine) {
            int spaces = space ? 1 : 0;
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependance, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.createSpaceInCode(space);
        }
    }

    public void visitElement(PsiElement element) {
        if (this.myRole1 == 8) {
            this.processModifierList();
        }
    }

    public void visitExpressionList(PsiExpressionList list) {
        if (this.myRole1 == 24 && this.myRole2 == 25) {
            this.createParenSpace(this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE, false);
        } else if (this.myRole2 == 25) {
            this.createParenSpace(this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE, this.myRole1 == 23 || this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES);
        } else if (this.myRole1 == 24) {
            this.createParenSpace(this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(false);
        }
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        if (this.myRole1 == 79 || this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SYNCHRONIZED_PARENTHESES);
        } else if (this.myRole2 == 60) {
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_SYNCHRONIZED_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        if (this.myRole1 == 84 || this.myRole2 == 86) {
            this.createSpaceProperty(true, false, 0);
        }
    }

    public void visitSwitchStatement(PsiSwitchStatement statement) {
        if (this.myRole1 == 42 && this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
        } else if (this.myRole2 == 44) {
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        }
    }

    public void visitForStatement(PsiForStatement statement) {
        if (this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.myRole1 == 24) {
            ASTNode rparenth = JavaSpacePropertyProcessor.findFrom(this.myChild2, JavaTokenType.RPARENTH, true);
            if (rparenth == null) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
            } else {
                this.createParenSpace(this.mySettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, new TextRange(this.myChild1.getTextRange().getStartOffset(), rparenth.getTextRange().getEndOffset()));
                if (this.myChild2.getElementType() == JavaElementType.EMPTY_STATEMENT) {
                    this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON);
                }
            }
        } else if (this.myRole2 == 25) {
            ASTNode lparenth = JavaSpacePropertyProcessor.findFrom(this.myChild2, JavaTokenType.LPARENTH, false);
            if (lparenth == null) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
            } else {
                this.createParenSpace(this.mySettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, new TextRange(lparenth.getTextRange().getStartOffset(), this.myChild2.getTextRange().getEndOffset()));
            }
        } else if (this.myRole1 == 39) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
        } else if (this.myRole1 == 32) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON);
        } else if (this.myRole1 == 41) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
        } else if (this.myRole2 == 38 || this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            this.myResult = this.myChild2.getElementType() == JavaElementType.BLOCK_STATEMENT ? this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) : (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE ? Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE));
        }
    }

    private static ASTNode findFrom(ASTNode current, IElementType expected, boolean forward) {
        while (current != null) {
            if (current.getElementType() == expected) {
                return current;
            }
            current = forward ? current.getTreeNext() : current.getTreePrev();
        }
        return null;
    }

    public void visitCatchSection(PsiCatchSection section) {
        if (this.myRole2 == 49) {
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_CATCH_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.myRole2 == 50) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_CATCH_PARENTHESES);
        } else if (this.myRole1 == 50 || this.myRole2 == 51) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_CATCH_PARENTHESES);
        }
    }

    public void visitReferenceParameterList(PsiReferenceParameterList list) {
        if (this.myRole1 == 121 && this.myRole2 == 120) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 121 && this.myRole2 == 122) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 120 && this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 23 && this.myRole2 == 120) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 122) {
            this.createSpaceInCode(false);
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_CAST_PARENTHESES);
        } else if (this.myRole1 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_TYPE_CAST);
        }
    }

    private void createSpaceProperty(boolean space, int keepBlankLines) {
        this.createSpaceProperty(space, this.mySettings.KEEP_LINE_BREAKS, keepBlankLines);
    }

    private void createSpaceProperty(boolean space, boolean keepLineBreaks, int keepBlankLines) {
        ASTNode prev = JavaSpacePropertyProcessor.getPrevElementType(this.myChild2);
        if (prev != null && prev.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            if (!space && !JavaSpacePropertyProcessor.canStickChildrenTogether(this.myChild1, this.myChild2)) {
                space = true;
            }
            if (!keepLineBreaks && this.myRole2 == 0) {
                keepLineBreaks = true;
            }
            this.myResult = Spacing.createSpacing((int)(space ? 1 : 0), (int)(space ? 1 : 0), (int)0, (boolean)keepLineBreaks, (int)keepBlankLines);
        }
    }

    public void visitReferenceList(PsiReferenceList list) {
        if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 26 || this.myRole2 == 26) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 123 || this.myRole2 == 123) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 27 || this.myRole2 == 27) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 28) {
            this.createSpaceInCode(true);
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression) {
        if (this.myRole2 == 114) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_QUEST);
        } else if (this.myRole1 == 114) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_QUEST);
        } else if (this.myRole2 == 87) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COLON);
        } else if (this.myRole1 == 87) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COLON);
        }
    }

    public void visitStatement(PsiStatement statement) {
        if (this.myRole2 == 22) {
            this.createSpaceInCode(false);
        }
        if (statement instanceof JspClassLevelDeclarationStatement) {
            this.processClassBody();
        }
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        if (this.myChild2.getElementType() == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 65) {
            this.createSpaceInCode(true);
        } else {
            super.visitReturnStatement(statement);
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        if (this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
    }

    public void visitTypeParameter(PsiTypeParameter classParameter) {
        this.createSpaceInCode(true);
    }

    public void visitTypeElement(PsiTypeElement type) {
        if (this.myChild2.getElementType() == JavaTokenType.ELLIPSIS) {
            this.createSpaceInCode(false);
        } else if (this.myChild2.getElementType() == JavaTokenType.LBRACKET || this.myChild2.getElementType() == JavaTokenType.RBRACKET) {
            this.createSpaceInCode(false);
        } else {
            this.createSpaceInCode(true);
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement declarationStatement) {
        if (this.myRole2 == 23) {
            this.createSpaceProperty(false, false, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        }
    }

    public void visitTypeParameterList(PsiTypeParameterList list) {
        if (this.myRole2 == 122) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        }
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        if (this.myRole2 == 246) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_TYPE_PARAMETER_LIST);
        } else if (this.myRole2 == 55) {
            this.createSpaceInCode(false);
        }
    }

    public void visitAnnotation(PsiAnnotation annotation) {
        if (this.myRole2 == 14) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ANOTATION_PARAMETER_LIST);
        } else if (this.myChild1.getElementType() == JavaTokenType.AT && this.myChild2.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
            this.createSpaceInCode(false);
        }
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        if (this.myChild2.getElementType() == JavaElementType.CODE_BLOCK) {
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.BRACE_STYLE, null, false);
        }
    }

    public void visitAnnotationParameterList(PsiAnnotationParameterList list) {
        if (this.myRole1 == 24 && this.myRole2 == 25) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_ANNOTATION_PARENTHESES);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        }
    }

    public void visitNameValuePair(PsiNameValuePair pair) {
        if (this.myRole1 == 63 || this.myRole2 == 63) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
    }

    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        this.visitArrayInitializer();
    }

    private void visitArrayInitializer() {
        if (this.myRole1 == 18) {
            if (this.mySettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE) {
                int spaces = this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES ? 1 : 0;
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.createSpaceProperty(this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (this.myRole2 == 18) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE);
        } else if (this.myRole2 == 19) {
            if (this.mySettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE) {
                int spaces = this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES ? 1 : 0;
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                this.createSpaceProperty(this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES, this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            }
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        }
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        } else if (this.myRole2 == 70) {
            this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.METHOD_BRACE_STYLE, enumConstant.getTextRange(), this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE);
        }
    }

    public void visitDocTag(PsiDocTag tag) {
        if (this.myChild1.getElementType() == JavaDocTokenType.DOC_TAG_NAME && this.myChild2.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        if (this.myChild1.getElementType() == JavaTokenType.ASSERT_KEYWORD) {
            this.createSpaceInCode(true);
        } else if (this.myChild1.getElementType() == JavaTokenType.COLON) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COLON);
        } else if (this.myChild2.getElementType() == JavaTokenType.COLON) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COLON);
        }
    }

    public void visitParameter(PsiParameter parameter) {
        if (this.myRole1 == 10 || this.myRole1 == 8) {
            this.createSpaceInCode(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Spacing getSpacing(ASTNode node, CodeStyleSettings settings) {
        JavaSpacePropertyProcessor spacePropertyProcessor = mySharedProcessorAllocator.get();
        try {
            if (spacePropertyProcessor == null) {
                spacePropertyProcessor = new JavaSpacePropertyProcessor();
                mySharedProcessorAllocator.set(spacePropertyProcessor);
            }
            spacePropertyProcessor.doInit(node, settings);
            Spacing spacing = spacePropertyProcessor.getResult();
            return spacing;
        }
        finally {
            spacePropertyProcessor.clear();
        }
    }

    private static boolean isWS(ASTNode lastChild) {
        return lastChild != null && lastChild.getElementType() == TokenType.WHITE_SPACE;
    }

    public static boolean canStickChildrenTogether(ASTNode child1, ASTNode child2) {
        if (child1 == null || child2 == null) {
            return true;
        }
        if (JavaSpacePropertyProcessor.isWS(child1) || JavaSpacePropertyProcessor.isWS(child2)) {
            return true;
        }
        LeafElement token1 = TreeUtil.findLastLeaf(child1);
        LeafElement token2 = TreeUtil.findFirstLeaf(child2);
        LOG.assertTrue(token1 != null);
        LOG.assertTrue(token2 != null);
        return !(token1.getElementType() instanceof IJavaElementType) || !(token2.getElementType() instanceof IJavaElementType) || JavaSpacePropertyProcessor.canStickJavaTokens(token1, token2);
    }

    private static boolean canStickJavaTokens(ASTNode token1, ASTNode token2) {
        IElementType type2;
        IElementType type1 = token1.getElementType();
        Pair pair = new Pair((Object)type1, (Object)(type2 = token2.getElementType()));
        Boolean res = myCanStickJavaTokensMatrix.get(pair);
        if (res == null) {
            if (!JavaSpacePropertyProcessor.checkToken(token1) || !JavaSpacePropertyProcessor.checkToken(token2)) {
                return true;
            }
            String text = token1.getText() + token2.getText();
            JavaLexer lexer = new JavaLexer(LanguageLevel.HIGHEST);
            lexer.start(text);
            boolean canMerge = lexer.getTokenType() == type1;
            lexer.advance();
            res = canMerge &= lexer.getTokenType() == type2;
            myCanStickJavaTokensMatrix.put((Pair<IElementType, IElementType>)pair, res);
        }
        return res;
    }

    private static boolean checkToken(ASTNode token1) {
        JavaLexer lexer = new JavaLexer(LanguageLevel.HIGHEST);
        String text = token1.getText();
        lexer.start(text);
        if (lexer.getTokenType() != token1.getElementType()) {
            return false;
        }
        lexer.advance();
        return lexer.getTokenType() == null;
    }
}

